import sha, os, sys, time
import config, message, sql

class Domain :

	domain_list = []

	rcpthosts_list = {}
	locals_list = {}
	virtualdomains_list = {}
	assign_list = {}

	QMAIL_DEFAULT = "| %s $EXT@$HOST"

	QMAILD_UID = None
	QMAIL_GID = None

	#ASSIGN_ONE = "+%s-:%s:%s:%s:%s/%s:-::"
	ASSIGN_ONE = "+%s-:%s:%s:%s:%s:-::"

	action = {}
	action["add"] = "remove"
	action["remove"] = "add"

 	def __init__ (self) :
 		""" """

		pass

	#-------------------------------------------------- check file permission.
	def __check_file_permission (self, f) :

		MSG = \
"""Can not make "%s".
Please check it's permissions.

"""

		if os.path.exists(f) :
			try :
				f = open(f, "a")
			except IOError :
				sys.stderr.write(MSG % f)
				sys.exit(1)
			else :
				f.close()
				retval = True
		else :
			try :
				f = open(f, "w")
			except IOError :
				sys.stderr.write(MSG % f)
				sys.exit(1)
			else :
				f.close()
				retval = True

		return retval

	#-------------------------------------------------- make a domain list.
	def __get_domain_list (self) :
		try :
			f = open(config.qmail["file"]["rcpthosts"], "r")
		except :
			self.domain_list = []
		else :
			a = f.readlines()

			for i in a :
				self.domain_list.append(i.strip())

#	#--------------------------------------------------
# 	def __make_qmail_default(self, domain) :
# 		""" """
# 
# 		try :
# 			f = open(config.qmail["file"]["qmail_default"] % domain, "w")
# 		except :
# 			retval = False
# 		else :
# 			f.write(self.QMAIL_DEFAULT % config.qmail["file"]["getmail"])
# 			f.close()
# 
# 			retval = True
# 
# 		return retval
# 
# 	def __remove_qmail_default(self, domain) :
# 		""" """
# 
# 		try :
# 			os.remove(config.qmail["file"]["qmail_default"] % domain)
# 		except :
# 			retval = False
# 		else :
# 			retval = True
# 
# 		return retval
# 
# 	def __qmail_default (self, action, domain) :
# 
# 		if action == "add" :
# 			if self.__make_qmail_default(domain) :
# 				retval = True
# 			else :
# 				retval = False
# 		elif action == "remove" :
# 			if self.__remove_qmail_default(domain) :
# 				retval = True
# 			else :
# 				retval = False
# 		else :
# 			retval = False
# 
# 		return retval

	#--------------------------------------------------
	def __remove_domain_directory(self, domain) :
		""" """
		try :
			os.rmdir("%s/%s" % (config.qmail["directory"]["domains"], domain))
		except :
			retval = False
		else :
			retval = True

		return retval

	def __make_domain_directory(self, domain) :
		""" """

		try :
			os.mkdir("%s/%s" % (config.qmail["directory"]["domains"], domain))
		except :
			retval = False
		else :
			retval = True

		return retval

	def __domain_directory (self, action, domain) :

		if action == "add" :
			if self.__make_domain_directory(domain) :
				retval = self.__qmail_default("add", domain)

			else :
				retval = False
		elif action == "remove" :
			if self.__qmail_default("remove", domain) :
				retval = self.__remove_domain_directory(domain)
			else :
				retval = False
		else :
			retval = False

		return retval

	#--------------------------------------------------
	def __get_virtualdomains (self) :

		self.__check_file_permission(config.qmail["file"]["virtualdomains"])

		# make a virtualdomains list.
		try :
			f = open(config.qmail["file"]["virtualdomains"], "r")
		except :
			self.virtualdomains_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a :
				self.virtualdomains_list.update({i.strip().split(":")[0] : True})

	def __virtualdomains (self, action, domain) :
		"""
		retval
			-2 : domain is alread exists.
			-3 : domain name is not valid
			False : action failed
			True : action success.
		"""

		# check whether domain name is valid or not.
		self.__get_virtualdomains()

		if action == "add" :
			if domain in self.virtualdomains_list.keys() :
				retval = -2
			else :
				try :
					f = open(config.qmail["file"]["virtualdomains"], "a")
				except :
					retval = False
				else :
					f.write("%s:%s\n" % (domain, domain))
					f.close()

					retval = True

		elif action == "remove" :
			if not domain in self.virtualdomains_list.keys() :
				retval = -2
			else :
				cur_list = self.virtualdomains_list
				del(cur_list[domain])

				try :
					f = open(config.qmail["file"]["virtualdomains"], "w")
				except :
					retval = False
				else :
					a = []
					if len(cur_list) < 1 :
						pass
					else :
						for i in cur_list.keys() :
							a.append("%s:%s" % (i, i))

						f.write("%s\n" % "\n".join(a))

					f.close()

					retval = True
		else :
			retval = False

		if retval : self.__get_virtualdomains()

		return retval

	#--------------------------------------------------
	def __get_locals (self) :

		self.__check_file_permission(config.qmail["file"]["locals"])

		# make a locals list.
		try :
			f = open(config.qmail["file"]["locals"], "r")
		except :
			self.locals_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a : self.locals_list.update({i.strip() : True})

# 	def __locals (self, action, domain) :
# 		"""
# 		retval
# 			-2 : domain is alread exists.
# 			-3 : domain name is not valid
# 			False : action failed
# 			True : action success.
# 		"""
# 
# 		# check whether domain name is valid or not.
# 		self.__get_locals()
# 
# 		if action == "add" :
# 			if domain in self.locals_list.keys() :
# 				retval = -2
# 			else :
# 				try :
# 					f = open(config.qmail["file"]["locals"], "a")
# 				except :
# 					retval = False
# 				else :
# 					f.write("%s\n" % domain)
# 					f.close()
# 
# 					retval = True
# 
# 		elif action == "remove" :
# 			if not domain in self.locals_list.keys() :
# 				retval = -2
# 			else :
# 				cur_list = self.locals_list
# 				del(cur_list[domain])
# 
# 				try :
# 					f = open(config.qmail["file"]["locals"], "w")
# 				except :
# 					retval = False
# 				else :
# 					if len(cur_list) < 1 :
# 						pass
# 					else :
# 						f.write("%s\n" % "\n".join(cur_list.keys()))
# 
# 					f.close()
# 
# 					retval = True
# 		else :
# 			retval = False
# 
# 		if retval : self.__get_locals()
# 
# 		return retval

	def __get_rcpthosts (self) :

		self.__check_file_permission(config.qmail["file"]["rcpthosts"])

		# make a rcpthosts list.
		try :
			f = open(config.qmail["file"]["rcpthosts"], "r")
		except :
			self.rcpthosts_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a : self.rcpthosts_list.update({i.strip() : True})

	def __rcpthosts (self, action, domain) :
		"""
		retval
			-2 : domain is alread exists.
			-3 : domain name is not valid
			False : action failed
			True : action success.
		"""

		# check whether domain name is valid or not.
		self.__get_rcpthosts()

		if action == "add" :
			if domain in self.rcpthosts_list.keys() :
				retval = -2
			else :
				try :
					f = open(config.qmail["file"]["rcpthosts"], "a")
				except :
					retval = False
				else :
					f.write("%s\n" % domain)
					f.close()

					retval = True

		elif action == "remove" :
			if not domain in self.rcpthosts_list.keys() :
				retval = -2
			else :
				cur_list = self.rcpthosts_list
				del(cur_list[domain])

				try :
					f = open(config.qmail["file"]["rcpthosts"], "w")
				except :
					retval = False
				else :
					if len(cur_list) < 1 :
						pass
					else :
						f.write("%s\n" % "\n".join(cur_list.keys()))

					f.close()

					retval = True
		else :
			retval = False

		if retval : self.__get_rcpthosts()

		return retval

	#--------------------------------------------------
	def __get_assign (self) :

		self.__check_file_permission(config.qmail["file"]["assign"])

		try :
			f = open(config.qmail["file"]["assign"], "r")
		except :
			self.assign_list = {}
		else :
			a = f.readlines()
			f.close()

			for i in a :
				if i.strip() == "." : continue

				try :
					k = i.strip().split(":")[1]
				except IndexError :
					continue
				else :
					self.assign_list.update({ k : i.strip()})

	def __assign (self, action, domain) :

		# check whether domain name is valid or not.
		self.__get_assign()

		if action == "add" :
			if domain in self.assign_list.keys() :
				retval = -2
			else :
				try :
					f = open(config.qmail["file"]["assign"], "w")
				except :
					retval = False
				else :

					self.QMAILD_UID = os.popen("id -u qmaild").read().strip()
					self.QMAIL_GID = os.popen("id -g qmaild").read().strip()

					if len(self.assign_list) < 1 :
						prev_assign_list = ""
					else :
						prev_assign_list = "\n".join(self.assign_list.values()) + "\n"

# 					f.write("%s%s\n." % (prev_assign_list, \
# 						self.ASSIGN_ONE % \
# 						(domain, domain, self.QMAILD_UID, self.QMAIL_GID, \
# 						config.qmail["directory"]["domains"], domain)))
					f.write("%s%s\n." % (prev_assign_list, \
						self.ASSIGN_ONE % \
						(domain, domain, self.QMAILD_UID, self.QMAIL_GID, \
						config.qmail["directory"]["domains"])))
					f.close()

					retval = True

		elif action == "remove" :
			if not domain in self.assign_list.keys() :
				retval = -2
			else :
				cur_list = self.assign_list
				del(cur_list[domain])

				try :
					f = open(config.qmail["file"]["assign"], "w")
				except :
					retval = False
				else :
					if len(cur_list) < 1 :
						f.write(".")
					else :
						f.write("%s\n.\n" % "\n".join(cur_list.values()))

					f.close()

					retval = True
		else :
			retval = False

		if retval :
			self.__update_assign()
			self.__get_assign()

		return retval

	def __update_assign (self) :
		a = os.system(config.qmail["file"]["qmail-newu"])

		if a == 0 :
			retval = True
		else :
			retval = False

		return retval

	#--------------------------------------------------
	def add (self, domain) :
		retval = self.__domain("add", domain);

		return retval

	def remove (self, domain) :
		retval = self.__domain("remove", domain);

		return retval
		
 	def __domain (self, action, domain) :
 		"""
		* job sequence
			rcpthosts
			virtualdomains
			make directory
			make .qmail-default file
			assign
			execute qmail-newu

		* return value
			True : success
			False : failed

			-4 : login failed
			-3 : it's not valid domain
			-2 : it's already exists
		"""
		self.domain_list = []

		self.rcpthosts_list = {}
		self.virtualdomains_list = {}
		self.assign_list = {}

		retval = True

		if not message.is_valid_domain(domain) : retval = -3

		self.__get_domain_list()

		if retval == True :
			# locals
			#retval = self.__locals(action, domain)

			# rcpthosts
			retval = self.__rcpthosts(action, domain)

			# virtualdomains
			if retval == True :
				retval = self.__virtualdomains(action, domain)
			elif retval == False :
				self.__rcpthosts(self.action[action], domain)
				self.__locals(action, domain)

				retval = False

# 			# domain directory
# 			if retval == True :
# 				retval = self.__domain_directory(action, domain)
# 			elif retval == False :
# 				self.__rcpthosts(self.action[action], domain)
# 				self.__virtualdomains(self.action[action], domain)
# 
# 				retval = False

			# assign
			if retval == True :
				retval = self.__assign(action, domain)
			elif retval == False :
				#self.__locals(action, domain)
				self.__rcpthosts(self.action[action], domain)
				self.__virtualdomains(self.action[action], domain)

				#self.__domain_directory(self.action[action], domain)
				#retval = self.__qmail_default(self.action[action], domain)

				retval = False

 		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Domain.py"


# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


