import sys, os, time

def getTime (mode=None, format=None) :

	if mode == 1 :
		if not format : format = "%Y %B %d %a %H:%M.%S"

		retval = time.strftime(format, time.localtime())
	else :
		retval = int(time.time())

	return retval

def end (mode=0, **kwargs) :

	kwargs["log"].close()

	if kwargs.has_key("db") : kwargs["db"].close()
	if kwargs.has_key("smtp") : kwargs["smtp"].quit()
	if kwargs.has_key("pid") : pid(1, kwargs["pid"])
	if mode != None : sys.exit(mode)

def pid (mode, file) :
	"""
	mode = 0 : create pid file
	mode = 1 : remove pid file
	"""

	if mode == 0 :
		try :
			f = open(file, "w")
			f.write("%s" % os.getpid())
			f.close()
		except :
			print "Can not create pid file, %s" % file
			sys.exit(1)

	elif mode == 1 :
		if os.path.exists(file) :
			try :
				os.remove(file)
			except :
				print "Can not remove pid file, %s" % file
				sys.exit(1)


"""
Description
-----------
Misc functions

ChangeLog
---------
Mon Feb 17 09:11:21 KST 2003
- created.

Tue Mar  4 18:20:47 KST 2003
- getTime() added. It support a formatted time and unix timestamp.

Usage
-----


"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "function.py"


# Mesian is Webmail.
#
# Copyright (C) 2003 Spike^ekipS <spike@spikeekips.net>
#
# Adapted from mesian :
#  Copyright (C) 2003  Spike^ekipS <spike@spikeekips.net>
#
# Contact: mailto:spike@spikeekips.net
# Original site: http://mesian-devel.spikeekips.net/
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Spike^ekipS
#	mailto:spike@spikeekips.net
#
# Original page :
#	http://mesian-devel.spikeekips.net/
#
# Original mesian :
#	Spike^ekipS
#	spike@spikeekips.net
#	Haman Korea


