<?

include_once $global["root"] . "/lib/Domain.php";
include_once $global["root"] . "/lib/Authentication.php";
include_once $global["root"] . "/lib/MySQLdb.php";
include_once $global["root"] . "/lib/Session.php";
include_once $global["root"] . "/lib/Mail.php";
include_once $global["root"] . "/lib/Template.php";

class Site {

	var $URL_MAIL = "Location: http://%s/mail";
	var $URL_FORUM = "Location: http://%s/forum";
	var $URL_NONE = "Location: http://%s/invalid";

	var $DB;
	var $Session;
	var $Template;

	function Site ($type=false, $httpd_method=false) {

		if ($type) $this->init($type, $httpd_method);

		$this->Template = new Template;

	}

	function get_domain_id ($type="") {
		$Domain = new Domain;

		switch ($type) {
			case ("domain") :
				$this->domain_id = $Domain->get_id_by_www($_SERVER["HTTP_HOST"]);
			break;
			case ("mail") :
				$this->domain_id = $Domain->get_id_by_www($_SERVER["HTTP_HOST"]);
			break;
			case ("forum") :
				$this->domain_id = $Domain->get_id_by_forum($_SERVER["HTTP_HOST"]);
			break;
			default :
				$this->domain_id = $Domain->get_id($_SERVER["HTTP_HOST"]);
		}
	}

	////////////////////////////////////////////////////////////////////////
	function init ($type="mail", $http_method="_POST") {
		global $global;

		// connect DB
		$this->connect_db();

		//$this->get_domain_id($type);

		$this->start_session();

		// set module type.
		$_SESSION["user_module"] = $type;

		// check security on user.
		$this->__check_authentication($http_method);

		// reg_session
		$this->reg_session($type);

	}

	function init2 ($type="mail", $http_method="_POST") {
		// for non-privileged user.
		global $global;

		// connect DB
		$this->connect_db();

		//$this->get_domain_id($type);

		$this->start_session();

		// set module type.
		$_SESSION["user_module"] = $type;

		// check security on user.
		//$this->__check_authentication($http_method);

		// reg_session
		$this->reg_session($type);

	}

	function end() {

		// remove temporarily stored msg.
		if ($_SESSION["user_msg"]) unset($_SESSION["user_msg"]);
		if ($_SESSION["user_menu"]) unset($_SESSION["user_menu"]);

		$this->end1();
	}

	function end1() {

		session_write_close(); // write session

		// close DB connection.
		mysql_query("======================================"); // remove this.
		$this->close_db();
	}

	////////////////////////////////////////////////////////////////////////
	function set_direction () {
		// set the forum or mail.
		$Domain = new Domain;

		switch ($Domain->get_domain_type($_SERVER["HTTP_HOST"])) {
			case ("forum") :
				$_SESSION["user_module"] = "forum";
				Header(sprintf($this->URL_FORUM, $_SERVER["HTTP_HOST"]));
				exit;
			break;
			case ("www") :
				$_SESSION["user_module"] = "mail";
				Header(sprintf($this->URL_MAIL, $_SERVER["HTTP_HOST"]));
				exit;
			break;
			default :
				session_destroy();
				Header(sprintf($this->URL_NONE, $_SERVER["HTTP_HOST"]));
				exit;
		}
	}

	function set_module () {

		if (! $_SESSION["user_module"]) {
			$retval = false;
		} else {
			switch ($_SESSION["user_module"]) {
				case ("mail") :
					$retval = "Mail";
				break;
				case ("forum") :
					$retval = "Forum";
				break;
				case ("domain") :
					$retval = "Domain";
				break;
				default :
					$retval = false;
			}
		}

		return $retval;
	}

	////////////////////////////////////////////////////////////////////////
	function __check_authentication($http_method=false) {
		global $global;

		if ($_SESSION) {

			// execute authentication check.
			switch ($this->set_module()) {
				case ("Mail") :
					include_once $global["root"] . "/lib/Authentication_Mail.php";
					$Auth = new Authentication_Mail;
				break;
				case ("Forum") :
					include_once $global["root"] . "/lib/Authentication_Forum.php";
					$Auth = new Authentication_Forum;
				break;
				case ("Domain") :
					include_once $global["root"] . "/lib/Authentication_Domain.php";
					$Auth = new Authentication_Domain;
				break;
			}

			if ($Auth) {
				//-------------------------------------------------- check on security
				if ($http_method) $Auth->escape($http_method);

				$Auth->check();
			}
		}

	}

	function connect_db () {
		global $db;

		//-------------------------------------------------- db connection
		$this->DB = new MySQLdb;
		$this->DB->connect($db);

		if ($this->DB->retval) { // mysql connect.
			$this->DB->set_db($db["database"]);

		} else {
			$Auth = new Authentication;
			$Auth->logout();
		}
	}

	function start_session () {

		$this->Session = new Session;
	}

	function close_db () {

		if ($this->DB) {
			$this->DB->quit();
		} else {
			$DB = new MySQLdb;
			$DB->quit();
		}
	}

	function reg_session () {

		$_SESSION["user_global_url"] = sprintf("http://%s", $_SERVER["HTTP_HOST"]);

		// www (mail)
		$_SESSION["user_www_url"] = sprintf("http://%s", $_SESSION["config_www_name"]);
		// forum
		$_SESSION["user_forum_url"] = sprintf("http://%s", $_SESSION["config_forum_name"]);
	}

	////////////////////////////////////////////////////////////////////////
	function msg () {
		// msg

		if (! $_SESSION["user_msg"]["content"]) {
			$retval = false;
		} else {
			$var["content"] = $_SESSION["user_msg"]["content"];

			// msg_type :
			//	1 : warning
			//	2 : info
			switch ($_SESSION["user_msg"]["type"]) {
				case ("2") :
					$var["type"] = "msg_info";
					$var["msg"] = $string["error_type"];
				break;
				default :
					$var["type"] = "msg_warning";
					$var["msg"] = $string["error_type1"];
			}

			$retval = $this->Template->generate("/template/msg", $var);
		}

		return $retval;
	}
}

function print_frontpage ($what="") {
	global $global, $string;

	$Template = new Template;

	if ($_SESSION["config_full_name"]) {
		$main["welcome"] = sprintf($string["page9"], $_SESSION["config_full_name"]);
	} else {
		$Address = new Address($_SESSION["config_address"]);
		$a = $Address->return_split();
		$main["welcome"] = sprintf($string["page9"], $a["short"]);
	}

	$number = check_newmail();

	if ($number > 0) {
		$main["unread_message"] = sprintf($string["page10"], $number);

		$main["inbox"] = sprintf("<a
				href=\"$_SESSION[user_www_url]/mail?no=1\">%s (%s) </a>",
				$string["directory1"], $number);
	} else {
		$main["unread_message"] = $string["page11"];
	}

	// quota warning
	$Directories = new Directories;

	$main["quota"] = $Directories->return_disk_usage();

	/*
	// forum subject list
	$Forum = new Forum();
	$main["forum_list"] = $Forum->return_latest_subject_list();
	*/

	$retval = $Template->generate("/template/frontpage", $main);

	return $retval;
}

function print_invalid_forum_page () {
	global $global, $string;

	$Template = new Template;

	$retval = $Template->generate("/template/invalid_forum", $main);

	return $retval;
}


/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
