<?

require_once "XML/Parser.php";
require_once "XML/RPC.php";

function sendmailThruXMLRPC ($server, $port) {

	$client = new XML_RPC_Client("/RPC2", $server, $port);
	$msg = new XML_RPC_Message("do");

	if ($client->send($msg)) {
		$retval = true;
	} else {
		$retval = false;
	}

	return $retval;
}

/*
Description
-----------
Ask a sending mail to XML-RPC sendmail daemon.

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Wed Mar  5 17:48:47 KST 2003
- created.

Usage
-----

Reference
---------
	require_once "XML/RPC.php";
	require_once "slides/mdb/scripts/xmlrpc_util.php";
	require_once "slides/mdb/scripts/mdb_tests.cfg";

	$method = "method.sql";
	$query = "select source_id,expdata,resolution,description ";
	$query .= "from protein where expdata like '%x-ray%' and ";
	$query .= "resolution >= 0.7 order by resolution limit 5";
	$q = new XML_RPC_Value($query, $GLOBALS['XML_RPC_String']);
	$msg = new XML_RPC_Message($method,array($q));

	$c=new XML_RPC_Client(XMLRPC_URI, MDB_SERVER_NAME, MDB_SERVER_PORT);
	$r = $c->send($msg);
	if (!$r->faultCode()) {
		 echo toTable(XML_RPC_decode($r->value()));
	} else {
		 echo "<pre>\n";
		 echo "ERROR: ".$r->faultCode()." -- ".$r->faultString();
		 echo "</pre>\n";
	}

*/

?>
