# -*- coding: utf-8 -*-
import sql, myMySQLdb, Pop3, Imap

class RemoteMail :

	user_id = None
	address = None

	db = None
	POP3 = None
	IMAP = None

	def __init__ (self, db, user_id, address) :

		self.user_id = user_id
		self.address = address

		self.POP3 = Pop3.Pop3()
		self.IMAP = Imap.Imap()

		self.db = myMySQLdb.myMySQLdb(db)

	def check (self) :

		o = self.db.fetch_one(sql.SQL_CHECK_REMOTE_SERVER % (self.user_id))

		if not o :
			retval = False
		else :
			if o["num"] < 1 :
				retval = False
			else :
				retval = True

		return retval

	def fetch_all (self) :

		if not self.check() :
			retval = False
		else :

			# get server list
			self.db.query(sql.SQL_GET_REMOTE_SERVER % (self.user_id), True)

			server_list = { "imap" : [], "pop3" : []}
			for i in range(self.db.num_rows) :
				o = self.db.fetch()

				if o["type"] in ["imap", "pop3"] :
					server_list[o["type"]].append( (o["no"], o["servername"], o["port"], \
						o["username"], o["password"]) )

			# fetch message from remote mail server.
			is_success = {} # is successfully fetched?

			# Imap
			if len(server_list["imap"]) > 0 :

				for no, servername, port, username, password in server_list["imap"] :
					is_success[no] = self.__get_from_imap(servername, port, username, password)

				retval = True

			# pop3
			elif len(server_list["pop3"]) > 0 :

				for no, servername, port, username, password in server_list["pop3"] :
					is_success[no] = self.__get_from_pop3(servername, port, username, password)

				retval = True

			else :
				retval = False

			if len(is_success) > 0 :
				failed = []
				success = []
				for i in is_success.keys() :
					if is_success[i] == True :
						success.append("no = '%s'"% i)
					else :
						failed.append("no = '%s'" % i)

				added_query_success = " or ".join(success)
				added_query_failed = " or ".join(failed)

				if len(success) > 0 :
					self.db.start_transaction(True)

					self.db.query(sql.SQL_UPDATE_REMOTE_SERVER_SUCCESS % \
						(self.user_id, added_query_success))

					self.db.close()

				if len(failed) > 0 :
					self.db.start_transaction(True)

					self.db.query(sql.SQL_UPDATE_REMOTE_SERVER_FAILED % \
						(self.user_id, added_query_failed))

					self.db.close()

			return retval

	def __get_from_pop3 (self, servername, port, username, password) :

		if not port : port = Pop3.PORT

		if not self.POP3.connect( \
					host=servername, port=port, user=username, password=password \
				) :

			retval = False
		else :
			retval = True

			for i in range(self.POP3.num_of_message) :
				data = self.POP3.fetch()

				if data :
					if self.__insert_db(myMySQLdb.escape_string(data)) :
						self.POP3.remove()

				del data

			self.POP3.logout()

		return retval

	def __get_from_imap (self, servername, port, username, password) :

		if not port : port = Imap.PORT

		if not self.IMAP.connect( \
					host=servername, port=port, user=username, password=password \
				) :

			retval = False
		else :
			retval = True

			for i in range(self.IMAP.num_of_message) :
				data = self.IMAP.fetch()

				if data :
					if self.__insert_db(myMySQLdb.escape_string(data)) :
						self.POP3.remove()

				del data

			self.IMAP.logout()

		return retval

	def __insert_db (self, message) :

		self.db.start_transaction(True)

		self.db.query( \
			sql.SQL_INSERT_QUEUE_INCOMING % \
			(self.address, myMySQLdb.escape_string(message) ) \
		)

		retval = self.db.retval

		self.db.close()

		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "RemoteMail.py"

