import sys, os, time

def getTime (mode=None, format=None) :

	if mode == 1 :
		if not format : format = "%Y %B %d %a %H:%M.%S"

		retval = time.strftime(format, time.localtime())
	else :
		retval = int(time.time())

	return retval

def end (mode=0, **kwargs) :

	kwargs["log"].close()

	if kwargs.has_key("db") : kwargs["db"].close()
	if kwargs.has_key("smtp") : kwargs["smtp"].quit()
	if kwargs.has_key("pid") : pid(1, kwargs["pid"])
	if mode != None : sys.exit(mode)

def pid (mode, file) :
	"""
	mode = 0 : create pid file
	mode = 1 : remove pid file
	"""

	if mode == 0 :
		try :
			f = open(file, "w")
			f.write("%s" % os.getpid())
			f.close()
		except :
			print "Can not create pid file, %s" % file
			sys.exit(1)

	elif mode == 1 :
		if os.path.exists(file) :
			try :
				os.remove(file)
			except :
				print "Can not remove pid file, %s" % file
				sys.exit(1)


"""
Description
-----------
Misc functions

ChangeLog
---------
Mon Feb 17 09:11:21 KST 2003
- created.

Tue Mar  4 18:20:47 KST 2003
- getTime() added. It support a formatted time and unix timestamp.

Usage
-----


"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "function.py"

