import SimpleXMLRPCServer, SocketServer, thread, time, threading
import config

class myXMLRPCServer (SocketServer.ThreadingTCPServer) :

	# for daemon parameters
	__func_daemon = None
	__args_daemon = None
	__interval_daemon = 0

	def __init__(self, addr, \
			requestHandler=SimpleXMLRPCServer.SimpleXMLRPCRequestHandler, logRequests=1):

		self.funcs = {}
		self.logRequests = logRequests
		self.instance = None
		SocketServer.ThreadingTCPServer.__init__(self, addr, requestHandler)

		self.__lock = threading.Lock()

	def register_instance(self, instance):

		self.instance = instance

	def register_function(self, function, name = None):

		if name is None:
			name = function.__name__

		self.funcs[name] = function

	def handle_request (self) :

		SocketServer.ThreadingTCPServer.handle_request(self)

	def start (self) :
		"""
		start() run two threads. One is main server and the other is daemon.
		"""
		self.__lock.acquire()

		thread.start_new_thread(self.serve_forever, ())
		thread.start_new_thread(self.run_daemon, ())

	def register_daemon (self, function, args=(), interval=None) :
		"""
		Register function as daemon.
		"""

		self.__func_daemon = function
		self.__args_daemon = args

		if type(interval) == int :
			self.__interval_daemon = interval
		else :
			self.__func_daemon = None

	def run_daemon (self) :

		if self.__func_daemon and self.__interval_daemon > 0 :
			while 1 :
				try :
					apply(self.__func_daemon, self.__args_daemon)
				except :
					pass

				time.sleep(self.__interval_daemon)

	def serve_forever(self) :

		while 1 :
			self.handle_request()

class RequestHandler (SimpleXMLRPCServer.SimpleXMLRPCRequestHandler) :
	"""
	Psuedo request handler
	"""

	method_name = None

	def _dispatch(self, method, params) :

		"""
		Allowed client was registered as rpc["allowed_client"] in setting.py.
		"""

		#-------------------------------------------------- client handling
		if self.client_address[0] in config.rpc["allowed_client"] :
			is_valid_address = True
		else :
			is_valid_address = False

		if not is_valid_address :
			retval = False
		else :
			self.method_name = method

			retval = SimpleXMLRPCServer.SimpleXMLRPCRequestHandler._dispatch( \
				self, method, params)

		return retval

	def log_message (self, format, *args) :

		pass

"""
Description
-----------
xml-rcp Main Server.

Usage
-----
# initialize.
insServer = server.server()

# start/stop server.
insServer.start(instance status)
insServer.stop()

Changelog
---------
2003. 01. 03. 15:27:33 KST
- new design applied.

Wed Mar  5 15:04:43 KST 2003
- remove server class.

Wed Jun 11 07:27:31 KST 2003
- no sys.stderr

Thu Jun 12 11:18:41 KST 2003
- new xmlrpcserver class added for threading.

"""

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

