import sql, myMySQLdb, message, sre

class Filter :

	"""
	Name Space,
		0 : global filter rule set
		1 : domain filter rule set
		2 : user filter rule set

	* Rule set
		0, global
			- global filter rule set was set in mail_filter_global table.

		1, domain
			- domain filter rule set was set in mail_filter_<domain id> table.
			- domain filter rule set was defined with <domain id>, which was set in
			  domain_priv table.

		2, user
			- user filter rule set was set in mail_filter_<user id> table.
			- user filter rule set was defined with <user id>, which was set in
			  user_priv table.
	"""

	T_tablename = "mail_filter_%s"
	filter_table = None
	block_table = None

	db = None
	id = None

	code_filter = None
	code_block = None

	is_valid_blocking = True
	is_valid_filtering = True

	def __init__ (self, db, which=False, id=None) :

		self.db = db

		if which : self.set_name_space(which)

	def __check_is_table (self, tablename) :

		DB = myMySQLdb.myMySQLdb(self.db)

		return DB.query(sql.SQL_TABLE_EXIST % tablename)

	def set_message (self, message) :
		self.entireMessage = message

	def set_name_space (self, which="user", id=None) :

		if id : self.id = id

		# set filter table
		if which == "global" :
			filter_table = sql.SQL_TABLE_FILTER % "global"
			block_table = sql.SQL_TABLE_BLOCK % "global"

		elif which == "domain" and self.id :
			filter_table = sql.SQL_TABLE_FILTER % self.id
			block_table = sql.SQL_TABLE_BLOCK % self.id

		elif which == "user" and self.id :
			filter_table = sql.SQL_TABLE_FILTER % self.id
			block_table = sql.SQL_TABLE_BLOCK % self.id

		else :
			filter_table = None
			block_table = None

		# check whether table exists or not.
		if self.__check_is_table(block_table) :
			self.block_table = block_table
			self.is_valid_blocking = True
		else :
			self.block_table = None
			self.is_valid_blocking = False

		if self.__check_is_table(filter_table) :
			self.filter_table = filter_table
			self.is_valid_filtering = True
		else :
			self.filter_table = None
			self.is_valid_filtering = False

	def __get_filter (self) :

		if not self.filter_table :
			retval = []
		else :
			DB = myMySQLdb.myMySQLdb(self.db)
			DB.query(sql.SQL_GET_FILTER % self.filter_table, True)

			if not DB.num_rows > 0 :
				DB.close()

				retval = []
			else :
				a = {}
				b = {}

				for i in range(DB.num_rows) :
					i = int(i)
					a[i] = DB.fetch()

					c = {}
					c["From"] = a[i]["f"]
					c["To"] = a[i]["t"]
					c["Subject"] = a[i]["s"]
					c["payload_name"] = a[i]["payload_name"]
					c["size"] = int(a[i]["message_size"])
					c["directory_num"] = "%s" % a[i]["directory_num"]
					c["expression"] = str(a[i]["expression"])

					# option handling
					c["t_o"] = a[i]["t_o"]
					c["f_o"] = a[i]["f_o"]
					c["s_o"] = a[i]["s_o"]
					c["p_o"] = a[i]["p_o"]
					c["m_o"] = a[i]["m_o"]

					c["t_c"] = a[i]["t_c"]
					c["f_c"] = a[i]["f_c"]
					c["s_c"] = a[i]["s_c"]
					c["p_c"] = a[i]["p_c"]

					d = {}
					for j in c.keys() :
						d[j] = c[j]

					b[a[i]["sequence"]] = d

				DB.close()
				retval = b

		return retval

	def __get_block (self) :
		"""
		Return value is list.
		"""

		if not self.block_table :
			retval = []
		else :
			DB = myMySQLdb.myMySQLdb(self.db)
			DB.query(sql.SQL_GET_BLOCK % self.block_table, True)

			if not DB.num_rows > 0 :
				DB.close()

				retval = []
			else :
				b = []
				for i in range(DB.num_rows) :
					a = DB.fetch()

					if a["address"] : b.append(a["address"])

				DB.close()
				retval = b

		return retval

	def __format_header (self, dict_header) :

		a = {}

		a["From"] = ""
		a["To"] = ""
		a["Subject"] = ""

		# header
		for i in dict_header["headerSimple"] :
			a[i] = dict_header["headerSimple"][i]

		# payload header
		if dict_header["headerPayload"] < 1 :
			a["payload_name"] = []
		else :
			a["payload_name"] = []

			for i in dict_header["headerPayload"] :
				a["payload_name"].append(i[1])

		a["size"] = dict_header["size"]

		return a

	def __run_block (self, msg_info) :

		#---------------------------------------- Block address...
		if message.parse_address_header(msg_info["From"])[1] \
				in self.code_block :

			retval = -1 # is blocked
		else :
			retval = -2 # pass

		return retval

	def __check_code_as_size (self, value, target, option) :
		"""
		option is,
			0 : same size
			1 : greater than value
			2 : smaller than value
		"""

		if not value or not target :
			retval = False
		else :
			proof = False

			if option == 1 :
				if int(target) > int(value) : proof = True

			elif option == 2 :
				if int(target) < int(value) : proof = True
			else :
				if int(target) == int(value) : proof = True

			retval = proof

		return retval

	def __check_code_as_string (self, value, target, option, case=0) :
		"""
		option is,
			0 : target is included
			1 : target is not included
			2 : start with target
			3 : end with target
			4 : exactly match
		"""

		if not value or not target :
			retval = False
		else :
			found = False
			target = sre.escape(target)

			# check case sensitive
			if case != 0 :
				flag = sre.I
			else :
				flag = 0

			if option == 1 :
				q = sre.compile(target, flag)
				if not q.findall(value) : found = True

			elif option == 2 :
				q = sre.compile("^%s" % target, flag)
				if q.findall(value) : found = True

			elif option == 3 :
				q = sre.compile("%s$" % target, flag)
				if q.findall(value) : found = True

			elif option == 4 :
				q = sre.compile("^%s$" % target, flag)
				if q.findall(value) : found = True

			else :
				q = sre.compile(target, flag)
				if q.findall(value) : found = True

			retval = found

		return retval

	def __run_filter (self, msg_info) :
		"""
		* return value
			-2				: pass this message
			int value	: directory number to insert
		"""

		# apply filter code
		code_key = self.code_filter.keys()
		code_key.sort()

		if len(code_key) < 1 :
			retval = -2
		else :

			for i in code_key :

				ret = []

				expression = self.code_filter[i]["expression"]

				#---------- from
				if self.__check_code_as_string(msg_info["From"], \
						self.code_filter[i]["From"], 4, 1) :
					ret.append(True)
				else :
					ret.append(False)

				#---------- to
				if self.__check_code_as_string(msg_info["To"], \
						self.code_filter[i]["To"], self.code_filter[i]["t_o"], \
						self.code_filter[i]["t_c"]) :
					ret.append(True)
				else :
					ret.append(False)

				#---------- subject
				if self.__check_code_as_string(msg_info["Subject"], \
						self.code_filter[i]["Subject"], self.code_filter[i]["s_o"], \
						self.code_filter[i]["s_c"]) :
					ret.append(True)
				else :
					ret.append(False)

				#---------- payload name
				if not msg_info["payload_name"] :
					ret.append(False)
				else :

					var = False
					for j in msg_info["payload_name"] :
						if self.__check_code_as_string(j, \
								self.code_filter[i]["payload_name"], self.code_filter[i]["p_o"], \
								self.code_filter[i]["p_c"]) :

							var = True

					ret.append(var)

				#---------- size
				if self.__check_code_as_string(msg_info["size"], \
						self.code_filter[i]["size"], self.code_filter[i]["s_o"]) :
					ret.append(True)
				else :
					ret.append(False)

				# Check the return value.
				if expression == "0" :				#---------- or
					if True in ret :
						retval = self.code_filter[i]["directory_num"]

						break
					else :
						retval = -2
				else :									#---------- and
					if False in ret :
						retval = -2
					else :
						retval = self.code_filter[i]["directory_num"]
						break

		return retval

	def apply (self) :
		"""
		* msg.getSummary() return value is,
			message["headerSimple"] = headerSimple
			message["headerPayload"] = headerPayload
			message["size"] = message size

		* return value
			int value	: directory number to insert
			-1				: remove this message.
			-2				: pass this message
			-3				: it's blocked
		"""

		# get filter code
		self.code_block = self.__get_block()
		self.code_filter = self.__get_filter()

		if not (self.is_valid_blocking and self.is_valid_filtering) or \
				(len(self.code_filter) < 1 and len(self.code_block) < 1) :
			retval = -2
		else :
			# get message information
			try :
				msg = message.message(self.entireMessage)
			except :
				retval = -1
			else :
				msg_info = self.__format_header(msg.getSummary())

				# blocking
				if len(self.code_block) > 0 or self.is_valid_blocking :
					try :
						retval = self.__run_block(msg_info)
					except :
						retval = -1
				else :
					retval = -2

				# filtering
				if retval == -2 and len(self.code_filter) > 0 and self.is_valid_filtering :

					try :
						retval = self.__run_filter(msg_info)
					except :
						retval = -1
				else :
					retval -2

		return retval

class AddressBook :

	db = None
	id = None

	card_pool = []

	def __init__(self, db, id) :
		""" """
		self.db = db
		self.id = id

	def get_card_pool (self) :

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_GET_CARD % self.id, True)

		if DB.num_rows > 0 :
			for i in range(DB.num_rows) :
				a = DB.fetch()
				self.card_pool.append(a["email"])

	def check (self, entireMessage) :
		"""
		Return value
			True : is in address book, it means that we known him(or her)
			False : is unKnown user
		"""

		address = None

		M = message.message(entireMessage)

		L = M.getSimpleHeader("list")
		for i in L.keys() :
			if i == "From" :
				(a, address) = message.parse_address_header(L[i])
				break

		self.get_card_pool()

		if address in self.card_pool :
			retval = True
		else :
			retval = False

		return retval

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "MailFilter.py"

