<?

class Dialog {

	var $Template;

	var $type = "0";
		// $type = 0 : normal item
		// $type = 1 : directory
	var $control;

	function Dialog ($type="", $control=false) {
		$this->Template = new Template;

		if ($type) $this->type = $type;
		if ($control) $this->control = true;
	}

	function print_return ($args, $args1="") {

		switch ($this->type) {
			case ("1") :
				$retval = $this->return_yesno_directory($args, $args1);
			break;
			case ("2") :
				$retval = $this->return_yesno_block($args, $args1);
			break;
			case ("3") :
				$retval = $this->return_yesno_card_group_remove($args, $args1);
			break;
			case ("4") :
				$retval = $this->return_yesno_mail_to_group($args);
			break;
			case ("5") :
				$retval = $this->return_yesno_mail_to_selected($args);
			break;
			case ("100") :
				$retval = $this->return_result();
			break;
			default :
				$retval = $this->return_yesno_file($args, $args1);
		}

		return $retval;
	}

	function return_yesno_directory ($action, $directory_num) {
		global $global, $string;

		if (! $directory_num or $directory_num == "") {
			$retval = false;
		} else {
			$main["label"] = $string["dialog3"]["directory"]["action"][$action];

			$main["action"] = $action;
			if ($this->control) $main["control"] = "yes";
			$main["directory_num"] = $directory_num;

			$retval =
				$this->Template->generate("/module/item/template/yesno_directory", $main);
		}

		return $retval;
	}

	function return_yesno_mail_to_selected ($items) {
		global $global, $string;

		$main["label"] = $string["card52"];

		while (list($i, $j) = each($items)) {
			$a[] = $j;
		}

		$main["items"] = implode(",", $a);

		$retval =
			$this->Template->generate("/module/card/template/yesno_mail_to_selected", $main);
		
		return $retval;
	}

	function return_yesno_mail_to_group ($group_no) {
		global $global, $string;

		$main["label"] = $string["card49"];
		$main["group_no"] = $group_no;

		$retval =
			$this->Template->generate("/module/card/template/yesno_mail_to_group", $main);
		
		return $retval;
	}

	function return_yesno_card_group_remove ($action, $items) {
		global $global, $string;

		$main["label"] = $string["dialog3"]["card_group"]["action"][$action];

		$main["action"] = $action;
		$main["src_group_no"] = $_SESSION["user_card_group_no"];

		if ($action != "cleanup" and is_array($items)) {
			$main["items"] = implode(",", $items);
		} else {
			$main["items"] = $items;
		}

		$retval =
			$this->Template->generate("/module/card/template/yesno_card_group", $main);
		
		return $retval;
	}

	function return_yesno_file ($action, $items) {
		global $global, $string;

		$main["label"] = $string["dialog3"]["file"]["action"][$action];

		$main["action"] = $action;
		$main["directory_num"] = $_SESSION["user_directory"];

		if ($action != "cleanup" and is_array($items)) {
			$main["items"] = implode(",", $items);
		} else {
			$main["items"] = $items;
		}

		$retval =
			$this->Template->generate("/module/item/template/yesno_file", $main);
		
		return $retval;
	}

	function return_yesno_block ($action, $address) {
		global $global, $string;

		$main["label"] = sprintf($string["dialog4"]["block"]["action"][$action], $address);
		$main["action"] = $action;
		$main["address"] = $address;

		$retval =
			$this->Template->generate("/module/item/template/yesno_block", $main);
		
		return $retval;
	}

	function return_result () {
		global $global;

		$main["url"] = sprintf("%s/mail.php?no=%s",
			$_SESSION["user_www_url"], $_SESSION["user_directory"]);

		$retval =
			$this->Template->generate("/module/item/template/dialog_result", $main);
		
		return $retval;
	}

}
/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
