<?

include_once $global["root"] . "/lib/Control.php";
include_once $global["root"] . "/lib/Items.php";
include_once $global["root"] . "/lib/Item.php";
include_once $global["root"] . "/lib/Module.php";
include_once $global["root"] . "/lib/Dialog.php";
include_once $global["root"] . "/lib/Directories.php";
include_once $global["root"] . "/lib/Directory.php";
include_once $global["root"] . "/lib/State.php";
include_once $global["root"] . "/lib/Search.php";
include_once $global["root"] . "/lib/Template.php";
include_once $global["root"] . "/lib/Module_card.php";

class Request {

	var $Template;
	var $mode;
	var $entire_page = false;

	function Request () {
		$this->Template = new Template;
	}

	////////////////////////////////////////////////////
	function view ($no) {
		global $global, $string;

		$Item = new Item($no);
		$retval = $Item->view();

		return $retval;
	}

	function edit ($no) {
		global $global, $string;

		$Item = new Item($no);
		$retval = $Item->edit();

		$this->entire_page = true;

		return $retval;
	}

	function add ($no) {
		global $global, $string;

		$Item = new Item();
		$Item->set_module($no);

		$this->entire_page = true;

		$retval = $Item->add();

		return $retval;
	}

	function module_dialog ($no) {
		global $global, $string;

		$Module = new Module($no);

		$retval = $Module->execute("add_dialog");

		return $retval;
	}

	function dialog ($type, $action="", $no="", $control="") {
		global $global, $string;

		if (! $type or $type == "") goprev();

		$Dialog = new Dialog($type, $control);
		$retval = $Dialog->print_return($action, $no);

		return $retval;
	}

	function remove ($no) {
		global $global, $string;

		$Dialog = new Dialog("0");
		$retval = $Dialog->print_return("remove", $no);

		return $retval;
	}

	function drct_select ($action, $items) {
		global $global, $string;

		if ($action != "remove" and $action != "cleanup" and
				$action != "move" and $action != "copy") {
			goprev();
		}

		if (($action == "remove" or $action == "move" or $action == "copy") and
				(count($items) < 1)) {
			goprev();
		}

		if ($_GET["directory"]) $_SESSION["user_directory"] = $_GET["directory"];

		if ($action == "remove" or $action == "cleanup") {
			$Dialog = new Dialog("0");
			$retval = $Dialog->print_return($action, $items);
		} else {
			$Directories = new Directories;
			$retval = $Directories->return_select_box ($action, $items);
		}

		return $retval;
	}

	function control ($control, $no) {
		global $global, $string;

		$Control = new Control;
		$retval = $Control->handle($control, $no);
		$this->entire_page = true;

		return $retval;
	}

	function navigate () {
		global $global, $string;

		$Directories = new Directories;
		$Directories->navigate = true;
		$retval = $Directories->return_list();

		return $retval;
	}

	function drct () {
		global $global, $string;

		$Directories = new Directories;
		$Directories->compact = true;
		$retval = $Directories->return_list();

		return $retval;
	}

	function search_form ($str) {
		global $global, $string;

		$Search = new Search($str);
		$retval = $Search->return_form();

		return $retval;
	}

	function search_result ($str="", $modules="", $case="", $directory_num="") {
		global $global, $string;

		if (! $modules) goprev();

		$Search = new Search($str);
		$retval = $Search->return_result($modules, $case, $directory_num);

		return $retval;
	}

	function return_list ($no="", $st="", $pg="") {
		global $global, $string;

		include_once $global["root"] . "/module/message/function/etc.php";

		if (! $pg or $pg == "") $pg = "0";

		$_SESSION["user_directory"] = "$no";
		$_SESSION["user_page_number"] = "$pg";

		$Directory = new myDirectory($_SESSION["user_directory"]);

		// handling sort method.
		if ($st == "title" or $st == "author" or $st == "createdTime") {
			$State = new State();
			$State->assign_sort_of_item($no, $st);
		}

		$Items = new Items();
		$retval = $Items->return_list();

		return $retval;
	}

	function return_card_list ($no="", $st="", $pg="") {
		global $global, $string;

		include_once $global["root"] . "/lib/Extend_card.php";

		if ($st == "email" or $st == "name") {
			$State = new State();
			$State->assign_sort_of_card_group($no, $st);
		}

		$Card = new Extend_card();
		$retval = $Card->return_list($no, $st, $pg);

		return $retval;
	}

	function card_view ($group_no, $no) {
		global $global, $string;

		$_SESSION["user_group_no"] = "$gropu_no";

		include_once $global["root"] . "/lib/Extend_card.php";

		$Card = new Extend_card();
		$retval = $Card->view($no, $group_no);

		return $retval;
	}

	function card_group_management () {
		global $global;

		include_once $global["root"] . "/lib/Extend_Card_Group.php";

		$Group = new Extend_Card_Group();
		$retval = $Group->return_management();

		return $retval;
	}

	function card_group_select ($action, $items) {
		global $global, $string;

		if ($action != "mail_to_group" and $action != "real_remove" and
				$action != "remove" and
				$action != "move" and $action != "copy" and $action != "mail_to_selected") {
			goprev();
		}

		if (($action == "real_remove" or $action == "remove" or
				$action == "move" or $action == "copy") and
				(count($items) < 1)) {
			goprev();
		}

		if ($action == "mail_to_group" and ! $_GET["group_no"]) {
			goprev();
		}

		if ($action == "mail_to_selected" and ! is_array($_GET["items"])) {
			goprev();
		}

		include_once $global["root"] . "/lib/Extend_Card_Group.php";

		switch (true) {
			case $action == "remove" or $action == "real_remove" :
				$Dialog = new Dialog("3");
				$retval = $Dialog->print_return($action, $items);
			break;

			case $action == "mail_to_group" :
				$Dialog = new Dialog("4");
				$retval = $Dialog->print_return($_GET["group_no"]);
			break;

			case $action == "mail_to_selected" :
				$Dialog = new Dialog("5");
				$retval = $Dialog->print_return($_GET["items"]);
			break;

			default :
				$Card = new Extend_Card_Group;
				$retval = $Card->return_select_box ($action, $items);

		}

		return $retval;
	}

	function return_address_action_handle ($action, $address, $name, $no) {
		global $global;

		switch ($action) {

			case ("compose_mail") :
				$url = sprintf("%s/mail.php?mode=add&no=1&address=%s",
					$_SESSION["user_global_url"], $address);

				Header("Location: " . $url);
				exit;
			break;
			case ("add_card") :
				$url = sprintf("%s/mail.php?mode=add&no=3&email=%s&name=%s",
					$_SESSION["user_global_url"], $address, $name);

				Header("Location: " . $url);
				exit;
			break;
			case ("block_address") :
				$url = sprintf("%s/mail.php?mode=dialog&type=2&no=%s&action=add",
					$_SESSION["user_global_url"], $address);

				Header("Location: " . $url);
				exit;
			break;
			default :
				goprev();
		}
	}

	function return_address_action_dialog ($address, $name, $no) {
		global $global;

		include_once $global["root"] . "/lib/Basic_Address.php";

		$Address = new Basic_Address;
		$retval = $Address->return_action_dialog($address, $name, $no);

		return $retval;
	}

	function frontpage () {
		$retval = print_frontpage();

		return $retval;
	}

	function handle () {
		global $global, $string;

		extract($_GET);

		switch ($mode) {
			// item
			case ("view") :
				$retval = $this->view($no);
			break;
			case ("edit") :
				$_SESSION["user_not_save_url"] = true;

				$retval = $this->edit($no);
			break;
			case ("add") :
				$_SESSION["user_not_save_url"] = true;

				$retval = $this->add($no);
			break;
			case ("remove") :
				$_SESSION["user_not_save_url"] = true;

				$retval = $this->remove($no);
			break;

			case ("module_dialog") :
				$_SESSION["user_not_save_url"] = true;

				$retval = $this->module_dialog($no);
			break;
			case ("dialog") :
				$_SESSION["user_not_save_url"] = true;

				$retval = $this->dialog($type, $action, $no, $control);
			break;
			case ("drct_select") :
				$_SESSION["user_not_save_url"] = true;

				$retval = $this->drct_select($action, $items);
			break;
			case ("navigate") : // directory management.
				$retval = $this->navigate();
			break;
			case ("drct") : // directory management.
				$this->entire_page = true;
				$retval = $this->drct();
			break;
			case ("control") : // control panel
				$retval = $this->control($control, $no);
			break;

			case ("card_group_select") :
				$_SESSION["user_not_save_url"] = true;

				$_SESSION["tmp"]["menu"] = "card";
				$retval = $this->card_group_select($action, $items);
			break;

			case ("card_group_management") :
				$retval = $this->card_group_management();

				$this->entire_page = true;
				//$_SESSION["tmp"]["menu"] = "card";
			break;

			case ("card_view") :
				if ($no) {
					$retval = $this->card_view($group_no, $no);
				}

				$_SESSION["tmp"]["menu"] = "card";
			break;

			case ("card") :
				/*
				* Strategy
					if no $group_no,
						: return frontpage of card module
					if $group_no,
						: return card list of group
				*/

				if (! $pg or $pg == "") $pg = "0";
				if ($no) $_SESSION["user_card_group_no"] = $no;

				$_SESSION["user_card_page_number"] = "$pg";

				if (! array_key_exists("user_card_group_no", $_SESSION)) {
					$_SESSION["user_card_group_no"] = "a";
				}

				$retval =
					$this->return_card_list($_SESSION["user_card_group_no"], $st, $pg);

				$_SESSION["tmp"]["menu"] = "card";
			break;

			case ("search_form") : // search
				$this->entire_page = true;
				$retval = $this->search_form ($str);
			break;
			case ("search_result") :
				$this->entire_page = true;
				$_SESSION["user_not_save_url"] = true;
				$retval = $this->search_result($str, $modules, $case, $directory_num);
			break;

			case ("address_action_handle") :
				$_SESSION["user_not_save_url"] = true;
				$retval = $this->return_address_action_handle($action, $address, $name, $no);
			break;

			case ("address_action") :
				$_SESSION["user_not_save_url"] = true;
				$retval = $this->return_address_action_dialog($address, $name, $no);
			break;

			case ("front") :
				$this->entire_page = true;
				$retval = $this->frontpage();
			break;

			/*
			// mode no(directory number) st(sort method) pg (page)
			case ("list") :
				if ($no) {
					$retval = $this->return_list($no, $st, $pg);
				} else if ($_SESSION["user_directory"]) {
					$retval = $this->return_list($_SESSION["user_directory"], $st, $pg);
				} else {
					$this->entire_page = true;
					$retval = $this->frontpage();
				}
			break;
			*/
			default :

				if (! $no and ! $_SESSION["user_directory"]) {
					$this->entire_page = true;
					$retval = $this->frontpage();
				} else if (! $no and $_SESSION["user_directory"]) {
					$retval = $this->return_list($_SESSION["user_directory"], $st, $pg);
				} else {
					$retval = $this->return_list($no, $st, $pg);
				}
		}

		if (! $retval or $retval == "") goprev();

		return $retval;
	}
}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
