<?
	/*
		code name : ListDatabase
		
		code version : 0.1.6

		made by Han-gil, Lee ... 07/25,2003
		last update by Han-gil, Lee ... 07/30,2003
		
		http://hangulee.nahome.org
		
		ѱ̿  ҽ ڵ ̼
		Source Code License by Hangulee
		
		 ڵ尡  ȿ Han-gil, Lee  ڵ   å ϴ.
		During this code is free, Han-gil, Lee is not responsible for the safety of this code. 
		
		 ڵ带 ٸ α׷ ϱ⸦ Ѵٸ,  ڵ尡  Han-gil, Lee   ؾ մϴ.
		If you want to use this code to another program, you must express this code is written by Han-gil, Lee.
		
		 ڵ带 ϰ ϱ⸦ Ѵٸ  ڵ ݵ  ̼  մϴ.
		If you want to modify and distribute this code, your modified code must be followed by this License.
		
		"ѱ̿  ҽ ڵ ̼" Ѵٸ  ڵ带   ֽϴ.
		If you agree "Source Code License by Hangulee", you can use this code.
		
		 ̼ 08/14, 2003 ۼǾϴ.
		This License was written at 08/14, 2003
	*/
	
	class ListDatabase
	{
		//vars for file pointer
		var $fpList;		// list
		var $fpNPage;	// list - page // pgin
		var $fpPage;	// page
		var $fpIndex;	// index
		var $fpRows;	// rows
		var $fpEmpty;	// emt

		//vars for db information
		var $dbname;
		var $totalRow;
		var $totalSize;
		var $first;
		var $last;
		var $totalPage;
		var $emptyNum;
		var $rowSize;

		//vars for table information
		var $colsNum;
		var $colsNo;	// name->number;
		var $colsType;	// name->type
		var $NUMBER=1;
		var $STRING=2;

		//initialize function

		function ListDatabase($dbname)
		{
			$this->xb = 256;
			$this->xc = 256*256;
			$this->xd = $this->xc*256;

			$this->dbname = $dbname;
		}

		function createLDB($fields, $types)
		{
			$this->fpList = fopen("$this->dbname.list", "w");
			if ( $this->fpList == false ) return false;
			$this->set4byteNumber($this->fpList, 0);		// space for total data number
			$this->set4byteNumber($this->fpList, 0);		// space for total size
			$this->set4byteNumber($this->fpList, 0);		// space for first number
			$this->set4byteNumber($this->fpList, 0);		// space for last number
			fclose($this->fpList);

			$this->fpPage = fopen("$this->dbname.page", "w");
			if ( $this->fpPage == false ) return false;
			$this->set4byteNumber($this->fpPage, 0);		// space for total page
			fclose($this->fpPage);

			$this->fpEmpty = fopen("$this->dbname.emt", "w");
			if ( $this->fpEmpty == false ) return false;
			$this->set4byteNumber($this->fpEmpty, 0);		// space for total empty ps
			$this->set4byteNumber($this->fpEmpty, 0);		// space for row size
			fclose($this->fpEmpty);


			$this->fpNPage	= fopen("$this->dbname.pgin", "w");
			if ( $this->fpNPage == false ) return false;
			fclose($this->fpNPage);

			$this->fpIndex	= fopen("$this->dbname.index", "w");
			if ( $this->fpIndex == false ) return false;
			fclose($this->fpIndex);

			$this->fpRows	= fopen("$this->dbname.rows", "w");
			if ( $this->fpRows == false ) return false;
			fclose($this->fpRows);

			$fpTable = fopen("$this->dbname.table", "w");
			if ( $fpTable == false ) return false;
			for ( $i=0 ; $i<count($fields) ; $i++ )
			{
				if ( $types[$i] == "number" ) $type = $this->NUMBER;
				else $type = $this->STRING;
				fwrite($fpTable, $fields[$i]."=".$type."\n");
			}
			fclose($fpTable);
			return true;
		}

		//boolean... char
		function openLDB($mode)
		{
			if ( !is_writeable("$this->dbname.list")
				|| !is_writeable("$this->dbname.pgin")
				|| !is_writeable("$this->dbname.page")
				|| !is_writeable("$this->dbname.index")
				|| !is_writeable("$this->dbname.rows")
				|| !is_writeable("$this->dbname.emt")
				|| !is_writeable("$this->dbname.table")
			) return false;

			$this->fpList		= fopen("$this->dbname.list", "r+");
			$this->fpNPage	= fopen("$this->dbname.pgin", "r+");
			$this->fpPage		= fopen("$this->dbname.page", "r+");
			$this->fpIndex	= fopen("$this->dbname.index", "r+");
			$this->fpRows		= fopen("$this->dbname.rows", "r+");
			$this->fpEmpty	= fopen("$this->dbname.emt", "r+");

			while ( !flock($this->fpList,		2) ) sleep(1);
			while ( !flock($this->fpNPage,	2) ) sleep(1);
			while ( !flock($this->fpPage,	2) ) sleep(1);
			while ( !flock($this->fpIndex,	2) ) sleep(1);
			while ( !flock($this->fpRows,	2) ) sleep(1);
			while ( !flock($this->fpEmpty,	2) ) sleep(1);

			$table 					= file("$this->dbname.table");
			$this->colsNum	= count($table);

			for ( $i=0 ; $i<$this->colsNum ; $i++ )
			{
				$col = strtok($table[$i], "=");
				$type = strtok("");
				$this->colsNo[$col] = $i;
				$this->colsType[$col] = $type;
			}

			if (	$this->fpList == false
				|| $this->fpNPage == false
				|| $this->fpPage == false
				|| $this->fpIndex == false
				|| $this->fpRows == false
				|| $this->fpEmpty == false
			) return false;

			$this->totalRow	= $this->get4byteNumber($this->fpList);
			$this->totalSize	= $this->get4byteNumber($this->fpList);
			$this->first			= $this->get4byteNumber($this->fpList);
			$this->last			= $this->get4byteNumber($this->fpList);
			$this->totalPage	= $this->get4byteNumber($this->fpPage);
			$this->emptyNum= $this->get4byteNumber($this->fpEmpty);
			$this->rowSize	= $this->get4byteNumber($this->fpEmpty);

			return true;
		}

		function closeLDB()
		{
			fseek($this->fpList, 0);
			fseek($this->fpPage, 0);
			fseek($this->fpEmpty, 0);

			$this->set4byteNumber($this->fpList, $this->totalRow);
			$this->set4byteNumber($this->fpList, $this->totalSize);
			$this->set4byteNumber($this->fpList, $this->first);
			$this->set4byteNumber($this->fpList, $this->last);
			$this->set4byteNumber($this->fpPage, $this->totalPage);
			$this->set4byteNumber($this->fpEmpty, $this->emptyNum);
			$this->set4byteNumber($this->fpEmpty, $this->rowSize);

			flock($this->fpList,		3);
			flock($this->fpNPage,	3);
			flock($this->fpPage,	3);
			flock($this->fpIndex,	3);
			flock($this->fpRows,	3);
			flock($this->fpEmpty,	3);

			fclose($this->fpList);
			fclose($this->fpNPage);
			fclose($this->fpPage);
			fclose($this->fpIndex);
			fclose($this->fpRows);
			fclose($this->fpEmpty);

			return true;
		}

		//for get Range
		function getNnd($nd)
		{
			$num = $nd%100;
			$page = ($nd-$num)/100;

			if ( $page == 0 )
			{
				$N = $this->first;
				$num--;
			}
			else
			{
				$this->f4seek($this->fpPage, $page);
				$N = $this->get4byteNumber($this->fpPage);
			}
			for ( $i=0 ; $i<$num ; $i++)
			{
				$N = $this->getNextRow($N);
			}
			return $N;
		}

		//long[] ... long, long
		function getListRange($start, $n)
		{
			$list[$i] = $this->getNnd($start);
			for ( $i=1 ; $i<$n ; $i++ )
			{
				$list[$i] = $this->getNextRow($list[$i-1]);
				if ( $list[$i] == 0 ) break;
			}
			return $list;
		}

		function getSearchList($field, $keyword)
		{
			$n = $this->first;
			while ( $n!=0 )
			{
				$value = $this->getValue($n, $field);
				if ( strpos($value, $keyword) === true ) $list[] = $n;
				$n = $this->getNextRow($n);
			}
			return $list;
		}

		//long ... long, int, void
		function insertRow($nd)
		{
			$this->totalSize++;
			$new = $this->totalSize;
			if ( $nd == -1 )
			{
				$nd = $this->last;
				$this->listLink($nd, $new);
				$this->pageRighting($nd, $new);
			}
			else
			{
				$this->listLink($nd, $new);
				$this->pageRighting($nd, $new);
			}
			$this->totalRow++;

			return $new;
		}

		function unlinkInsertRow()
		{
			$this->totalSize++;

			return $this->totalSize;
		}

		//boolean ... long
		function dropRow($nd)
		{
			if ( empty($nd) ) return false;

			while ( list($name, $no) = each($this->colsNo) )
			{
				$type = $this->colsType[$name];
				if ( $type == $this->STRING )
				{
					$this->indexMove($nd, $name);
					$this->deleteRowText( $this->get4byteNumber($this->fpIndex) );
				}
				else if ( $type == $this->NUMBER )
				{
					$this->indexMove($nd, $fieldName);
					$this->set4byteNumber($this->fpIndex, 0);
				}
			}

			if ( $this->isLinked($nd) )
			{
				$this->listUnlink($nd);
				$this->pageLefting($nd);
				$this->totalRow--;
			}
			return true;
		}
		
		function unlinkDropRow($nd)
		{
			if ( empty($nd) ) return false;
			while ( list($name, $no) = each($this->colsNo) )
			{
				$type = $this->colsType[$name];
				if ( $type == $this->STRING )
				{
					$this->indexMove($nd, $name);
					$this->deleteRowText( $this->get4byteNumber($this->fpIndex) );
				}
				else if ( $type == $this->NUMBER )
				{
					$this->indexMove($nd, $fieldName);
					$this->set4byteNumber($this->fpIndex, 0);
				}
			}	
			return true;
		}


		//function named indexMode for set/getValue
		function indexMove($nd, $name)
		{
			$this->f4seek($this->fpIndex, ($nd)*$this->colsNum+($this->colsNo[$name]));
		}

		//lboolean ... long, int, void
		function setValue($nd, $fieldName, $value)
		{
			if ( empty($nd) ) return false;

			$this->indexMove($nd, $fieldName);
			if ( $this->colsType[$fieldName] == $this->NUMBER )
			{
				$this->set4byteNumber($this->fpIndex, $value);
			}
			else
			{
				$ps = $this->get4byteNumber($this->fpIndex);
				if ( $ps != 0 ) $this->deleteRowText($ps);

				$this->indexMove($nd, $fieldName);
				$this->set4byteNumber($this->fpIndex, $this->setRowText($value) );
			}

			return true;
		}

		//void ... long,
		function getValue($nd, $fieldName)
		{
			if ( empty($nd) ) return false;

			// ũ  üũ
			// if ( !$this->isLinked($nd) ) return false;

			$this->indexMove($nd, $fieldName);
			if ( $this->colsType[$fieldName] == $this->NUMBER )
			{
				return $this->get4byteNumber($this->fpIndex);
			}
			else
			{
				return $this->getRowText( $this->get4byteNumber($this->fpIndex) );
			}
		}

		//with rows text file
		//boolean ...
		function setEmpty($ps)
		{
			$this->emptyNum++;
			$this->f4seek($this->fpEmpty, $this->emptyNum+1); // ĭ ǳʶ...
			$this->set4byteNumber($this->fpEmpty, $ps);
		}

		//long...
		function getEmptyPs()
		{
			if ( $this->emptyNum == 0 )
			{
				$this->rowSize++;
				return $this->rowSize;
			}
			else
			{
				$this->f4seek($this->fpEmpty, $this->emptyNum+1); // ĭ ǳʶ...
				$ps = $this->get4byteNumber($this->fpEmpty);
				$this->emptyNum--;
				return $ps;
			}
		}

		//long ... string
		function setRowText($text)
		{
			if ( ($textLEN = strlen($text)) == 0 ) return 0;
			$ps = $this->getEmptyPs();
			$startPs = $ps;
			for ( $i=0; 1; $i++)
			{
				fseek($this->fpRows, $ps*54);
				fwrite($this->fpRows, substr($text, $i*50, 50), 50);
				if ( $i+1>(int)$textLEN/50 )
				{
					$this->set4byteNumber($this->fpRows, 0);
					fseek($this->fpRows, $ps*54+50);
					$this->set4byteNumber($this->fpRows, 0);
					break;
				}
				$ps = $this->getEmptyPs();
				$this->set4byteNumber($this->fpRows, $ps);
			}
			return $startPs;
		}

		//string ... long
		function getRowText($ps)
		{
			while ( $ps != 0 )
			{
				fseek($this->fpRows, $ps*54);
				$text .= fread($this->fpRows, 50);
				$ps = $this->get4byteNumber($this->fpRows);
			}
			return ereg_replace('^'.chr(0), '', $text);
		}

		//long ...
		function deleteRowText($ps)
		{
			while ( $ps != 0 )
			{
				$this->setEmpty($ps);
				fseek($this->fpRows, $ps*54+50);
				$ps = $this->get4byteNumber($this->fpRows);
			}
		}

		function getTotalRow()
		{
			return $this->totalRow;
		}

		function getLastRow()
		{
			return $this->last;
		}

		function getFirstRow()
		{
			return $this->first;
		}

		function getNextRow($ps)
		{
			$this->f4seek($this->fpList, $this->listNextPs($ps));
			return $this->get4byteNumber($this->fpList);
		}

		function getBeforeRow($ps)
		{
			$this->f4seek($this->fpList, $this->listBeforePs($ps));
			return $this->get4byteNumber($this->fpList);
		}

		// memo
		// nd(before) = 4+(ps-1)*2 = 2+ps*2 (in list)
		// nd(next) = 4+(ps-1)*2+1 = 3+ps*2 (in list)
		function listBeforePs($ps)
		{
			return 2+$ps*2;
		}

		function listNextPs($ps)
		{
			return 3+$ps*2;
		}

		function listLink($ps, $target)
		{
			if ( empty($target) ) return false;

			$next_of_ps = $this->getNextRow($ps);

			if ( $ps != 0 )
			{
				if ( $next_of_ps != 0 )
				{
					$this->f4seek($this->fpList, $this->listBeforePs($next_of_ps));	// go before of (next of ps)
					$this->set4byteNumber($this->fpList, $target);								// write on before = target
					$this->f4seek($this->fpList, $this->listNextPs($target));				// go next of target
					$this->set4byteNumber($this->fpList, $next_of_ps);						// write on next = next of ps
				}
				else
				{
					$this->last = $target;
				}
				$this->f4seek($this->fpList, $this->listNextPs($ps));	// go next of ps
				$this->set4byteNumber($this->fpList, $target);			// write on next = target
			}
			else
			{
				$this->f4seek($this->fpList, $this->listBeforePs($this->first));	// go before of first
				$this->set4byteNumber($this->fpList, $target);							// write on before = target

				$this->f4seek($this->fpList, $this->listNextPs($target));			// go before of first
				$this->set4byteNumber($this->fpList, $this->first);					// write on before = target

				if ( $this->first == 0 ) $this->last = $target;
				$this->first = $target;
			}
			$this->f4seek($this->fpList, $this->listBeforePs($target));	// go next of target
			$this->set4byteNumber($this->fpList, $ps);							// write on before = ps

			return false;
		}

		function listUnlink($target)
		{
			if ( empty($target) ) return false;

			$before_of_target = $this->getBeforeRow($target);				// get before of target
			$next_of_target = $this->get4byteNumber($this->fpList);	// get next of target

			if ( $before_of_target != 0 )
			{
				$this->f4seek($this->fpList, $this->listNextPs($before_of_target));	// go next of (before of target)
				$this->set4byteNumber($this->fpList, $next_of_target);					// write on next = next of target
			}
			else
			{
				$this->first = $next_of_target;
			}

			if ( $next_of_target != 0 )
			{
				$this->f4seek($this->fpList, $this->listBeforePs($next_of_target));		// go before of (next of target)
				$this->set4byteNumber($this->fpList, $before_of_target);					// write on before = before of target
			}
			else
			{
				$this->last = $before_of_target;
			}

			return true;
		}

		function isLinked($target)
		{
			$before_of_target = $this->getBeforeRow($target);				// get before of target
			$next_of_target = $this->get4byteNumber($this->fpList);	// get next of target

			if ( $target != $this->last && $this->getBeforeRow($next_of_target) != $target ) return false;
			if ( $target != $this->first && $this->getNextRow($before_of_target) != $target ) return false;
			return true;
		}

		// function named get/setPageMark, get/setBelongPage for pageShifting
		function getPageMark($page)
		{
			$this->f4seek($this->fpPage, $page);
			return $this->get4byteNumber($this->fpPage);
		}

		function setPageMark($page, $row)
		{
			$this->f4seek($this->fpPage, $page);
			$this->set4byteNumber($this->fpPage, $row);
		}

		function getBelongPage($row)
		{
			$this->f4seek($this->fpNPage, $row);
			return $this->get4byteNumber($this->fpNPage);
		}

		function setBelongPage($row, $page)
		{
			$this->f4seek($this->fpNPage, $row);
			$this->set4byteNumber($this->fpNPage, $page);
		}

		function pageRighting($ps, $next)
		{
			$p_belong = $this->getBelongPage($ps);
			$r_mark = $this->getPageMark($p_belong);

			if ( $r_mark == $ps && $p_belong!=$this->totalPage ) $p_belong++;
			$this->setBelongPage($next, $p_belong);

			$this->f4seek($this->fpPage, $p_belong);
			for ( $i = $p_belong; $i < $this->totalPage ; $i++ )
			{
				$r_iMarks[] = $this->get4byteNumber($this->fpPage);
			}

			$this->f4seek($this->fpPage, $p_belong);
			for ( $i = $p_belong, $ai=0 ; $i < $this->totalPage ; $i++, $ai++ )
			{
				$this->set4byteNumber($this->fpPage, $this->getBeforeRow($r_iMarks[$ai]));
				$this->setBelongPage($r_iMarks[$ai], $i+1);
			}

			if ( $this->totalRow%100 == 0 )
			{
				$this->setPageMark($this->totalPage, $this->getBeforeRow($this->last));
				$this->totalPage++;
			}

			$this->setPageMark($this->totalPage, $this->last);
			$this->setBelongPage($this->last, $this->totalPage);
		}

		function pageLefting($ps)
		{
			$p_belong = $this->getBelongPage($ps);
			$r_mark = $this->getPageMark($p_belong);

			if ( $r_mark == $ps ) $p_belong++;
			$this->setBelongPage($next, $p_belong);

			$this->f4seek($this->fpPage, $p_belong);
			for ( $i = $p_belong; $i < $this->totalPage ; $i++ ) $r_iMarks[] = $this->get4byteNumber($this->fpPage);

			$this->f4seek($this->fpPage, $p_belong);
			for ( $i = $p_belong, $ai=0 ; $i < $this->totalPage ; $i++, $ai++ )
			{
				$this->set4byteNumber($this->fpPage, $this->getNextRow($r_iMarks[$ai]));
				$this->setBelongPage($r_iMarks[$ai], $i);
			}

			if ( $this->totalRow%100 == 1 )
			{
				$this->setPageMark($this->totalPage, 0);
				$this->totalPage--;
				$this->setBelongPage($this->last, $this->totalPage);
			}
			$this->setPageMark($this->totalPage, $this->last);
		}

		function f4seek($fp, $ps)
		{
			//need for check;
			rewind($fp);
			fseek($fp, $ps*4);
		}

		function f4seekOn($fp, $ps)
		{
			//fseek($fp, ftell($fp)+$ps*4); // for php4.0 rc1  
			fseek($fp, $ps*4, SEEK_CUR); // for php4.0 rc1  
		}

		var $xd;
		var $xc;
		var $xb;

		function get4byteNumber($fp)
		{
			$w = ord(fgetc($fp));
			$x = ord(fgetc($fp));
			$y = ord(fgetc($fp));
			$z = ord(fgetc($fp));
			return $w*$this->xd + $x*$this->xc + $y*$this->xb + $z;
		}
		function set4byteNumber($fp, $n)
		{
			$w = (int)($n/$this->xd);
			$x = (int)($n%$this->xd/$this->xc);
			$y = (int)($n%$this->xd%$this->xc/$this->xb);
			$z = (int)($n%$this->xd%$this->xc%$this->xb);

			fwrite($fp, chr($w).chr($x).chr($y).chr($z),4);
		}
	}
?>