///////////////////////////////////////////////////////////////////////////
// GnexDefaultCode.mc - Auto Created by GNEX IDE
///////////////////////////////////////////////////////////////////////////

#ifdef _GVM
%{
	#DEFINE SCRIPTVER	2
	#DEFINE LCDCLASS		255
	#DEFINE IMAGETYPE	255
	#DEFINE AUDIOTYPE	255
	#DEFINE SCRIPTTYPE	1
	#DEFINE SCRIPTCPID	20330
	#DEFINE SCRIPTID		1
	#DEFINE SCRIPTNAME	"GnexDefaultCode GVM2X App"
	#DEFINE VALIDCOUNT	255
	#DEFINE VALIDTERM	255
%}
#else
%{
	#DEFINE PLAYERVER	4
	#DEFINE LCDCLASS		255
	#DEFINE IMAGETYPE	255
	#DEFINE AUDIOTYPE	255
	#DEFINE APPTYPE		1
	#DEFINE APPCPID		20330
	#DEFINE APPID			1
	#DEFINE APPNAME		"GnexDefaultCode GNEX App"
	#DEFINE COMPTYPE	0
	#DEFINE AGENTTYPE	0
	#DEFINE VALIDCOUNT	255
	#DEFINE VALIDTERM	255
	#DEFINE DIRECTRUN	0
	#DEFINE APPVER			1
%}
#endif

#include "include/SScript.h"

// game state
enum {
	GS_RUN,

	ES_START,
	ES_KEYPRESS,
	ES_TIMEOUT,
	ES_END
};

#define GAMESIZEX	120		//  
#define GAMESIZEY	106		

int	gGameState;
int	gCX;
int	gCY;

void main()
{
	gCX = swWidth/2 - GAMESIZEX/2;
	gCY = swHeight/2 - GAMESIZEY/2;
	GameRun(ES_START, swData);
}

void EVENT_KEYPRESS()
{
	switch(gGameState)
	{
		case GS_RUN:
			GameRun(ES_KEYPRESS, swData);
			break;
	}
}

void EVENT_TIMEOUT()
{
	switch(swData)
	{
		case 0:
			switch(gGameState)
			{	
				case GS_RUN:
					GameRun(ES_TIMEOUT, swData);
					break;
			}
			Flush();
			break;
//		case 1:
//			break;
	}
}

void GameRun(int event, int data)
{
	switch(event) 
	{
		case ES_START:
			SetTimer(100,1);
			gGameState = GS_RUN;		
			Clear(0);
			SaveLCD();	
			DrawRun();
			break;
		case ES_KEYPRESS:
			switch(data) 
			{
				case SWAP_KEY_RELEASE:
					break;	
				case SWAP_KEY_OK:
				case SWAP_KEY_5:
					break;		
				case SWAP_KEY_RIGHT:
				case SWAP_KEY_6:
					break;	
				case SWAP_KEY_LEFT:
				case SWAP_KEY_4:
					break;
				case SWAP_KEY_UP:
				case SWAP_KEY_2:
					break;
				case SWAP_KEY_DOWN:
				case SWAP_KEY_8:
					break;
				case SWAP_KEY_1:
					break;
				case SWAP_KEY_3:
					break;
				case SWAP_KEY_7:
					break;
				case SWAP_KEY_9:
					break;
				case SWAP_KEY_0:
					break;
				case SWAP_KEY_CLR:
					break;
				case SWAP_KEY_STAR:
					break;
				case SWAP_KEY_SHARP:
					break;
			}
			break;
		case ES_TIMEOUT:
			DrawRun();
			break;
	}
}

void DrawRun()
{
	RestoreLCD();
}

void EVENT_END()
{
}
