package kr.co.leaderway.mywork.MyWorkexception.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.user.model.UserInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.springframework.web.servlet.ModelAndView;

public class MyWorkExceptionHandler extends Action {

	private Log log = LogFactory.getLog(this.getClass());
	
	public ActionForward handle(Exception now_exception,ActionMapping mapping,
			 									ActionForm form,
			 									HttpServletRequest request,
			 									HttpServletResponse response) throws Exception {

		HttpSession session = request.getSession();
	
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		String sessionUserId = "";
		if (userInfo == null) {
			log.info("not logged in");
			sessionUserId = "notlogin";
		} else {
			sessionUserId = userInfo.getUser().getUserId();
		}
		
		String selectedMenuNo_string = request.getParameter("selected_menu_no") != null ? (String) request.getParameter("selected_menu_no") : "0";
		int selectedMenuNo = Integer.parseInt(selectedMenuNo_string);
		
		log.info("selected_menu_no:" + selectedMenuNo);
		
		if (userInfo == null && selectedMenuNo == 0) {
			log.info("not logged in");
			sessionUserId = "notlogin";
		} else if (userInfo == null && selectedMenuNo == 0) {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		} else if (userInfo == null && selectedMenuNo != 0) {
			// do nothing
		} else if (selectedMenuNo != 0){
			userInfo.getCurrentMenu().setNo(selectedMenuNo);
		} else {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		}
		
		log.info("userid:" + sessionUserId);
		log.info("after selected_menu_no:" + selectedMenuNo);
		
		now_exception.printStackTrace();
		
		request.setAttribute("exception_content", now_exception.toString());
		request.setAttribute("contentTitle", "오류");
		
		if (request.getParameter("isAjax") != null && request.getParameter("isAjax").equals("Y")) {
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("error_ajax") );
			return redirect;
		} else {
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("error") );
			return redirect;
		}
		
		
	}
	
	public ModelAndView handle(Exception now_exception, HttpServletRequest request,
				HttpServletResponse response) throws Exception {

		HttpSession session = request.getSession();
		
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		String sessionUserId = "";
		if (userInfo == null) {
			log.info("not logged in");
			sessionUserId = "notlogin";
		} else {
			sessionUserId = userInfo.getUser().getUserId();
		}
		
		String selectedMenuNo_string = request.getParameter("selected_menu_no") != null ? (String) request.getParameter("selected_menu_no") : "0";
		int selectedMenuNo = Integer.parseInt(selectedMenuNo_string);
		
		log.info("selected_menu_no:" + selectedMenuNo);
		
		if (userInfo == null && selectedMenuNo == 0) {
			log.info("not logged in");
			sessionUserId = "notlogin";
		} else if (userInfo == null && selectedMenuNo == 0) {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		} else if (userInfo == null && selectedMenuNo != 0) {
			// do nothing
		} else if (selectedMenuNo != 0){
			userInfo.getCurrentMenu().setNo(selectedMenuNo);
		} else {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		}
		
		log.info("userid:" + sessionUserId);
		log.info("after selected_menu_no:" + selectedMenuNo);
		
		request.setAttribute("exception_content", now_exception.toString());
		request.setAttribute("contentTitle", "오류");
		
		if (request.getParameter("isAjax") != null && request.getParameter("isAjax").equals("Y")) {
			
			ModelAndView mav = new ModelAndView("default_exception_ajax");
	    	mav.addObject("exception_content", now_exception.toString());
	    	mav.addObject("contentTitle", "오류");
	    	return mav;
	    	
		} else {

			ModelAndView mav = new ModelAndView("default_exception");
	    	mav.addObject("exception_content", now_exception.toString());
	    	mav.addObject("contentTitle", "오류");
	    	return mav;
		}
		
	
	}
}
