package kr.co.leaderway.mywork.addressBook;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.addressBook.model.AddressBook;
import kr.co.leaderway.mywork.addressBook.model.AddressBookSearchParameter;
import kr.co.leaderway.mywork.common.MyWorkAbstractController;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.util.BindUtil;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller 
@RequestMapping("/addressBook") 
public class AddressBookController extends MyWorkAbstractController {

	protected final Log logger = LogFactory.getLog(getClass());
	  
	protected ModelAndView doExecute(HttpServletRequest request,
             HttpServletResponse response) throws Exception {
		
		logger.debug("request:" + request.getRequestURI());
		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("getAddressBookList")) {
			
			return getAddressBookList(request, response);

		} else if  (mode.equals("addressBookList")) {
			return getAddressBookList(request, response);
		} else if  (mode.equals("addAddressBook")) {
			return addAddressBook(request, response);
		} else {
			return getAddressBookList(request, response);
		}
			
	}
	
	public ModelAndView getAddressBookList(HttpServletRequest request, HttpServletResponse response)
            throws Exception {

		AddressBookService addressBookService = (AddressBookService) ServiceCallUtil.call(AddressBookService.class, getServiceType("AddressBookService")); 
		
		AddressBookSearchParameter addressBookSearchParameter = new AddressBookSearchParameter();
		addressBookSearchParameter.setCurrentPage(1);
		addressBookSearchParameter.setRowsPerPage(1000);
		
		MyWorkList addressBookList = addressBookService.listAddressBook(addressBookSearchParameter);
	
        ModelAndView mav = new ModelAndView("addressBook.addressBookList");
    	
    	mav.addObject("contentTitle", "주소록 리스트");
    	mav.addObject("addressBookList", addressBookList);
    	
    	return mav;

    }
	
	private ModelAndView addAddressBook(HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		AddressBook addressBook = new AddressBook();
		BindUtil.bind(request, addressBook);

		AddressBookService addressBookService = (AddressBookService) ServiceCallUtil.call(AddressBookService.class, getServiceType("AddressBookService")); 
		addressBookService.addAddressBook(addressBook);
		
        ModelAndView mav = new ModelAndView("addressBook.addressBookList");
    	
    	mav.addObject("contentTitle", "주소록 리스트");
    	return mav;
	
	}
}
