package kr.co.leaderway.mywork.board.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.MyWorkException.MyWorkNotAuthorizedException;
import kr.co.leaderway.mywork.board.BoardService;
import kr.co.leaderway.mywork.board.form.ArticleForm;
import kr.co.leaderway.mywork.board.model.Article;
import kr.co.leaderway.mywork.board.model.ArticleSearchParameter;
import kr.co.leaderway.mywork.board.model.Board;
import kr.co.leaderway.mywork.board.model.SchemeAndCategory;
import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.category.CategoryUtil;
import kr.co.leaderway.mywork.category.model.Category;
import kr.co.leaderway.mywork.category.model.CategoryScheme;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.right.RightService;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.user.model.UserInfo;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class ArticleAction extends BaseAction {

	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";

		if (mode.equals("add_article")) {

			add_article(mapping, form, request, response);

			ArticleForm articleForm = (ArticleForm) form;
			String boardNo = articleForm.getBoardNo();
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("ArticleAction"));
			redirect.addParameter("mode", "list_article");
			redirect.addParameter("boardNo", boardNo);
			return redirect;

		} else if (mode.equals("add_article_form")) {

			list_accessible_board(mapping, form, request, response);
			String boardNo_string = request.getParameter("boardNo");
			request.setAttribute("boardNo", boardNo_string);
			list_categories_of_board(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시글 추가");
			
			return mapping.findForward("article_add");

		} else if (mode.equals("modify_article_form")) {
			
			
			if (request.getParameter("redirected") != null || (String)request.getParameter("redirected") == "redirected") {
				view_article(mapping, form, request, response);
				list_categories_of_board(mapping, form, request, response);
				request.setAttribute("contentTitle", "게시글 수정");
				
				return mapping.findForward("article_modify");

			} else {
				
				ActionRedirect redirect = new ActionRedirect(mapping.findForward("ArticleAction"));
				redirect.addParameter("mode", "modify_article_form");
				redirect.addParameter("boardNo", request.getParameter("boardNo"));
				redirect.addParameter("no", request.getParameter("no"));
				redirect.addParameter("revision", request.getParameter("revision"));
				
				//BoardServiceDelegate boardService = new BoardServiceDelegate(ServiceType.ServiceLocal);
				BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
				MyWorkList categoryList = boardService.getCategoryList(request.getParameter("no"), Integer.parseInt(request.getParameter("revision")));
				Iterator categoryIter = categoryList.getList().iterator();
				
				CategoryService categoryService = (CategoryService) ServiceCallUtil.call(CategoryService.class, getServiceType("categoryService")); 
				List categoryNameFilledList = new ArrayList();
				while ( categoryIter.hasNext() ) {
					Category category = (Category)categoryIter.next();		
					redirect.addParameter("category_" + category.getSchemeNo(),category.getValue());
				}

				redirect.addParameter("redirected", "redirected");
				
				return redirect;
			}

		} else if (mode.equals("modify_article")) {
			modify_article(mapping, form, request, response);

			ArticleForm articleForm = (ArticleForm) form;
			String boardNo = articleForm.getBoardNo();
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("ArticleAction"));
			redirect.addParameter("mode", "list_article");
			redirect.addParameter("boardNo", boardNo);
			return redirect;
		} else if (mode.equals("reply_article")) {

			reply_article(mapping, form, request, response);

			ArticleForm articleForm = (ArticleForm) form;
			String boardNo = articleForm.getBoardNo();
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("ArticleAction"));
			redirect.addParameter("mode", "list_article");
			redirect.addParameter("boardNo", boardNo);
			return redirect;
			
		} else if (mode.equals("reply_article_form")) {

			ArticleForm articleForm = (ArticleForm) form;

			String boardNo = articleForm.getBoardNo();
			String articleNo = articleForm.getNo();

			request.setAttribute("boardNo", boardNo);
			request.setAttribute("articleNo", articleNo);

			request.setAttribute("contentTitle", "답글 작성");
			
			return mapping.findForward("article_reply");

		} else if (mode.equals("view_article")) {

			view_article(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시글 보기");
			
			return mapping.findForward("article_view");

		} else if (mode.equals("list_article")) {

			list_accessible_board(mapping, form, request, response);
			list_article(mapping, form, request, response);
			list_categories_of_board(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시판 글 목록 보기");
			
			return mapping.findForward("article_list");

		} else if (mode.equals("delete_article")) {

			delete_article(mapping, form, request, response);

			ArticleForm articleForm = (ArticleForm) form;
			String boardNo = articleForm.getBoardNo();
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("ArticleAction"));
			redirect.addParameter("mode", "list_article");
			redirect.addParameter("boardNo", boardNo);
			return redirect;
			
		} else if (mode.equals("assign_access_group_form")) {
			
			list_accessible_board(mapping, form, request, response);
			view_article(mapping, form, request, response);
			request.setAttribute("contentTitle", "게시판 관리 - 게시판 글 접근 그룹 할당");
			
			return mapping.findForward("article_access_group_assign_form");
		
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
			
			ArticleForm articleForm = (ArticleForm) form;
			String no = articleForm.getNo();
			String boardNo = articleForm.getBoardNo();
			int revision = articleForm.getRevision();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ArticleAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			redirect.addParameter("boardNo", boardNo);
			redirect.addParameter("revision", revision);
			return redirect;
			
		} else if (mode.equals("delete_access_group")) {
			
			delete_access_group(mapping, form, request, response);
			
			ArticleForm articleForm = (ArticleForm) form;
			String no = articleForm.getNo();
			String boardNo = articleForm.getBoardNo();
			int revision = articleForm.getRevision();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ArticleAction") );
			redirect.addParameter("mode", "assign_access_group_form");
			redirect.addParameter("no", no);
			redirect.addParameter("boardNo", boardNo);
			redirect.addParameter("revision", revision);
			return redirect;
			
		} else {  // list_accessible_board
			
			list_accessible_board(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "게시판 목록 보기");
			
			return mapping.findForward("accessible_board_list");
		}
	}

	@SuppressWarnings("unchecked")
	private void add_article(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		ArticleForm articleForm = (ArticleForm) form;

		Article article = new Article();
		PropertyUtils.copyProperties(article, articleForm);
		
		String boardNo = article.getBoardNo();
		
		Board board = new Board();
		board.setNo(boardNo);
		
		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		RightService rightService = (RightService) ServiceCallUtil.call(RightService.class, getServiceType("RightService")); 
		if (!rightService.haveRight("board", board, userInfo.getUser().getNo(), 8, remoteUserIpAddressBin)) {   // 보드 쓰기 권한이 있어야 게시글 추가 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to add article to this board");
		}
		
		List categoryList = new ArrayList();
		CategoryService categoryService = (CategoryService) ServiceCallUtil.call(CategoryService.class, getServiceType("categoryService")); 
	
		MyWorkList categorySchemeList = categoryService.listCategorySchemeByBoardNo(boardNo);
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		while ( categorySchemeIter.hasNext() ) {
			
			Category category = new Category();
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			String schemeNo = categoryScheme.getNo();
			String categoryParmaneterName = "category_" + schemeNo;
			
			category.setSchemeNo(schemeNo);
			category.setValue(request.getParameter(categoryParmaneterName));
			
			categoryList.add(category);
		}
		
		String sessionUserNo = userInfo.getUser().getNo();
		article.setId_no(sessionUserNo);
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		
		boardService.createArticle(article, categoryList);
		
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void modify_article(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		ArticleForm articleForm = (ArticleForm) form;

		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		Article article = boardService.findArticle(articleForm.getNo());
		//PropertyUtils.copyProperties(article, articleForm);
		article.setNo(articleForm.getNo());
		article.setRevision(articleForm.getRevision());
		article.setContents(articleForm.getContents());
		article.setTitle(articleForm.getTitle());
		
		String boardNo = article.getBoardNo();
		
		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		RightService rightService = (RightService) ServiceCallUtil.call(RightService.class, getServiceType("RightService")); 
		if (!rightService.haveRight("article", article, userInfo.getUser().getNo(), 8, remoteUserIpAddressBin)) {   // 게시글 쓰기 권한이 있어야 게시글 수정 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to modify this article");
		} 
		
		List categoryList = new ArrayList();
		CategoryService categoryService = (CategoryService) ServiceCallUtil.call(CategoryService.class, getServiceType("categoryService")); 
	
		MyWorkList categorySchemeList = categoryService.listCategorySchemeByBoardNo(boardNo);
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		while ( categorySchemeIter.hasNext() ) {
			
			Category category = new Category();
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			String schemeNo = categoryScheme.getNo();
			String categoryParmaneterName = "category_" + schemeNo;
			
			category.setSchemeNo(schemeNo);
			category.setValue(request.getParameter(categoryParmaneterName));
			
			categoryList.add(category);
		}
		
		String sessionUserNo = userInfo.getUser().getNo();
		article.setId_no(sessionUserNo);
		
		boardService.modifyArticle(article, categoryList);
		
		request.setAttribute("alertMessage", "수정되었습니다.");

	}
	
	private void reply_article(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		ArticleForm articleForm = (ArticleForm) form;

		Article article = new Article();
		PropertyUtils.copyProperties(article, articleForm);

		HttpSession session = request.getSession();

		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		String sessionUserNo = userInfo.getUser().getNo();
		article.setId_no(sessionUserNo);

		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		boardService.replyArticle(article);

		request.setAttribute("alertMessage", "등록되었습니다.");

	}
	
	private void view_article(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String articleNo = request.getParameter("no");
		String revision_string = request.getParameter("revision");
		int revision = Integer.parseInt(revision_string);
		
		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		Article article = boardService.findArticle(articleNo);
		
		RightService rightService = (RightService) ServiceCallUtil.call(RightService.class, getServiceType("RightService")); 
		if (!rightService.haveRight("article", article, userInfo.getUser().getNo(), 4, remoteUserIpAddressBin)) {   // 게시글 읽기 권한이 있어야 게시글 읽기 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to read this article");
		} 
		
		MyWorkList categoryList = boardService.getCategoryList(article.getNo(), article.getRevision());
		
		Iterator categoryIter = categoryList.getList().iterator();
		
		CategoryService categoryService = (CategoryService) ServiceCallUtil.call(CategoryService.class, getServiceType("categoryService")); 
		
		List categoryNameFilledList = new ArrayList();
		while ( categoryIter.hasNext() ) {
			
			Category category = (Category)categoryIter.next();

			CategoryUtil categoryUtil = new CategoryUtil();
			categoryUtil.init();
			Integer[] category_list = categoryUtil.list_category(category.getValue());
			category.setCategoryNoArray(category_list);
			Category categoryNameFilled = categoryService.getCategoryNameFilled(category);
			categoryNameFilledList.add(categoryNameFilled);
		}
		
		request.setAttribute("article", article);
		request.setAttribute("categoryNameFilledList", categoryNameFilledList);
		
		List articleAccessGroupList = boardService.findArticleAccessGroupList(articleNo, revision);
		
		request.setAttribute("articleAccessGroupList", articleAccessGroupList);

	}

	@SuppressWarnings("unchecked")
	private void list_article(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String boardNo = request.getParameter("boardNo");
		
		CategoryService categoryService = (CategoryService) ServiceCallUtil.call(CategoryService.class, getServiceType("categoryService")); 
		
		MyWorkList categorySchemeList = categoryService.listCategorySchemeByBoardNo(boardNo);
		request.setAttribute("categorySchemeList", categorySchemeList);

		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		String search = request.getParameter("search") != null ? request.getParameter("search") : "";
		String time = request.getParameter("time") != null ? request.getParameter("time") : "";
		String search_string_get = request.getParameter("search_string") != null ? request.getParameter("search_string") : "";
		String search_string = new String(search_string_get.getBytes("8859_1"),"UTF-8");
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		Board board = boardService.findBoard(boardNo);
		
		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		RightService rightService = (RightService) ServiceCallUtil.call(RightService.class, getServiceType("RightService")); 
		if (!rightService.haveRight("board", board, userInfo.getUser().getNo(), 4, remoteUserIpAddressBin)) {   // 보드 읽기 권한이 있어야 게시글 리스팅 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to read this board");
		}
		
		request.setAttribute("board", board);
		
		ArticleSearchParameter articleSearchParameter = new ArticleSearchParameter();
		articleSearchParameter.setBoardNo(boardNo);
		articleSearchParameter.setCurrentPage(page);
		articleSearchParameter.setRowsPerPage(per_page);
		articleSearchParameter.setTime(time);
		articleSearchParameter.setUserNo(userInfo.getUser().getNo());
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		List SchemeAndCategoryList = new ArrayList();
		while ( categorySchemeIter.hasNext() ) {
			
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			
			SchemeAndCategory schemeAndCategory = new SchemeAndCategory();
			
			schemeAndCategory.setSchemeNo(categoryScheme.getNo());
			log.info("category_" + categoryScheme.getNo());
			schemeAndCategory.setCategory(request.getParameter("category_" + categoryScheme.getNo()));
			
			SchemeAndCategoryList.add(schemeAndCategory);
		}
		
		articleSearchParameter.setSchemeAndCategories(SchemeAndCategoryList);
		
		if (search.equals("title")) {
			articleSearchParameter.setTitle(search_string);
		} else if (search.equals("contents")) {
			articleSearchParameter.setContents(search_string);
		} else if (search.equals("writer")) {
			articleSearchParameter.setName(search_string);
		} else if (search.equals("title-contents")) {
			articleSearchParameter.setAll(search_string);
		}
		
		MyWorkList articleList = boardService.listArticle(articleSearchParameter);
		request.setAttribute("articleList", articleList);
		
		request.setAttribute("contentTitle", board.getBoardName() + " - 리스트");
	}
	
	private void delete_article(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		ArticleForm articleForm = (ArticleForm) form;
		
		Board board = new Board();
		board.setNo(articleForm.getBoardNo());
		
		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		RightService rightService = (RightService) ServiceCallUtil.call(RightService.class, getServiceType("RightService")); 
		if (!rightService.haveRight("board", board, userInfo.getUser().getNo(), 8, remoteUserIpAddressBin)) {   // 보드 쓰기 권한이 있어야 게시글 삭제 가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to delete article to this board");
		}
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		boardService.deleteArticle(articleForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
	
	private void list_categories_of_board(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		String boardNo = request.getParameter("boardNo");
		
		CategoryService categoryService = (CategoryService) ServiceCallUtil.call(CategoryService.class, getServiceType("categoryService")); 
	
		MyWorkList categorySchemeList = categoryService.listCategorySchemeByBoardNo(boardNo);
		request.setAttribute("categorySchemeList", categorySchemeList);
		
		Iterator categorySchemeIter = categorySchemeList.getList().iterator();
		
		int leftCategoryIdx = 0;
		int rightCategoryIdx = 0;
		int topCategoryIdx = 0;
		
		while ( categorySchemeIter.hasNext() ) {
			
			CategoryScheme categoryScheme = (CategoryScheme)categorySchemeIter.next();
			
			MyWorkList categoryList = categoryService.findCategoryInfoList(categoryScheme.getNo());
			
			if (categoryScheme.getShowLocation() == 1) {
				request.setAttribute("leftCategoryList" + leftCategoryIdx, categoryList);
				leftCategoryIdx ++;
			} else if (categoryScheme.getShowLocation() == 2) {
				request.setAttribute("topCategoryList"+ topCategoryIdx, categoryList);
				topCategoryIdx ++;
			} else if (categoryScheme.getShowLocation() == 3) {
				request.setAttribute("rightCategoryList" + rightCategoryIdx, categoryList);
				rightCategoryIdx ++;
			} else {
				
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	private void list_accessible_board(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		List boardList = boardService.findAccessibleBoardListByUserNo(userInfo.getUser().getNo()); 
		
		request.setAttribute("boardList", boardList);
		
	}
	
	private void add_access_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		String selected_groupTypeNo_string = request.getParameter("selected_groupTypeNo");
		int selected_groupTypeNo = Integer.parseInt(selected_groupTypeNo_string);
		String selected_access_right_string = request.getParameter("access_right");
		int selected_access_right = Integer.parseInt(selected_access_right_string);
		
		ArticleForm articleForm = (ArticleForm) form;
		
		Article article = new Article();
		PropertyUtils.copyProperties(article, articleForm);
		
		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		RightService rightService = (RightService) ServiceCallUtil.call(RightService.class, getServiceType("RightService")); 
		if (!rightService.haveRight("article", article, userInfo.getUser().getNo(), 8, remoteUserIpAddressBin)) {   // 게시글 쓰기 권한이 있어야 게시글 접근 권한 추가  가능
			throw new MyWorkNotAuthorizedException("user doesn't have right to read this article");
		} 
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		boardService.addArticleAccessGroup(article, selected_groupno, selected_groupTypeNo, selected_access_right);
	
	}
	
	private void delete_access_group(ActionMapping mapping,
					ActionForm form,
					HttpServletRequest request,
					HttpServletResponse response) throws Exception {
		
		String selected_groupno = request.getParameter("selected_groupno");
		
		BoardService boardService = (BoardService)ServiceCallUtil.call(BoardService.class, getServiceType("BoardService"));
		boardService.deleteArticleAccessGroup(selected_groupno);
	
	}
}
