package kr.co.leaderway.mywork.category.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.category.form.CategorySchemeForm;
import kr.co.leaderway.mywork.category.model.CategoryScheme;
import kr.co.leaderway.mywork.category.model.CategorySchemeSearchParameter;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class CategorySchemeAction extends BaseAction {

	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";

		if (mode.equals("add_category_scheme")) {

			add_category_scheme(mapping, form, request, response);

			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "list_category_scheme");
			return redirect;

		} else if (mode.equals("add_category_scheme_form")) {

			String categorySchemeNo = request.getParameter("categorySchemeNo");
			request.setAttribute("categorySchemeNo", categorySchemeNo);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 추가");
			
			return mapping.findForward("category_scheme_add");

		} else if (mode.equals("modify_category_scheme_form")) {
			
			view_category_scheme(mapping, form, request, response);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 수정");
			return mapping.findForward("category_scheme_modify_form");
			
		} else if (mode.equals("modify_category_scheme")) {
			
			log.info("before modify_category_scheme");
			modify_category_scheme(mapping, form, request, response);
			log.info("after modify_category_scheme");
				
			CategorySchemeForm categorySchemeForm = (CategorySchemeForm) form;
			String categorySchemeNo = categorySchemeForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("CategorySchemeAction") );
			redirect.addParameter("mode", "view_category_scheme");
			redirect.addParameter("categorySchemeNo", categorySchemeNo);
			return redirect;
			
		} else if (mode.equals("modify_category_form")) {
			
			view_category_scheme(mapping, form, request, response);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 정보 수정");
			return mapping.findForward("category_modify_form");
			
		} else if (mode.equals("view_category_scheme")) {

			view_category_scheme(mapping, form, request, response);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 정보 보기");
			return mapping.findForward("category_scheme_view");

		} else if (mode.equals("list_category_scheme")) {

			list_category_scheme(mapping, form, request, response);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 리스트");
			
			return mapping.findForward("category_scheme_list");

		} else if (mode.equals("delete_category_scheme")) {

			delete_category_scheme(mapping, form, request, response);

			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "list_category_scheme");
			
			return redirect;
			
		} else { // list_category_scheme

			list_category_scheme(mapping, form, request, response);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 리스트");
			
			return mapping.findForward("category_scheme_list");

		}
	}

	private void add_category_scheme(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		CategorySchemeForm categorySchemeForm = (CategorySchemeForm) form;

		CategoryScheme categoryScheme = new CategoryScheme();
		PropertyUtils.copyProperties(categoryScheme, categorySchemeForm);

		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.addCategoryScheme(categoryScheme);

		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void modify_category_scheme(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		CategorySchemeForm categorySchemeForm = (CategorySchemeForm) form;
		
		CategoryScheme categoryScheme = new CategoryScheme();
		PropertyUtils.copyProperties(categoryScheme, categorySchemeForm);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.updateCategoryScheme(categoryScheme);
	
	}
	
	private void view_category_scheme(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String categorySchemeNo = request.getParameter("categorySchemeNo");

		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		CategoryScheme categoryScheme = categoryService.findCategoryScheme(categorySchemeNo);
		
		request.setAttribute("categoryScheme", categoryScheme);
		
		MyWorkList categoryInfoList = categoryService.findCategoryInfoList(categorySchemeNo);
		
		request.setAttribute("categoryInfoList", categoryInfoList);

	}

	@SuppressWarnings("unchecked")
	private void list_category_scheme(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		CategorySchemeSearchParameter categorySchemeSearchParameter = new CategorySchemeSearchParameter();
		categorySchemeSearchParameter.setCurrentPage(page);
		categorySchemeSearchParameter.setRowsPerPage(per_page);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		
		MyWorkList categorySchemeList = categoryService.listCategoryScheme(categorySchemeSearchParameter);

		request.setAttribute("categorySchemeList", categorySchemeList);

	}
	
	private void delete_category_scheme(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		CategorySchemeForm categorySchemeForm = (CategorySchemeForm) form;
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.deleteCategoryScheme(categorySchemeForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
}