package kr.co.leaderway.mywork.multiLanguage.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.multiLanguage.MultiLanguageService;
import kr.co.leaderway.mywork.multiLanguage.form.MultiLanguageForm;
import kr.co.leaderway.mywork.multiLanguage.model.MultiLanguage;
import kr.co.leaderway.mywork.multiLanguage.model.MultiLanguageSearchParameter;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class MultiLanguageAction extends BaseAction {

	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String mode = request.getParameter("mode") != null ? request	.getParameter("mode") : "";

		if  (mode.equals("add_multiLanguage_code_form")) {
			
			request.setAttribute("contentTitle", "multi language 관리 - multi language code 추가");
			
			return mapping.findForward("multiLanguage_add_code_form");
				
		} else if (mode.equals("add_multiLanguage_code")) {

			add_multiLanguage_code(mapping, form, request, response);

			ActionRedirect redirect = new ActionRedirect(mapping.findForward("MultiLanguageAction"));
			redirect.addParameter("mode", "list_multiLanguage_code");
			return redirect;
			
		} else if (mode.equals("list_multiLanguage_code")) { 

			list_multiLanguage_code(mapping, form, request, response);
			request.setAttribute("contentTitle", "multi language 관리 - multi language code 리스트");
			 
			return mapping.findForward("multiLanguage_code_list");
		
		} else if (mode.equals("view_multiLanguage_code")) { 

			view_multiLanguage_code(mapping, form, request, response);
			request.setAttribute("contentTitle", "multi language 관리 - multi language code 보기");
			 
			return mapping.findForward("multiLanguage_code_view");
				
		} else if  (mode.equals("add_multiLanguage_lang_form")) {
			
			request.setAttribute("contentTitle", "multi language 관리 - multi language lang 추가");
			
			return mapping.findForward("multiLanguage_add_lang_form");
				
		} else if (mode.equals("add_multiLanguage_lang")) {

			add_multiLanguage_lang(mapping, form, request, response);

			ActionRedirect redirect = new ActionRedirect(mapping.findForward("MultiLanguageAction"));
			redirect.addParameter("mode", "list_multiLanguage_lang");
			return redirect;
			
		} else if (mode.equals("list_multiLanguage_lang")) { 

			list_multiLanguage_lang(mapping, form, request, response);
			request.setAttribute("contentTitle", "multi language 관리 - multi language lang 리스트");
			 
			return mapping.findForward("multiLanguage_lang_list");
		
		} else if (mode.equals("view_multiLanguage_lang")) { 

			view_multiLanguage_lang(mapping, form, request, response);
			request.setAttribute("contentTitle", "multi language 관리 - multi language lang 보기");
			 
			return mapping.findForward("multiLanguage_lang_view");
				
		} else if  (mode.equals("add_multiLanguage_form")) {
			
			request.setAttribute("contentTitle", "multi language 관리 - multi language 추가");
			
			return mapping.findForward("multiLanguage_add_form");
			
		} else if (mode.equals("add_multiLanguage")) {

			add_multiLanguage(mapping, form, request, response);

			ActionRedirect redirect = new ActionRedirect(mapping.findForward("MultiLanguageAction"));
			redirect.addParameter("mode", "list_multiLanguage");
			return redirect;
			
		} else { // list_multiLanguage

			list_multiLanguage(mapping, form, request, response);
			request.setAttribute("contentTitle", "multi language 관리 - multi language 리스트");
			 
			return mapping.findForward("multiLanguage_list");

		}
	}
	
	private void list_multiLanguage(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);
		
		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);
		
		MultiLanguageSearchParameter multiLanguageSearchParameter = new MultiLanguageSearchParameter();
		multiLanguageSearchParameter.setCurrentPage(page);
		multiLanguageSearchParameter.setRowsPerPage(per_page);
		
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		MyWorkList multiLanguageList = multiLanguageService.getMultiLanguageList(multiLanguageSearchParameter); 
		
		request.setAttribute("multiLanguageList", multiLanguageList);
	
	}
	
	private String add_multiLanguage_lang(ActionMapping mapping,
											ActionForm form,
											HttpServletRequest request,
											HttpServletResponse response) throws Exception {
		
		MultiLanguageForm multiLanguageForm = (MultiLanguageForm) form;
		
		log.info("getMultiLanguageCode:" +multiLanguageForm.getMultiLanguageLangCode());
		log.info("getMultiLanguageCodeDescription:" + multiLanguageForm.getMultiLanguageLangDescription());
		
		MultiLanguage multiLanguage = new MultiLanguage();
		PropertyUtils.copyProperties(multiLanguage, multiLanguageForm);
		
		log.info("1111getMultiLanguageCode:" +multiLanguage.getMultiLanguageLangCode());
		log.info("2222getMultiLanguageCodeDescription:" + multiLanguage.getMultiLanguageLangDescription());
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		String multiLanguageNo = multiLanguageService.addMultiLanguageLang(multiLanguage); 
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
		return multiLanguageNo;
	}
	
	private void list_multiLanguage_lang(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);
		
		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);
		
		MultiLanguageSearchParameter multiLanguageSearchParameter = new MultiLanguageSearchParameter();
		multiLanguageSearchParameter.setCurrentPage(page);
		multiLanguageSearchParameter.setRowsPerPage(per_page);
		
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		MyWorkList multiLanguageLangList = multiLanguageService.getMultiLanguageLangList(multiLanguageSearchParameter); 
		
		request.setAttribute("multiLanguageLangList", multiLanguageLangList);
	
	}
	
	private void view_multiLanguage_lang(ActionMapping mapping,
											ActionForm form,
											HttpServletRequest request,
											HttpServletResponse response) throws Exception {
		
		String multiLanguageLangNo = request.getParameter("no");
		
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		MultiLanguage multiLanguage = multiLanguageService.getMultiLanguageLang(multiLanguageLangNo);
		
		request.setAttribute("multiLanguage", multiLanguage);
	
	}
	
	private String add_multiLanguage_code(ActionMapping mapping,
											ActionForm form,
											HttpServletRequest request,
											HttpServletResponse response) throws Exception {
		
		MultiLanguageForm multiLanguageForm = (MultiLanguageForm) form;
		
		log.info("getMultiLanguageCode:" +multiLanguageForm.getMultiLanguageLangCode());
		log.info("getMultiLanguageCodeDescription:" + multiLanguageForm.getMultiLanguageLangDescription());
		
		MultiLanguage multiLanguage = new MultiLanguage();
		PropertyUtils.copyProperties(multiLanguage, multiLanguageForm);
		
		log.info("1111getMultiLanguageCode:" +multiLanguage.getMultiLanguageLangCode());
		log.info("2222getMultiLanguageCodeDescription:" + multiLanguage.getMultiLanguageLangDescription());
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		String multiLanguageCodeNo = multiLanguageService.addMultiLanguageCode(multiLanguage); 
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
		return multiLanguageCodeNo;
	}
	
	private void list_multiLanguage_code(ActionMapping mapping,
											ActionForm form,
											HttpServletRequest request,
											HttpServletResponse response) throws Exception {
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);
		
		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);
		
		MultiLanguageSearchParameter multiLanguageSearchParameter = new MultiLanguageSearchParameter();
		multiLanguageSearchParameter.setCurrentPage(page);
		multiLanguageSearchParameter.setRowsPerPage(per_page);
		
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		MyWorkList multiLanguageCodeList = multiLanguageService.getMultiLanguageCodeList(multiLanguageSearchParameter); 
		
		request.setAttribute("multiLanguageCodeList", multiLanguageCodeList);
	
	}

	private void view_multiLanguage_code(ActionMapping mapping,
											ActionForm form,
											HttpServletRequest request,
											HttpServletResponse response) throws Exception {
		
		String multiLanguageCodeNo = request.getParameter("no");
		
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		MultiLanguage multiLanguage = multiLanguageService.getMultiLanguageCode(multiLanguageCodeNo);
		
		request.setAttribute("multiLanguage", multiLanguage);
	
	}
	
	private String add_multiLanguage(ActionMapping mapping,
							ActionForm form,
							HttpServletRequest request,
							HttpServletResponse response) throws Exception {
		
		MultiLanguageForm multiLanguageForm = (MultiLanguageForm) form;
		
		MultiLanguage multiLanguage = new MultiLanguage();
		PropertyUtils.copyProperties(multiLanguage, multiLanguageForm);
		
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
		String multiLanguageNo = multiLanguageService.addMultiLanguage(multiLanguage); 
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
		return multiLanguageNo;
	}
	
}
