package kr.co.leaderway.mywork.option.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.option.OptionService;
import kr.co.leaderway.mywork.option.form.OptionForm;
import kr.co.leaderway.mywork.option.model.Option;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ColorTool;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class OptionAction extends BaseAction{
	
	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, 
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response)
	        										throws Exception {
		
		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_option")) {
			
			add_option(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("TypeAction") );
			redirect.addParameter("mode", "view_type");
			
			OptionForm optionForm = (OptionForm) form;
			redirect.addParameter("no", optionForm.getTypeNo());
			
			return redirect;
				
		} else if  (mode.equals("view_option")) {
				
			view_option(mapping, form, request, response);
				
			return mapping.findForward("option_view");
				
		} else if (mode.equals("add_option_form")) {
			
			return mapping.findForward("option_add_form");
			
		} else if (mode.equals("modify_option_form")) {
			
			return mapping.findForward("option_modify_form");
			
		} else if (mode.equals("lower_option")) {
			
			lower_option(mapping, form, request, response);
			
			String typeNo_string = request.getParameter("typeNo") != null ? (String) request.getParameter("typeNo") : "";
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("TypeAction") );
			redirect.addParameter("mode", "assign_option_form");
			redirect.addParameter("no", typeNo_string );
			return redirect;
			
		} else if  (mode.equals("delete_option")) {
				
			delete_option(mapping, form, request, response);
				
			String typeNo_string = request.getParameter("typeNo") != null ? (String) request.getParameter("typeNo") : "";
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("TypeAction") );
			redirect.addParameter("mode", "view_type");
			redirect.addParameter("no", typeNo_string );
			return redirect;
				
	    } else { // list_type
	    	
	    	list_option(mapping, form, request, response);
	    	
	    	return mapping.findForward("option_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_option(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		List typeList = optionService.listType(1, 10); 
		
		request.setAttribute("typeList", typeList);
		
	}
	
	
	
	private void add_option(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		OptionForm optionForm = (OptionForm) form;
		
		Option option = new Option();
		PropertyUtils.copyProperties(option, optionForm);
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		optionService.create(option); 
		
		if (option.getName().equals("colors")) {
			ColorTool.clearColorList();
		}
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	
	}

	private void delete_option(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String optionNo = request.getParameter("no");
	
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		Option option = optionService.findOptionByNo(optionNo);
		
		optionService.deleteOption(optionNo); 
		
		if (option.getName().equals("colors")) {
			ColorTool.clearColorList();
		}
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
	
	private void view_option(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String optionNo = request.getParameter("no");
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		Option option = optionService.findOptionByNo(optionNo);
		
		request.setAttribute("option", option);
	
	}
	
	private void lower_option(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
										
		String optionNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		String typeNo = request.getParameter("typeNo") != null ? (String) request.getParameter("typeNo") : "";
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		optionService.lowerOption(optionNo, typeNo);
		
		request.setAttribute("alertMessage", "변경되었습니다.");
		
	}
}
