package kr.co.leaderway.mywork.option.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.option.OptionService;
import kr.co.leaderway.mywork.option.form.TypeForm;
import kr.co.leaderway.mywork.option.model.Type;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class TypeAction extends BaseAction{
	
	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, 
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response)
	        										throws Exception {
		
		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_type")) {
			
			add_type(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("TypeAction") );
			redirect.addParameter("mode", "list_type");
			return redirect;
				
		} else if (mode.equals("add_type_form")) {
			request.setAttribute("contentTitle", "타입 관리 - 추가");	
			return mapping.findForward("type_add_form");
			
		} else if  (mode.equals("view_type")) {
			
			view_type(mapping, form, request, response);
			request.setAttribute("contentTitle", "타입 관리 - 보기");		
			return mapping.findForward("type_view");
				
		} else if (mode.equals("modify_type_form")) {
			
			view_type(mapping, form, request, response);
			request.setAttribute("contentTitle", "타입 관리 - 수정");	
			return mapping.findForward("type_modify_form");
			
		} else if  (mode.equals("modify_type")) {
				
			modify_type(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("TypeAction") );
			redirect.addParameter("mode", "list_type");
			return redirect;
				
		} else if (mode.equals("assign_option_form")) {
			
			view_type(mapping, form, request, response);
			request.setAttribute("contentTitle", "타입 관리 - 옵션 할당");	
			return mapping.findForward("option_assign_form");
			
	    } else { // list_type
	    	
	    	list_type(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "타입 관리 - 리스트");	
	    	return mapping.findForward("type_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_type(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		List typeList = optionService.listType(1, 10);
		
		request.setAttribute("typeList", typeList);
		
	}
	
	private void add_type(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		TypeForm typeForm = (TypeForm) form;
		
		Type type = new Type();
		PropertyUtils.copyProperties(type, typeForm);
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		optionService.create(type); 
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	
	}
	
	private void modify_type(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		TypeForm typeForm = (TypeForm) form;
		
		Type type = new Type();
		PropertyUtils.copyProperties(type, typeForm);
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		optionService.updateType(type); 
		
		request.setAttribute("alertMessage", "수정되었습니다.");
	
	}

	@SuppressWarnings("unchecked")
	private void view_type(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		TypeForm typeForm = (TypeForm) form;
		String typeNo = typeForm.getNo();
		
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		Type type = optionService.findType(typeNo);
		
		request.setAttribute("type", type);
		
		List optionList = optionService.findOptionListByType(typeNo);
		request.setAttribute("optionList", optionList);

	}
}
