package kr.co.leaderway.mywork.user.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.user.UserService;
import kr.co.leaderway.mywork.user.form.UserGroupForm;
import kr.co.leaderway.mywork.user.model.UserGroup;
import kr.co.leaderway.mywork.user.model.UserGroupSearchParameter;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class UserGroupAction extends BaseAction{
	/**
	 * 
	 * 
	 *
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_user_group")) {
			
			add_user_group(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserGroupAction") );
			redirect.addParameter("mode", "list_user_group");
			return redirect;

		} else if (mode.equals("add_user_group_form")) {
			
			request.setAttribute("contentTitle", "사용자 그룹 관리 - 그룹 추가");
			return mapping.findForward("user_group_add_form");
			
		} else if (mode.equals("view_user_group")) {
			
			view_user_group(mapping, form, request, response);
			request.setAttribute("contentTitle", "사용자 그룹 관리 - 그룹 보기");
			return mapping.findForward("user_group_view");
			
		} else if (mode.equals("modify_user_group_form")) {
			
			view_user_group(mapping, form, request, response);
			request.setAttribute("contentTitle", "사용자 그룹 관리 - 그룹 수정");
			return mapping.findForward("user_group_modify_form");
			
		} else if (mode.equals("modify_user_group")) {
			
			modify_user_group(mapping, form, request, response);
				
			UserGroupForm userGroupForm = (UserGroupForm) form;
			String group_no = userGroupForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserGroupAction") );
			redirect.addParameter("mode", "view_user_group");
			redirect.addParameter("no", group_no);
			return redirect;
			
		} else if (mode.equals("delete_user_group")) {
			
			delete_user_group(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserGroupAction") );
			redirect.addParameter("mode", "list_user_group");
			return redirect;
			
	    } else { // list_user_group
	    	
	    	list_user_group(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "사용자 그룹 관리 - 리스트");
	    	
	    	return mapping.findForward("user_group_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_user_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		UserGroupSearchParameter userGroupSearchParameter = new UserGroupSearchParameter();
		userGroupSearchParameter.setCurrentPage(page);
		userGroupSearchParameter.setRowsPerPage(per_page);
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		MyWorkList userGroupList = userService.findUserGroupList(userGroupSearchParameter);
		
		request.setAttribute("userGroupList", userGroupList);
		
	}
	
	private void add_user_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		UserGroupForm userGroupForm = (UserGroupForm) form;
		
		UserGroup userGroup = new UserGroup();
		PropertyUtils.copyProperties(userGroup, userGroupForm);

		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.addUserGroup(userGroup);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
	}
	
	private void delete_user_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		UserGroupForm userGroupForm = (UserGroupForm) form;

		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.deleteUserGroup(userGroupForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
		
	}
	
	private void view_user_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		UserGroupForm userGroupForm = (UserGroupForm) form;
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		UserGroup userGroup = (UserGroup) userService.findUserGroupByNo(userGroupForm.getNo());
													  
		List accessGroupInfoList = userService.findAccessGroupInfoList(userGroup);
		
		request.setAttribute("accessGroupInfoList", accessGroupInfoList);
		request.setAttribute("userGroup", userGroup);		

	}
	
	private void modify_user_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		UserGroupForm userGroupForm = (UserGroupForm) form;
		
		UserGroup userGroup = new UserGroup();
		PropertyUtils.copyProperties(userGroup, userGroupForm);
	
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.updateUserGroup(userGroup);

	}
	
}
