package kr.co.leaderway.mywork.util;

import java.util.ArrayList;
import java.util.List;

import kr.co.leaderway.mywork.multiLanguage.MultiLanguageService;
import kr.co.leaderway.mywork.multiLanguage.model.LocaleAndName;
import kr.co.leaderway.mywork.statics.ServiceType;
import kr.co.leaderway.mywork.system.MyWorkConfig;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLanguageTool {
	
	private static Log log = LogFactory.getLog(MultiLanguageTool.class);
	
	private static List localedNameList = new ArrayList();
	
	public static String getLocaleName(String codeNo, String language) throws Exception {
		
		String defaultLanguage = MyWorkConfig.getString("defaultValuesConfig.defaultLocale");
		String defaultedName = "";
		
		for (int i = 0 ; i < localedNameList.size() ; i++) {
			LocaleAndName localeAndName = (LocaleAndName)localedNameList.get(i);
			
			if (localeAndName.getCodeNo().equals(codeNo)) {
				if (localeAndName.getLanguage().equals(language)) {	
					if (localeAndName.getName().equals("no Localed Name") && defaultedName.length() > 0) {
						return defaultedName;
					} else {
						return localeAndName.getName();
					}
				} else if (localeAndName.getLanguage().equals(defaultLanguage)) {
					defaultedName = localeAndName.getName();
				}
			}
		}
		
		MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, ServiceType.ServiceDefault);
		
		String nameGet = multiLanguageService.getLocaledName(codeNo, language);
		if (nameGet == null || nameGet.equals("null")) {
			nameGet = "no Localed Name";
			defaultedName = multiLanguageService.getLocaledName(codeNo, defaultLanguage);
			if (defaultedName == null || defaultedName.equals("null")) {
				defaultedName = "no Localed Name";
			}
		}
		LocaleAndName localeAndNameGet = new LocaleAndName();
		localeAndNameGet.setCodeNo(codeNo);
		localeAndNameGet.setLanguage(language);
		localeAndNameGet.setName(nameGet);
		localedNameList.add(localeAndNameGet);
		
		if (nameGet.equals("no Localed Name") && defaultedName.length() > 0) {
			return defaultedName;
		}
		return nameGet;
			
		
	}
	
	public static void clearlocaledNameList() {
		localedNameList = new ArrayList();
	}
	
}
