<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="java.lang.Math" %>
<%@ page import="kr.co.leaderway.mywork.schedule.model.*" %>
<%@ page import="kr.co.leaderway.util.DateTool" %>

<SCRIPT LANGUAGE="JavaScript">
function deleteSchedule(scheduleNo, scheduleTitle) {
  var answer = confirm(scheduleTitle + '일정을 지우시겠습니까?');
  if(answer == false) {
  } else {
		f.action = "ScheduleAction.do?mode=delete_schedule&no=" + scheduleNo;
		f.submit();
  }
}

function list_schedule() {
	location.href = Base64.decode("<%=request.getParameter("before_url")%>");
}

</SCRIPT>

<%

Schedule schedule = (Schedule)request.getAttribute("schedule");

String week_array[] = {"일", "월", "화", "수", "목", "금", "토"};

String repeat_type_array[] = {"none", "daily", "weekly", "monthly", "yearly"};
int repeat_type_num = schedule.getRepeatType() - 1;
String event_type_array[] = {"특정시간", "특정기간", "하루종일", "해야할일"};
int event_type_num = schedule.getEventType() - 1;
String from_date = schedule.getFromDate();

String from_date_show = from_date.substring(0,4) + "년 " + from_date.substring(4,6) + "월 " + from_date.substring(6,8) + "일";
String from_time = schedule.getFromTime();
String from_time_show = from_time.substring(0,2) + "시 " + from_time.substring(2,4) + "분";

String repeat_from_date = schedule.getRepeatFromDate();
String repeat_from_date_show = repeat_from_date.substring(0,4) + "년 " + repeat_from_date.substring(4,6) + "월 " + repeat_from_date.substring(6,8) + "일";

int from_week = schedule.getFromWeek();

String from_week_show = "";
if (from_week > 0 && from_week < 7) {
	from_week_show = week_array[from_week - 1];
} else {
	from_week_show = "";
}

String from_days = schedule.getFromDays() + "일";

String to_date = schedule.getToDate();
String to_date_show = to_date.substring(0,4) + "년 " + to_date.substring(4,6) + "월 " + to_date.substring(6,8) + "일";
String to_time = schedule.getToTime();
String to_time_show = to_time.substring(0,2) + "시 " + to_time.substring(2,4) + "분";

String repeat_end_date = schedule.getRepeatEndDate();
String repeat_end_date_show = repeat_end_date.substring(0,4) + "년 " + repeat_end_date.substring(4,6) + "월 " + repeat_end_date.substring(6,8) + "일";

int to_week = schedule.getToWeek();

String to_week_show = "";
if (to_week > 0 && to_week < 7) {
	to_week_show = week_array[to_week - 1];
} else {
	to_week_show = "";
}

String to_days = schedule.getToDays() + "일";

long diff_from_to_date = DateTool.dateStringToTimeStamp(to_date + to_time, "yyyyMMddhhmmss") - DateTool.dateStringToTimeStamp(from_date + from_time, "yyyyMMddhhmmss");

int diff_days = (int)Math.floor(diff_from_to_date / 86400);
int diff_hours = (int)Math.floor((diff_from_to_date % 86400) / 3600);
int diff_minutes = (int)Math.floor(((diff_from_to_date % 86400) % 3600) / 60 / 10) * 10;

int show_days_selected = diff_days;
int show_hour_selected = diff_hours;
int show_minute_selected = diff_minutes;

String is_lunar_show = "";
if (schedule.getIsLunar() == 1) {
   is_lunar_show = "음력";
} else {
   is_lunar_show = "";
}

String text = schedule.getText(); 

if (repeat_type_num == 1) {
   from_date_show = "";
   from_days = "";
   to_date_show = "";
   to_days = "";
} else if (repeat_type_num == 2) {
   from_date_show = "";
   from_days = "";
   to_date_show = "";
   to_days = "";
} else if (repeat_type_num == 3) {
   from_date_show = "";
   to_date_show = "";
   from_week_show = "";
   to_week_show = "";
} else if (repeat_type_num == 4) {
   from_date_show = from_date.substring(4,6) + "월 " + from_date.substring(6,8) + "일";
   to_date_show = to_date.substring(4,6) + "월 " + to_date.substring(6,8) + "일";
   from_days = "";
   from_week_show = "";
   to_days = "";
   to_week_show = "";
} else {
   from_days = "";
   from_week_show = "";
   to_days = "";
   to_week_show = "";
}

String list_day_start = "";
String list_day_end = "";

%>
<table width=100% cellspacing=0 bgcolor=#A5A595 border=0 cellpadding=0>
  <tr>
    <td width=50% valign=top>

<table width=100% cellspacing=0 bgcolor=#A5A595 border=0 cellpadding=5>
  <!-- repeat -->
  <tr>
    <td width="80" bgcolor="#A5A595" align="center">
      <font color="white"><b>반복형태</b></font></td>
    <td colspan=3 bgcolor="white" align="left">
      <%=repeat_type_array[repeat_type_num] %>
    </td>
  </tr>
<%

if (repeat_type_num != 0) {
%>
  <!-- repeat_from_time -->
  <tr>
    <td id=repeat_from_td width="80" bgcolor="#A5A595" align="center">
      <font color="white"><b>반복<br>시작 날자</b></font></td>
    <td id=repeat_from_year_td bgcolor="white" align="left">
       <%=repeat_from_date_show %>
    </td>
  </tr>

  <!-- repeat_end_time -->
  <tr>
    <td id=repeat_end_td width="80" bgcolor="#A5A595" align="center">
      <font color="white"><b>반복<br>종료 날자</b></font></td>
    <td id=repeat_end_year_td bgcolor="white" align="left">
       <%=repeat_end_date_show %>
    </td>
  </tr>
<%
}
%>

  <!-- event -->
  <tr>
    <td width="80" bgcolor="#A3A3A3" align="center">
      <font color="white"><b>이벤트 형태</b></font></td>
    <td colspan=3 bgcolor="white" align="left">
       <%=event_type_array[event_type_num] %>
    </td>
  </tr>
  
<%
if (event_type_num == 0) {
%>
  <tr >
    <td id=from_td width="80" bgcolor=#A3A3A3 align="center">
      <font color="white"><b>시간</b></font>
    </td>
    <td id=from_year_td bgcolor="white" align="left">
      <%=from_date_show%> <%=from_days%> <%=from_time_show%> <%=is_lunar_show%>
    </td>
  </tr>
<%
} else if (event_type_num == 2) {
%>
  <tr >
    <td id=from_td width="80" bgcolor=#A3A3A3 align="center">
      <font color="white"><b>시간</b></font>
    </td>
    <td id=from_year_td bgcolor="white" align="left">
      <%=from_date_show%> <%=from_days%> <%=is_lunar_show%>
    </td>
  </tr>
<%
} else if (event_type_num == 3) {
%>
  <!-- closing_time -->
  <tr>
    <td id=end_td width="80" bgcolor=#A3A3A3 align="center">
      <font color="white"><b> 마감 시간</b></font>
    </td>
    <td id=end_year_td bgcolor="white" align="left">
      <%=to_date_show%> <%=to_days%> <%=to_week_show%> <%=to_time_show%> <%=is_lunar_show%>
    </td>
  </tr>

  <!-- show_time -->
  <tr >
    <td id=from_td width="80" bgcolor=#A3A3A3 align="center">
      <font color="white"><b> 미리 알림 시간</b></font>
    </td>
    <td id=from_year_td bgcolor="white" align="left">
      <%=show_days_selected%> 일 <%=show_hour_selected%> 시간 <%=show_minute_selected%> 분 전
    </td>
  </tr>

<%
} else {
%>
  <!-- from_time -->
  <tr >
    <td id=from_td width="80" bgcolor=#A3A3A3 align="center">
      <font color="white"><b> 시작 시간</b></font>
    </td>
    <td id=from_year_td bgcolor="white" align="left">
      <%=from_date_show%> <%=from_days%> <%=from_week_show%> <%=from_time_show%> <%=is_lunar_show%>
    </td>
  </tr>

  <!-- end_time -->
  <tr>
    <td id=end_td width="80" bgcolor=#A3A3A3 align="center">
      <font color="white"><b> 종료 시간</b></font>
    </td>
    <td id=end_year_td bgcolor="white" align="left">
      <%=to_date_show%> <%=to_days%> <%=to_week_show%> <%=to_time_show%> <%=is_lunar_show%>
    </td>
  </tr>
<%
}
%>

</table>

    </td>

    <td width=50% valign=top>

<table width=100% cellspacing="1" bgcolor="#A5A595" border="0" cellpadding="5">

  <!-- title -->
  <tr>
    <td width="80" bgcolor="#A5A595" align="center">
      <font color="white"><b>제목</b></font></td>
    <td bgcolor="white" align="left"><%=schedule.getTitle()%></td>
  </tr>

  <!-- Text -->
  <tr>
    <td width="80" bgcolor="#C5C5B5" align="center">
      <font color="white"><b>내용</b></font></td>
    <td bgcolor="white" align="left"><%=schedule.getText()%></td>
  </tr>
</table>
    </td>
  </tr>
  <tr>
    <td colspan=2 align="right">
      <b>| <a href="javascript:deleteSchedule('<%=schedule.getNo() %>','<%=schedule.getTitle() %>')">삭제</a> </b>
      <b>| <a href="ScheduleAction.do?mode=modify_schedule_form&no=<%=schedule.getNo() %>&category=<%=schedule.getCategory() %>&before_url=<%=request.getParameter("before_url")%>">수정</a> </b>
      <b>| <a href=javascript:onclick=list_schedule()>목록보기</a> |</b>
    </td>
  </tr>
</table>