package kr.co.leaderway.mywork.extAttr.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.extAttr.ExtAttrService;
import kr.co.leaderway.mywork.extAttr.form.ExtAttrForm;
import kr.co.leaderway.mywork.extAttr.model.ExtAttr;
import kr.co.leaderway.mywork.extAttr.model.ExtAttrSearchParameter;
import kr.co.leaderway.mywork.extAttr.model.ExtAttrType;
import kr.co.leaderway.mywork.option.OptionService;
import kr.co.leaderway.mywork.option.model.Option;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ColorTool;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.util.XMLtool;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.w3c.dom.Document;

public class ExtAttrAction extends BaseAction{
	
	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, 
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response)
	        										throws Exception {
		
		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_attr")) {
			
			String attrNo = add_attr(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ExtAttrAction") );
			redirect.addParameter("mode", "view_attr");
			redirect.addParameter("no", attrNo);
			
			return redirect;
				
		} else if  (mode.equals("view_attr")) {
				
			request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 보기");
			
			view_attr(mapping, form, request, response);
				
			return mapping.findForward("attr_view");
			
		} else if (mode.equals("view_attr_ajax")) {
			
			String attrNo = request.getParameter("no");
			log.info("attrNo:" + attrNo);
			ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
			ExtAttr extAttr = extAttrService.getExtAttr(attrNo);
			
			Document attrDoc = XMLtool.makeDocument(extAttr);
			String xmlString = XMLtool.generate_xml_from_document(attrDoc);
			
			log.info("-------------------------------------------------------------------------------------------------");
			log.info("-------------------------------------------------------------------------------------------------");
			log.info("-------------------------------------------------------------------------------------------------");
			log.info("-------------------------------------------------------------------------------------------------");
			log.info("-------------------------------------------------------------------------------------------------xmlString:" + xmlString);
			log.info("-------------------------------------------------------------------------------------------------");
			log.info("-------------------------------------------------------------------------------------------------");
			log.info("-------------------------------------------------------------------------------------------------");
			log.info("-------------------------------------------------------------------------------------------------");
			request.setAttribute("xmlString", xmlString);
			
			return mapping.findForward("attr_view_xml");
			
		} else if (mode.equals("add_attr_form")) {
			
			request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 추가");
			
			return mapping.findForward("attr_add_form");
			
		} else if (mode.equals("modify_attr_form")) {
			
			request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 수정");
			
			view_attr(mapping, form, request, response);
			
			return mapping.findForward("attr_modify_form");
		
		} else if  (mode.equals("modify_attr")) {
			
			modify_attr(mapping, form, request, response);
			ExtAttrForm extAttrForm = (ExtAttrForm) form;
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ExtAttrAction") );
			redirect.addParameter("mode", "view_attr");
			redirect.addParameter("no", extAttrForm.getNo());
			return redirect;
			
		} else if  (mode.equals("delete_attr")) {
				
			delete_attr(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ExtAttrAction") );
			redirect.addParameter("mode", "list_attr");
			return redirect;
				
		} else if  (mode.equals("add_attr_type")) {
			
			String attrNo = add_attr_type(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ExtAttrAction") );
			redirect.addParameter("mode", "view_attr_type");
			redirect.addParameter("no", attrNo);
			
			return redirect;
				
		} else if  (mode.equals("view_attr_type")) {
				
			request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 타입 보기");
			
			view_attr_type(mapping, form, request, response);
				
			return mapping.findForward("attr_type_view");
				
		} else if (mode.equals("add_attr_type_form")) {
			
			request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 타입 추가");
			
			return mapping.findForward("attr_type_add_form");
			
		} else if (mode.equals("modify_attr_type_form")) {
			
			request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 타입 수정");
			
			view_attr_type(mapping, form, request, response);
			
			return mapping.findForward("attr_type_modify_form");
			
		} else if  (mode.equals("modify_attr_type")) {
			
			modify_attr_type(mapping, form, request, response);
			ExtAttrForm extAttrForm = (ExtAttrForm) form;
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ExtAttrAction") );
			redirect.addParameter("mode", "view_attr_type");
			redirect.addParameter("no", extAttrForm.getNo());
			return redirect;
			
		} else if  (mode.equals("delete_attr_type")) {
				
			delete_attr_type(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("ExtAttrAction") );
			redirect.addParameter("mode", "list_attr_type");
			
			return redirect;
		
		} else if (mode.equals("list_attr_type")) {
	    	
	    	list_attr_type(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 타입 목록보기");
	    	
	    	return mapping.findForward("attr_type_list");
			
	    } else { // list_attr
	    	
	    	list_attr(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "확장 속성 관리 - 확장 속성 목록보기");
	    	
	    	return mapping.findForward("attr_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_attr(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		ExtAttrSearchParameter extAttrSearchParameter = new ExtAttrSearchParameter();
		extAttrSearchParameter.setCurrentPage(page);
		extAttrSearchParameter.setRowsPerPage(per_page);
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		MyWorkList attrList = extAttrService.getExtAttrList(extAttrSearchParameter); 
		
		request.setAttribute("attrList", attrList);
		
	}
	
	
	
	private String add_attr(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		ExtAttrForm extAttrForm = (ExtAttrForm) form;
		
		ExtAttr extAttr = new ExtAttr();
		PropertyUtils.copyProperties(extAttr, extAttrForm);
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		String extAttrNo = extAttrService.addExtAttr(extAttr); 
		
		request.setAttribute("alertMessage", "등록되었습니다.");
	
		return extAttrNo;
	}

	private void delete_attr(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {

		String optionNo = request.getParameter("no");
	
		OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
		Option option = optionService.findOptionByNo(optionNo);
		
		optionService.deleteOption(optionNo); 
		
		if (option.getName().equals("colors")) {
			ColorTool.clearColorList();
		}
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
	
	private void view_attr(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {

		String attrNo = request.getParameter("no");
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		ExtAttr extAttr = extAttrService.getExtAttr(attrNo);
		
		request.setAttribute("extAttr", extAttr);
	
	}
	
	private void modify_attr(ActionMapping mapping,
									ActionForm form,
									HttpServletRequest request,
									HttpServletResponse response) throws Exception {
		
		ExtAttrForm extAttrForm = (ExtAttrForm) form;
		
		ExtAttr extAttr = new ExtAttr();
		PropertyUtils.copyProperties(extAttr, extAttrForm);
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		extAttrService.updateExtAttr(extAttr);
	
	}
	
	private void list_attr_type(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		String page_string = request.getParameter("page") != null ? request	.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);
		
		String per_page_string = request.getParameter("per_page") != null ? request	.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);
		
		ExtAttrSearchParameter extAttrSearchParameter = new ExtAttrSearchParameter();
		extAttrSearchParameter.setCurrentPage(page);
		extAttrSearchParameter.setRowsPerPage(per_page);
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		MyWorkList attrTypeList = extAttrService.getExtAttrTypeList(extAttrSearchParameter); 
		
		request.setAttribute("attrTypeList", attrTypeList);
	
	}
	
	
	
	private String add_attr_type(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		ExtAttrForm extAttrForm = (ExtAttrForm) form;
		
		ExtAttrType extAttrType = new ExtAttrType();
		PropertyUtils.copyProperties(extAttrType, extAttrForm);
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		String extAttrNo = extAttrService.addExtAttrType(extAttrType); 
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
		return extAttrNo;
	}
	
	private void delete_attr_type(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		String attrTypeNo = request.getParameter("no");
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		extAttrService.deleteExtAttrType(attrTypeNo); 
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
	
	private void view_attr_type(ActionMapping mapping,
							ActionForm form,
							HttpServletRequest request,
							HttpServletResponse response) throws Exception {
				
		String attrTypeNo = request.getParameter("no");
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		ExtAttrType extAttrType = extAttrService.getExtAttrType(attrTypeNo);
		
		request.setAttribute("extAttrType", extAttrType);
	
	}
	
	private void modify_attr_type(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {
		
		ExtAttrForm extAttrForm = (ExtAttrForm) form;
		
		ExtAttrType extAttrType = new ExtAttrType();
		PropertyUtils.copyProperties(extAttrType, extAttrForm);
		
		ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
		extAttrService.updateExtAttrType(extAttrType);
	
	}

}
