package kr.co.leaderway.mywork.menu.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.menu.MenuService;
import kr.co.leaderway.mywork.menu.form.MenuForm;
import kr.co.leaderway.mywork.menu.model.Menu;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class MenuAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_menu")) {
			
			add_menu(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "list_menu");
			return redirect;

		} else if (mode.equals("add_menu_form")) {
			
			request.setAttribute("contentTitle", "메뉴 관리 - 추가");
			return mapping.findForward("menu_add_form");
			
		} else if (mode.equals("view_menu")) {
			
			view_menu(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 관리 - 메뉴 정보보기");
			
			return mapping.findForward("menu_view");
			
		} else if (mode.equals("modify_menu_form")) {
			 
			view_menu(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "메뉴 관리 - 수정");	
			return mapping.findForward("menu_modify_form");
			
		} else if (mode.equals("modify_menu")) {
			
			modify_menu(mapping, form, request, response);
				
			MenuForm menuForm = (MenuForm) form;
			int no = menuForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "view_menu");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("lower_menu")) {
			
			lower_menu(mapping, form, request, response);
			
			String groupId_string = request.getParameter("groupId") != null ? (String) request.getParameter("groupId") : "";
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "list_menu");
			redirect.addParameter("groupId", groupId_string );
			return redirect;
			
		} else if (mode.equals("delete_menu")) {
			
			delete_menu(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "list_menu");
			return redirect;
			
		} else if (mode.equals("assign_menu_form")) {
			
			view_menu(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 관리 - 접근 권한 그룹 할당");		
			
			return mapping.findForward("menu_assign_form");
			
		} else if (mode.equals("add_access_group")) {
			
			add_access_group(mapping, form, request, response);
				
			MenuForm menuForm = (MenuForm) form;
			int no = menuForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "assign_menu_form");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_access_group")) {
				
			delete_access_group(mapping, form, request, response);
				
			MenuForm menuForm = (MenuForm) form;
			int no = menuForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuAction") );
			redirect.addParameter("mode", "assign_menu_form");
			redirect.addParameter("no", no);
			return redirect;
				
	    } else { // list_menu
	    	
	    	list_menu(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "메뉴 관리 - 리스트");

	    	return mapping.findForward("menu_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String groupId_string = request.getParameter("groupId") != null ? (String) request.getParameter("groupId") : "";
		
		if (groupId_string.equals("") ) {
			groupId_string = "0";
		}
		
		int groupId = Integer.parseInt(groupId_string);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		List menuList = menuService.getMenuListByGroupId(groupId);
		
		HttpSession session = request.getSession();
		String sessionUserId = (String) session.getAttribute("userId");
		
		request.setAttribute("sessionUserId", sessionUserId);
		request.setAttribute("menuList", menuList);

	}

	private void add_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MenuForm menuForm = (MenuForm) form;
		
		Menu menu = new Menu();
		PropertyUtils.copyProperties(menu, menuForm);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.addMenu(menu);
		
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MenuForm menuForm = (MenuForm) form;
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.deleteMenu(menuForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void view_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuNo_string = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		int menuNo = Integer.parseInt(menuNo_string);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		Menu menu = menuService.getMenuByNo(menuNo);
		
		request.setAttribute("menu", menu);		
		
		List accessGroupList  = menuService.getAccessGroupList(menuNo);
		
		request.setAttribute("accessGroupList", accessGroupList);		

	}

	private void modify_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MenuForm menuForm = (MenuForm) form;
		
		Menu menu = new Menu();
		PropertyUtils.copyProperties(menu, menuForm);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.updateMenu(menu);

	}
	
	private void lower_menu(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuNo_string = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		int menuNo = Integer.parseInt(menuNo_string);
			
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.lowerMenu(menuNo);
	
	}
	
	private void add_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
	
		String selected_groupno = request.getParameter("selected_groupno");
		
		MenuForm menuForm = (MenuForm) form;
		
		Menu menu = new Menu();
		PropertyUtils.copyProperties(menu, menuForm);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.addAccessGroup(menu, selected_groupno);
		
	}
	
	private void delete_access_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String selected_groupno = request.getParameter("selected_groupno");
		
		MenuForm menuForm = (MenuForm) form;
		
		Menu menu = new Menu();
		PropertyUtils.copyProperties(menu, menuForm);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.deleteAccessGroup(menu, selected_groupno);
	}
}
