package kr.co.leaderway.mywork.menu.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.menu.MenuService;
import kr.co.leaderway.mywork.menu.form.MenuGroupForm;
import kr.co.leaderway.mywork.menu.model.MenuGroup;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class MenuGroupAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_menu_group")) {
			
			add_menu_group(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuGroupAction") );
			redirect.addParameter("mode", "list_menu_group");
			return redirect;

		} else if (mode.equals("add_menu_group_form")) {
			
			request.setAttribute("contentTitle", "메뉴 그룹 관리 - 추가");
			return mapping.findForward("menu_group_add_form");
			
		} else if (mode.equals("view_menu_group")) {
			
			view_menu_group(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 그룹 관리 - 상세 보기");
			
			return mapping.findForward("menu_group_view");
			
		} else if (mode.equals("modify_menu_group_form")) {
			
			view_menu_group(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 그룹 관리 - 수정");
				
			return mapping.findForward("menu_group_modify_form");
			
		} else if (mode.equals("modify_menu_group")) {
			
			modify_menu_group(mapping, form, request, response);
				
			MenuGroupForm menuGroupForm = (MenuGroupForm) form;
			int no = menuGroupForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuGroupAction") );
			redirect.addParameter("mode", "view_menu_group");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("assign_holder_form")) {
			
			view_menu_group(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 그룹 관리 - 상위 메뉴 할당");
			
			return mapping.findForward("holder_assign_form");
				
		} else if (mode.equals("assign_holder")) {
				
			assign_holder(mapping, form, request, response);
					
			String menuGroupId = request.getParameter("no");
			int menuGroupNo = Integer.parseInt(menuGroupId);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuGroupAction") );
			redirect.addParameter("mode", "assign_holder_form");
			redirect.addParameter("no", menuGroupNo);
			return redirect;
				
		} else if (mode.equals("delete_menu_group")) {
			
			delete_menu_group(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuGroupAction") );
			redirect.addParameter("mode", "list_menu_group");
			return redirect;
			
		} else if (mode.equals("delete_assigned")) {
			
			delete_assigned(mapping, form, request, response);
				
			String menuGroupId = request.getParameter("no");
			int menuGroupNo = Integer.parseInt(menuGroupId);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("MenuGroupAction") );
			redirect.addParameter("mode", "assign_holder_form");
			redirect.addParameter("no", menuGroupNo);
			return redirect;
			
	    } else { // list_menu_group
	    	
	    	list_menu_group(mapping, form, request, response);
			request.setAttribute("contentTitle", "메뉴 관리 - 메뉴 그룹 리스트");
			
	    	return mapping.findForward("menu_group_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_menu_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		List menuGroupList = menuService.getMenuGroupList();
		
		request.setAttribute("menuGroupList", menuGroupList);
		
	}

	private void add_menu_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MenuGroupForm menuGroupForm = (MenuGroupForm) form;
		
		MenuGroup menuGroup = new MenuGroup();
		PropertyUtils.copyProperties(menuGroup, menuGroupForm);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.addMenuGroup(menuGroup);
		
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_menu_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuGroupNo_string = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		int menuGroupNo = Integer.parseInt(menuGroupNo_string);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.deleteMenuGroup(menuGroupNo);
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void view_menu_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuGroupNo_string = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		int menuGroupNo = Integer.parseInt(menuGroupNo_string);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		MenuGroup menuGroup = menuService.getMenuGroupByNo(menuGroupNo);
		
		request.setAttribute("menuGroup", menuGroup);		
		
		List assignedMenuList = menuService.getAssignedMenuList(menuGroupNo);
		
		request.setAttribute("assignedMenuList", assignedMenuList);		

	}

	private void modify_menu_group(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		MenuGroupForm menuGroupForm = (MenuGroupForm) form;
		
		MenuGroup menuGroup = new MenuGroup();
		PropertyUtils.copyProperties(menuGroup, menuGroupForm);
			
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.updateMenuGroup(menuGroup);

	}
	
	private void assign_holder(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuGroupId = request.getParameter("no");
		int menuGroupNo = Integer.parseInt(menuGroupId);
		
		String assignNo_string = request.getParameter("assign_no");
		int assignNo = Integer.parseInt(assignNo_string);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.assignHolder(menuGroupNo, assignNo);
	
	}
	
	private void delete_assigned(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String menuGroupId = request.getParameter("no");
		int menuGroupNo = Integer.parseInt(menuGroupId);
		
		String assigned_no_string = request.getParameter("assigned_no");
		int assignedNo = Integer.parseInt(assigned_no_string);
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, getServiceType("MenuService"));
		menuService.deleteHolder(menuGroupNo, assignedNo);
	
	}
	
}
