package kr.co.leaderway.mywork.system.advice;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.MyWorkAction.model.MyWorkAction;
import kr.co.leaderway.mywork.MyWorkException.LengthDoNotMatchException;
import kr.co.leaderway.mywork.MyWorkException.MyWorkNetworkNotAuthorizedException;
import kr.co.leaderway.mywork.MyWorkException.MyWorkNotAuthorizedException;
import kr.co.leaderway.mywork.MyWorkexception.action.MyWorkExceptionHandler;
import kr.co.leaderway.mywork.menu.MenuService;
import kr.co.leaderway.mywork.menu.model.Menu;
import kr.co.leaderway.mywork.menu.model.MenuGroup;
import kr.co.leaderway.mywork.menu.model.MenuSearchParameter;
import kr.co.leaderway.mywork.right.RightService;
import kr.co.leaderway.mywork.statics.ServiceType;
import kr.co.leaderway.mywork.user.model.UserInfo;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.util.BitTool;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.ModelAndView;

public class BaseAdvice implements MethodInterceptor {

	private Log log = LogFactory.getLog(this.getClass());
	
	private String nowActionName = "";
	private String nowSuffixName = "";
	private String nowMethodName = "";
	protected String remoteUserIpAddress = "";
	protected String remoteUserIpAddressBin = "";
	protected String nowUserNo = "";
	protected String userLocale = "";
	
	public BaseAdvice() {
		
	}

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		log.debug("method.getName():" + invocation.getMethod().getName());
		log.debug("args.length:" + invocation.getArguments().length);
		
		Method method = invocation.getMethod();
		Object[] args = invocation.getArguments();

		for (int i = 0; i < args.length ; i++) {
			System.out.println("args[i].toString():" + args[i].toString());
			
			Object argument = args[i];
			
		    if (argument == null) {
		        throw new IllegalArgumentException("Value for argument [" + i + "] is required but not present " + "for method [" + method + "]!");
		    }
		}
		
		RequestFacade requestFacade = (RequestFacade) args[0];
		ResponseFacade responseFacade = (ResponseFacade) args[1];
		log.debug("requestFacade.getServletPath():" + requestFacade.getServletPath());
		log.debug("responseFacade.getContentType():" + responseFacade.getContentType());
		
		String action_now = requestFacade.getServletPath(); 
		String modified_action_string1 = action_now.replace("/", "");
		//nowActionName = modified_action_string1.replace(".do", "");
		//nowActionName = modified_action_string1.replace(".spring", "");
		String[] modified_action_strings = modified_action_string1.split("\\.");
		log.debug("modified_action_string1:" + modified_action_string1);
		log.debug("modified_action_strings[0]:" + modified_action_strings[0]);
		log.debug("modified_action_strings[1]:" + modified_action_strings[1]);
		
		nowActionName = modified_action_strings[0];
		nowSuffixName = modified_action_strings[1];
		
		log.debug("nowActionName:" + nowActionName);
		
		nowMethodName = requestFacade.getParameter("mode");
		
		remoteUserIpAddress = requestFacade.getRemoteAddr();
		
		if (remoteUserIpAddress.equals("0:0:0:0:0:0:0:1")) {  //ipv6 loopback address
			remoteUserIpAddress = "127.0.0.1";
		}
		
		StringTokenizer st1 = new StringTokenizer(remoteUserIpAddress,".");
		
		remoteUserIpAddressBin = "";
        while(st1.hasMoreTokens()) {
        	remoteUserIpAddressBin += StringUtils.leftPad("" + Integer.toBinaryString(Integer.parseInt(st1.nextToken())), 8, "0");
        }
        
		HttpSession session = requestFacade.getSession();	
	
		UserInfo userInfo = (UserInfo) session.getAttribute("userInfo");
		
		String sessionUserId = "";
		String sessionUserNo = "";
		
		if (userInfo == null) {
			sessionUserId = "notlogin";
			sessionUserNo = "USERNOTLOGINNOTLOGIN01"; // notlogin user userNo
		} else {
			sessionUserId = userInfo.getUser().getUserId();
			sessionUserNo = userInfo.getUser().getNo();
		}
		nowUserNo = sessionUserNo;
		log.debug("sessionUserNo:" + sessionUserNo);
		
		String selectedMenuNo_string = requestFacade.getParameter("selected_menu_no") != null ? (String) requestFacade.getParameter("selected_menu_no") : "0";
		int selectedMenuNo = Integer.parseInt(selectedMenuNo_string);
		
		if (userInfo == null && selectedMenuNo == 0) {
			
		} else if (userInfo != null && selectedMenuNo == 0) {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		} else if (userInfo == null && selectedMenuNo != 0) {
			// do nothing
		} else if (selectedMenuNo != 0){
			userInfo.getCurrentMenu().setNo(selectedMenuNo);
		} else {
			selectedMenuNo = userInfo.getCurrentMenu().getNo();
		}
		
		MenuService menuService = (MenuService)ServiceCallUtil.call(MenuService.class, ServiceType.ServiceDefault);
		List selectedMenuList = menuService.getSelectedMenuList(selectedMenuNo);
		
		int selected_top_menu_no = 0;
		
		if (selectedMenuList.size() > 0) {
		
			Iterator iterator = selectedMenuList.iterator();
			while ( iterator.hasNext() ) {
				Menu menu = (Menu)iterator.next();
			}
			
			if (userInfo != null) {
				userInfo.setSelectedMenuList(selectedMenuList);
			}
		
			requestFacade.setAttribute("selectedMenuList", selectedMenuList);	

			Menu selected_top_menu = (Menu) selectedMenuList.get(selectedMenuList.size() - 1);
			selected_top_menu_no = selected_top_menu.getNo();
		}
		
		MenuSearchParameter menuSearchParameter = new MenuSearchParameter();
		menuSearchParameter.setGroupId(1);
		menuSearchParameter.setUserNo(sessionUserNo);
		
		List topMenuList = menuService.getAccessibleMenuList(menuSearchParameter);
		requestFacade.setAttribute("topMenuList", topMenuList);
		
		List childMenuGroupList = menuService.getChildMenuGroupList(selected_top_menu_no);
		Iterator menuGroupIter = childMenuGroupList.iterator();
		
		int childMenuGroupNo = 0;
		
		while ( menuGroupIter.hasNext() ) {
			MenuGroup menuGroup = (MenuGroup)menuGroupIter.next();
			childMenuGroupNo = menuGroup.getNo();
			break;  // only get first child (temporary code)
		}
		
		if (childMenuGroupNo != 0) {
			menuSearchParameter.setGroupId(childMenuGroupNo);
			List leftMenuList = menuService.getAccessibleMenuList(menuSearchParameter);
			
			requestFacade.setAttribute("leftMenuList", leftMenuList);	
		}
		
		log.debug("nowActionName:" + nowActionName);
		log.debug("nowMethodName:" + nowMethodName);
		String authCheckResult = checkAccessRight(nowActionName, nowMethodName, sessionUserNo);
		log.debug("authCheckResult:" + authCheckResult);
		
		if (authCheckResult.equals("not authorized")) {
			MyWorkExceptionHandler MyWorkexceptionHandler = new MyWorkExceptionHandler();
			return MyWorkexceptionHandler.handle(new MyWorkNotAuthorizedException(), requestFacade, responseFacade);
			
			//return actionForward;
		} else if (authCheckResult.equals("not authorized network access")) {
			MyWorkExceptionHandler MyWorkexceptionHandler = new MyWorkExceptionHandler();
			return MyWorkexceptionHandler.handle(new MyWorkNetworkNotAuthorizedException(), requestFacade, responseFacade);
			
			//return actionForward;
		}
		
		ModelAndView target = (ModelAndView)invocation.proceed();   // 대상 메소드 호출
		
		if (nowSuffixName.equals("html")) {
			target.setViewName(nowActionName + "." + nowMethodName);
		} else if (nowSuffixName.equals("xml")) {
			
			target.setViewName("xmlView");
			
			if (target.getModelMap().containsAttribute("contentTitle")) {
				target.getModelMap().remove("contentTitle");
			}
			
		} else if (nowSuffixName.equals("json")) {
			target.setViewName("jsonView");
		} else {
			
		}
	
		return target;
	}
	
	@SuppressWarnings("unchecked")
	private String checkAccessRight(String actionName, String methodName, String userNo) throws Exception {

		MyWorkAction myWorkAction = new MyWorkAction();
		myWorkAction.setMethodGroupName(actionName);
		myWorkAction.setMethodName(methodName);
		myWorkAction.setUserNo(userNo);
		
		RightService rightService = (RightService)ServiceCallUtil.call(RightService.class, ServiceType.ServiceDefault);
		
		List actionList = rightService.getAccessRightOnMethodByUserNo(myWorkAction);
		
		int authorizedCount = 0;
		int notAuthorizedByNetworkCount = 0;
		Iterator actionItor = actionList.iterator();
		while (actionItor.hasNext()) {
			MyWorkAction myWorkActionGet = (MyWorkAction)actionItor.next();
			
			if (myWorkActionGet.getAccessGroupType() == 2 && myWorkActionGet.getAssignedIp() != null) {
				
				try {
					String authorizedNetwork = BitTool.bitAnd(myWorkActionGet.getAssignedIp(), myWorkActionGet.getAssignedNetmask());
					
					String remoteIpAddressBinMasked = BitTool.bitAnd(remoteUserIpAddressBin, myWorkActionGet.getAssignedNetmask());
					
					if (authorizedNetwork.equals(remoteIpAddressBinMasked)) {
						authorizedCount++;
					} else {
						notAuthorizedByNetworkCount++;
					}
				} catch (LengthDoNotMatchException e) {
					e.printStackTrace();
				}
			} else {
				authorizedCount++;
			}
		}
		int resultNum = actionList.size();
		
		String result = null;
		
		if (authorizedCount > 0) {
			log.debug("======================================");
			log.debug("authorized");
			log.debug("======================================");
			result = "authorized";
		} else if (resultNum > 0) {
			log.debug("======================================");
			log.debug("not authorized network access");
			log.debug("======================================");
			result = "not authorized network access";
		} else {
			log.debug("======================================");
			log.debug("not authorized");
			log.debug("======================================");
			result = "not authorized";
		}
		
		return result;
	}
	
}
