package kr.co.leaderway.mywork.util;

import java.sql.SQLException;
import java.util.List;

import kr.co.leaderway.mywork.option.OptionService;
import kr.co.leaderway.mywork.option.model.Option;
import kr.co.leaderway.mywork.statics.ServiceType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColorTool {
	
	private static Log log = LogFactory.getLog(ColorTool.class);
	
	private static List colorList = null;
	
	public static String getColor(String objectNo) throws Exception {
		
		if (colorList == null) {
			log.info("colorList is null");
			
			OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, ServiceType.ServiceDefault);
			colorList = optionService.findOptionList("colors");
		
		}
		
		String seqNo = objectNo.substring(18, 22);
		int colorSeed = Integer.parseInt(seqNo);
		int colorNum = colorList.size();
		int colorIndex = colorSeed % colorNum;
		
		Option colorOption = (Option)colorList.get(colorIndex);
		return colorOption.getValue();
		
	}
	
	public static void clearColorList() {
		colorList = null;
	}
	
}
