package kr.co.leaderway.CustomTag.Paging;

import java.io.IOException;

import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

import kr.co.leaderway.util.UrlTool;

public class PagingTag extends BodyTagSupport {
	private int page;
	private int totalRows;
	private int totalPages;
	private int pageLimit;
	private int rowsLimit;
	private String urlString = "";
	private String pageArgument = "";
	
	public int doStartTag()	{
		return EVAL_BODY_INCLUDE;
	}
	
	public int doEndTag() {
		
		StringBuffer uri = new StringBuffer();
		
		if (page == 1) { // 맨 처음 페이지
			uri.append("<b>[Top]</b> ");
		} else {
			uri.append("<a href=\"" + getPageUrlString(1) + "\">[Top]</a> ");
		} // 맨 처음 페이지 끝
		    
		int topnear = page - pageLimit;
		int lastnear = page + pageLimit;
		int numpage = pageLimit;
		int totalPages = getTotalPages();
		int pres = 0; 
		int nexs = 0;
		  
		if (topnear <= 1) {
		    pres = 1;
		    if (totalPages <= (numpage * 2 + 1)) {
		      nexs = totalPages;
		    } else {
		      nexs = numpage * 2 + 1;
		    }
		} else if ((page == totalPages) && (totalPages <= (numpage * 2))) {
		    pres = 1;
		    nexs = totalPages;
		} else if (lastnear >= totalPages) {
		    pres = totalPages - (numpage * 2);
		    nexs = totalPages;
		} else {
		    pres = topnear;
		    nexs = lastnear;
		}
		  
		  // 이동할 페이지의 가장 처음이 1 페이지보다 클 경우 생략 기호 출력
		if (pres > 1) {
			uri.append("<b> ... </b>");
		}  
		  
		for(int i = pres; i <= nexs; i++) { // 중간
		    if (i == page) {
		    	uri.append("<b>[" + i + "]</b> ");
		    } else {
		    	uri.append("<a href=\"" + getPageUrlString(i) + "\">[" + i + "]</a> ");
		    }
		} // 중간

		  // 이동할 페이지의 가장 끝이 마지막 페이지보다 작을 경우 생략 기호 출력
		if (nexs < totalPages) {
			uri.append("<b> ... </b>");
		}  
				
		if (page == totalPages) { // 맨 끝 페이지
			uri.append("<b>[Last]</b> ");
		} else {
			uri.append(" <a href=\"" + getPageUrlString(totalPages) + "\">[Last]</a> ");
		} // 맨 끝 페이지 완료
		
		JspWriter out = pageContext.getOut();
	    try {
		 	out.print(uri.toString());
	   	} catch (IOException e) {
		   	System.out.println( e.toString() );
	   	}
	   	
	   	return EVAL_PAGE;
		
	//	return SKIP_BODY;
	}

	/**
	 * 표현할 페이지의 수 
	 * EX) 10  --> [1]....[10]
	 * EX) 20  --> [1]....[20]
	 * @param pageLimit
	 */
	public void setPageLimit(int pageLimit) {
		this.pageLimit = pageLimit;
	}

	/**
	 * 현재페이지
	 * @param page
	 */
	public void setPage(int page) {
		this.page = page;
	}

	/**
	 * 전체레코드 수
	 * @param totalRows
	 */
	public void setTotalRows(int totalRows) {
		this.totalRows = totalRows;
	}

	/**
	 * 페이지에 나타낼 글의 수
	 * @param rowsLimit
	 */
	public void setRowsLimit(int rowsLimit) {
		this.rowsLimit = rowsLimit;
	}
	
	public void setUrlString(String urlString) {
		this.urlString = urlString;
	}

	public void setPageArgument(String pageArgument) {
		this.pageArgument = pageArgument;
	}
	
	public String getPageUrlString(int page) {
		String newUrlString = UrlTool.changeUrlArgument(urlString, pageArgument, Integer.toString(page)); 
		return newUrlString;
	}
	
	public int getTotalPages() {
		if ((totalRows % rowsLimit) != 0) {
			return (totalRows / rowsLimit) + 1;
		} else {
			return totalRows / rowsLimit;
		}
	}
	

}
