package kr.co.leaderway.CustomTag.Paging;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class UrlStringTag extends BodyTagSupport {
	public int doAfterBody() throws JspTagException {
		
		PagingTag parent = (PagingTag) findAncestorWithClass( this, PagingTag.class );
		
		if ( parent == null )	{
			throw new JspTagException( "부모 태그(PagingTag.class)가 없습니다." );
		}
		
		String urlString = getBodyContent().getString().trim();
		
		parent.setUrlString( urlString );
		
		return SKIP_BODY;
	}

}
