package kr.co.leaderway.mywork.category.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.category.form.CategoryInfoForm;
import kr.co.leaderway.mywork.category.model.CategoryInfo;
import kr.co.leaderway.mywork.category.model.CategoryScheme;
import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class CategoryInfoAction extends BaseAction {

	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";

		if (mode.equals("add_category_info")) {

			add_category(mapping, form, request, response);

			String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("categorySchemeNo", categorySchemeNo);
			return redirect;
			
		} else if (mode.equals("add_sub_category_info_form")) {
			
			view_category_scheme(mapping, form, request, response);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 정보추가");
			return mapping.findForward("category_info_modify_form");
			
		} else if (mode.equals("add_sub_category_info")) {

			add_sub_category(mapping, form, request, response);

			String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("categorySchemeNo", categorySchemeNo);
			return redirect;
			
		} else if (mode.equals("modify_category_form")) {
			
			view_category_scheme(mapping, form, request, response);
			
			return mapping.findForward("category_modify_form");
			
		} else if (mode.equals("modify_category_info_form")) {
			
			view_category_scheme(mapping, form, request, response);
			request.setAttribute("contentTitle", "카테고리 관리 - Scheme 정보수정");
			return mapping.findForward("category_info_modify_form");
			
			
		} else if (mode.equals("modify_category_info")) {

			modify_category(mapping, form, request, response);

			CategoryInfoForm categoryInfoForm = (CategoryInfoForm) form;
			String categorySchemeNo = categoryInfoForm.getCategorySchemeNo();
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("categorySchemeNo", categorySchemeNo);
			return redirect;
			
		} else if (mode.equals("delete_category_info")) {
			
			delete_category(mapping, form, request, response);
			
			String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("categorySchemeNo", categorySchemeNo);
			return redirect;
			
		} else if (mode.equals("lower_category_info")) {
			
			lower_category(mapping, form, request, response);
			
			String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
			
			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "modify_category_form");
			redirect.addParameter("categorySchemeNo", categorySchemeNo);
			return redirect;
			
		} else { 

			ActionRedirect redirect = new ActionRedirect(mapping.findForward("CategorySchemeAction"));
			redirect.addParameter("mode", "list_category_scheme");
			return redirect;
		}
	}

	private void add_category(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		CategoryInfoForm categoryInfoForm = (CategoryInfoForm) form;
		
		CategoryInfo categoryInfo = new CategoryInfo();
		PropertyUtils.copyProperties(categoryInfo, categoryInfoForm);
	
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.addCategoryInfo(categoryInfo);

		request.setAttribute("alertMessage", "등록되었습니다.");

	}
	
	private void modify_category(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		CategoryInfoForm categoryInfoForm = (CategoryInfoForm) form;
		
		CategoryInfo categoryInfo = new CategoryInfo();
		PropertyUtils.copyProperties(categoryInfo, categoryInfoForm);
	
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.modifyCategoryInfo(categoryInfo);

		request.setAttribute("alertMessage", "수정되었습니다.");

	}
	
	private void add_sub_category(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String parentCategoryInfoNo_string = request.getParameter("parentCategoryInfoNo") != null ? request.getParameter("parentCategoryInfoNo") : "";
		int parentCategoryInfoNo = Integer.parseInt(parentCategoryInfoNo_string);
		String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
		
		CategoryInfoForm categoryInfoForm = (CategoryInfoForm) form;
		
		CategoryInfo categoryInfo = new CategoryInfo();
		PropertyUtils.copyProperties(categoryInfo, categoryInfoForm);
		categoryInfo.setCategorySchemeNo(categorySchemeNo);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.addSubCategoryInfo(categoryInfo, parentCategoryInfoNo);

		request.setAttribute("alertMessage", "등록되었습니다.");

	}
	
	private void delete_category(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String categoryInfoNo_string = request.getParameter("categoryInfoNo") != null ? request.getParameter("categoryInfoNo") : "";
		String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
		int categoryInfoNo = Integer.parseInt(categoryInfoNo_string);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.deleteCategoryInfo(categoryInfoNo, categorySchemeNo);
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
	
	}
	
	private void view_category_scheme(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		String categorySchemeNo = request.getParameter("categorySchemeNo");

		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		CategoryScheme categoryScheme = categoryService.findCategoryScheme(categorySchemeNo);
		
		request.setAttribute("categoryScheme", categoryScheme);
		
		MyWorkList categoryInfoList = categoryService.findCategoryInfoList(categorySchemeNo);
		
		request.setAttribute("categoryInfoList", categoryInfoList);

	}
	
	private void lower_category(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String categorySchemeNo = request.getParameter("categorySchemeNo") != null ? request.getParameter("categorySchemeNo") : "";
		
		String categoryInfoNo_string = request.getParameter("categoryInfoNo") != null ? request.getParameter("categoryInfoNo") : "";
		int categoryInfoNo = Integer.parseInt(categoryInfoNo_string);
		
		CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
		categoryService.lowerCategoryInfo(categorySchemeNo, categoryInfoNo);
		
		request.setAttribute("alertMessage", "변경되었습니다.");
	
	}
}