package kr.co.leaderway.mywork.network.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.network.NetworkService;
import kr.co.leaderway.mywork.network.form.NetworkForm;
import kr.co.leaderway.mywork.network.model.Network;
import kr.co.leaderway.mywork.network.model.NetworkInfo;
import kr.co.leaderway.mywork.network.model.NetworkSearchParameter;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class NetworkAction extends BaseAction{
	/**
	 * 
	 * 
	 * 
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_network")) {
			
			add_network(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("NetworkAction") );
			redirect.addParameter("mode", "list_network");
			return redirect;

		} else if (mode.equals("add_network_form")) {
			
			request.setAttribute("contentTitle", "네트워크 관리 - 추가");
			return mapping.findForward("network_add_form");
			
		} else if (mode.equals("view_network")) {
			
			view_network(mapping, form, request, response);
			request.setAttribute("contentTitle", "네트워크 관리 - 네트워크 정보보기");
			
			return mapping.findForward("network_view");
			
		} else if (mode.equals("modify_network_form")) {
			 
			view_network(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "네트워크 관리 - 수정");	
			return mapping.findForward("network_modify_form");
			
		} else if (mode.equals("modify_network")) {
			
			modify_network(mapping, form, request, response);
				
			NetworkForm networkForm = (NetworkForm) form;
			String no = networkForm.getNo();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("NetworkAction") );
			redirect.addParameter("mode", "view_network");
			redirect.addParameter("no", no);
			return redirect;
			
		} else if (mode.equals("delete_network")) {
			
			delete_network(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("NetworkAction") );
			redirect.addParameter("mode", "list_network");
			return redirect;
		
		} else if (mode.equals("assign_ip_addresss_form")) {
			 
			view_network(mapping, form, request, response);
			
			request.setAttribute("contentTitle", "네트워크 관리 - ip 할당");	
			return mapping.findForward("network_ip_address_assign_form");
			
		} else if (mode.equals("add_ip_addresss")) {
			
			add_ip_addresss(mapping, form, request, response);
			
			String networkNo = request.getParameter("selected_network_no") == null ? "" : request.getParameter("selected_network_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("NetworkAction") );
			redirect.addParameter("mode", "assign_ip_addresss_form");
			redirect.addParameter("no", networkNo);
			return redirect;
				
		} else if (mode.equals("delete_ip_addresss")) {
			
			delete_ip_addresss(mapping, form, request, response);
			
			String networkNo = request.getParameter("selected_network_no") == null ? "" : request.getParameter("selected_network_no"); 
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("NetworkAction") );
			redirect.addParameter("mode", "assign_ip_addresss_form");
			redirect.addParameter("no", networkNo);
			return redirect;
		
		} else if (mode.equals("list_network_for_select")) {
		    	
	    	list_network(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "네크워크 관리 - 리스트");

	    	return mapping.findForward("network_list_for_select");
		    	
	    } else { // list_network
	    	
	    	list_network(mapping, form, request, response);
	    	
	    	request.setAttribute("contentTitle", "네크워크 관리 - 리스트");

	    	return mapping.findForward("network_list");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_network(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		NetworkSearchParameter networkSearchParameter = new NetworkSearchParameter();
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		MyWorkList networkList = networkService.getNetworkList(networkSearchParameter);
		
		request.setAttribute("networkList", networkList);

	}

	private void add_network(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		NetworkForm networkForm = (NetworkForm) form;
		
		Network network = new Network();
		PropertyUtils.copyProperties(network, networkForm);
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.addNetwork(network);
		
		request.setAttribute("alertMessage", "등록되었습니다.");

	}

	private void delete_network(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		NetworkForm networkForm = (NetworkForm) form;
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.deleteNetwork(networkForm.getNo());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");

	}

	@SuppressWarnings("unchecked")
	private void view_network(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String networkNo = request.getParameter("no") != null ? (String) request.getParameter("no") : "";
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		Network network = networkService.getNetworkByNo(networkNo);
		
		request.setAttribute("network", network);		
		
		List networkInfoList = networkService.getNetworkInfoListByNetworkNo(networkNo);
		
		request.setAttribute("networkInfoList", networkInfoList);		

	}

	private void modify_network(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		NetworkForm networkForm = (NetworkForm) form;
		
		Network network = new Network();
		PropertyUtils.copyProperties(network, networkForm);
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.updateNetwork(network);

	}
	
	private void add_ip_addresss(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String networkNo = request.getParameter("selected_network_no") == null ? "" : request.getParameter("selected_network_no"); 
		NetworkInfo networkInfo = new NetworkInfo();
		networkInfo.setNetworkNo(networkNo);
		
		String address1 = request.getParameter("ipAddress1") == null ? "" : request.getParameter("ipAddress1").trim(); 
		String address2 = request.getParameter("ipAddress2") == null ? "" : request.getParameter("ipAddress2").trim();
		String address3 = request.getParameter("ipAddress3") == null ? "" : request.getParameter("ipAddress3").trim();
		String address4 = request.getParameter("ipAddress4") == null ? "" : request.getParameter("ipAddress4").trim();
		
		String netmask = request.getParameter("netmask") == null ? "" : request.getParameter("netmask").trim();
		
		try {
			if (Integer.parseInt(address1) >= 0 && Integer.parseInt(address2) >= 0 && Integer.parseInt(address3) >= 0 && Integer.parseInt(address4) >= 0) {
				networkInfo.setAssignedIpReadable(address1 + "." + address2 + "." + address3 + "." + address4);
			} else {
				throw new Exception("input network is invalid");
			}
			
			if (Integer.parseInt(netmask) > 0) {
				networkInfo.setAssignedNetmaskReadable(netmask);
			} else {
				throw new Exception("input netmask is invalid");
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new Exception("error parsing network address");
		}
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.addNetworkIpAddress(networkInfo);
	
	}
	
	private void delete_ip_addresss(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String networkInfoNo = request.getParameter("selected_network_info_no") == null ? "" : request.getParameter("selected_network_info_no"); 
		
		NetworkService networkService = (NetworkService)ServiceCallUtil.call(NetworkService.class, getServiceType("NetworkService"));
		networkService.deleteNetworkIpAddress(networkInfoNo);
	
	}
	
}
