package kr.co.leaderway.mywork.option.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import kr.co.leaderway.mywork.businessProcess.BusinessProcessService;
import kr.co.leaderway.mywork.category.CategoryService;
import kr.co.leaderway.mywork.extAttr.ExtAttrService;
import kr.co.leaderway.mywork.multiLanguage.MultiLanguageService;
import kr.co.leaderway.mywork.option.OptionService;
import kr.co.leaderway.mywork.option.model.Option;
import kr.co.leaderway.mywork.statics.BugStatus;
import kr.co.leaderway.mywork.statics.RoleType;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.mywork.util.TypeTool;
import kr.co.leaderway.util.XMLtool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.w3c.dom.Document;

public class OptionActionAjax extends BaseAction{
	
	private Log log = LogFactory.getLog(this.getClass());

	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping, 
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response)
	        										throws Exception {
		
		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if (mode.equals("list")) {
			
			String list_name = request.getParameter("list_name") != null ? request.getParameter("list_name") : "";
			String select_id = request.getParameter("select_id") != null ? request.getParameter("select_id") : "";
			String add_total = request.getParameter("add_total") != null ? request.getParameter("add_total") : "";
			String selected_value = request.getParameter("selected_value") != null ? request.getParameter("selected_value") : "";
			String except_list = request.getParameter("except_list") != null ? request.getParameter("except_list") : "";
			String except_type = request.getParameter("except_type") != null ? request.getParameter("except_type") : "";
			String search_param = request.getParameter("search_param") != null ? request.getParameter("search_param") : "";
			  
			List optionList = null;
			
			String xmlString = "";
			
			if  (list_name.equals("menu_group") 
					|| list_name.equals("user_group") 
					|| list_name.equals("access_group")
					|| list_name.equals("menu")
					|| list_name.equals("action_group")) {
			
				OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
				optionList = optionService.findGroupOptionList(list_name); 
			
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("category_scheme")) {
			    
				CategoryService categoryService = (CategoryService)ServiceCallUtil.call(CategoryService.class, getServiceType("CategoryService"));
				optionList = categoryService.listCategoryScheme(); 
			
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("bug_status")) {
			    
				MessageResources messageResources = getResources(request);

				TypeTool typeTool = new TypeTool(messageResources);
				List bugStatusList = typeTool.getMessageNameListForOption(BugStatus.class);
				
				Document optionDoc = XMLtool.makeDocument(select_id, bugStatusList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("role_right_from_statics")) {
			    
				MessageResources messageResources = getResources(request);

				TypeTool typeTool = new TypeTool(messageResources);
				List bugStatusList = typeTool.getMessageNameListForOption(RoleType.class);
				
				Document optionDoc = XMLtool.makeDocument(select_id, bugStatusList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("business_process_step")) {
			   
				BusinessProcessService businessProcessService = (BusinessProcessService)ServiceCallUtil.call(BusinessProcessService.class, getServiceType("BusinessProcessService"));
				optionList = businessProcessService.getBusinessProcessStepListForOption(search_param); 
				
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("business_process_step_lane")) {
				   
				optionList = new ArrayList(); 
				
				Option optionStart = new Option();
				optionStart.setName("시작");
				optionStart.setValue("S");
				optionList.add(optionStart);
				
				Option optionProsessing = new Option();
				optionProsessing.setName("진행중");
				optionProsessing.setValue("P");
				optionList.add(optionProsessing);
				
				Option optionEnd = new Option();
				optionEnd.setName("종료");
				optionEnd.setValue("E");
				optionList.add(optionEnd);
				
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("attr_data_type")) {
			    
				ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
				optionList = extAttrService.getExtAttrTypeListForOption(); 
				
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("attr_type")) {
			    
				ExtAttrService extAttrService = (ExtAttrService)ServiceCallUtil.call(ExtAttrService.class, getServiceType("ExtAttrService"));
				optionList = extAttrService.getExtAttrListForOption(); 
				
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("multiLanguage_code")) {
			    
				MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
				optionList = multiLanguageService.getMultiLanguageCodeListForOption(); 
				
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else if (list_name.equals("multiLanguage_lang")) {
    
				MultiLanguageService multiLanguageService = (MultiLanguageService)ServiceCallUtil.call(MultiLanguageService.class, getServiceType("MultiLanguageService"));
				optionList = multiLanguageService.getMultiLanguageLangListForOption(); 
				
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
				
			} else { 
				
				OptionService optionService = (OptionService)ServiceCallUtil.call(OptionService.class, getServiceType("OptionService"));
				optionList = optionService.findOptionList(list_name); 
			
				Document optionDoc = XMLtool.makeDocument(select_id, optionList, add_total, selected_value, except_list, except_type);
				xmlString = XMLtool.generate_xml_from_document(optionDoc);
			   
			}
	        
	        request.setAttribute("xmlString", xmlString);
	        
	        return mapping.findForward("option_list");
		}
	
		return null;
	}

}
