package kr.co.leaderway.mywork.user.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import kr.co.leaderway.mywork.common.model.MyWorkList;
import kr.co.leaderway.mywork.menu.model.Menu;
import kr.co.leaderway.mywork.schedule.SimpleTriggerRunner;
import kr.co.leaderway.mywork.system.action.BaseAction;
import kr.co.leaderway.mywork.user.UserService;
import kr.co.leaderway.mywork.user.form.UserForm;
import kr.co.leaderway.mywork.user.model.User;
import kr.co.leaderway.mywork.user.model.UserInfo;
import kr.co.leaderway.mywork.user.model.UserSearchParameter;
import kr.co.leaderway.mywork.util.ServiceCallUtil;
import kr.co.leaderway.util.PassWord;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;

public class UserAction extends BaseAction{
	/**
	 * 
	 * 
	 *
	 */
	
	private Log log = LogFactory.getLog(this.getClass());
	
	@SuppressWarnings("unchecked")
	public ActionForward doExecute(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String mode = request.getParameter("mode") != null ? request.getParameter("mode") : "";
		
		if  (mode.equals("add_user")) {
			
			add_user(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserAction") );
			redirect.addParameter("mode", "view_user_info");
			return redirect;

		} else if  (mode.equals("register_user")) {
			
			String addedUserNo = add_user(mapping, form, request, response);
			
			String groupNo = "USGR201003080505220003";   // 로그인한 유저 그룹(사용자 등록하게 되면 기본적으로 주어지는 그룹)
			add_group(addedUserNo, groupNo);

			login_user(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserAction") );
			redirect.addParameter("mode", "view_user_info");
			return redirect;
				
		} else if (mode.equals("add_user_form")) {
			
			request.setAttribute("contentTitle", "사용자 관리 - 사용자 등록");
			return mapping.findForward("user_add_form");
			
		} else if (mode.equals("register_user_form")) {
			
			request.setAttribute("contentTitle", "사용자 등록");
			return mapping.findForward("user_register_form");
			
		} else if (mode.equals("view_user")) {
			
			view_user(mapping, form, request, response);
			request.setAttribute("contentTitle", "사용자 관리 - 사용자 정보보기");
			
			return mapping.findForward("user_view");
			
		} else if (mode.equals("view_user_info")) {
			
			view_user_info(mapping, form, request, response);
			request.setAttribute("contentTitle", "사용자 관리 - 사용자 정보보기");
			
			return mapping.findForward("user_info_view");
			
		} else if (mode.equals("modify_user_form")) {
			
			view_user(mapping, form, request, response);
			request.setAttribute("contentTitle", "사용자 관리 - 사용자 정보수정");
			
			return mapping.findForward("user_modify_form");
			
		} else if (mode.equals("modify_user")) {
			
			modify_user(mapping, form, request, response);
				
			UserForm userForm = (UserForm) form;
			String userId = userForm.getUserId();
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserAction") );
			redirect.addParameter("mode", "view_user");
			redirect.addParameter("userId", userId);
			return redirect;
			
		} else if (mode.equals("delete_user")) {
			
			delete_user(mapping, form, request, response);
				
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserAction") );
			redirect.addParameter("mode", "list_user");
			return redirect;
		
		} else if (mode.equals("resign_user")) {
			
			resign_user(mapping, form, request, response);
				
			logout_user(mapping, form, request, response);
			
			String forwardURL = "/index.do";
			return new ActionForward(forwardURL, true);
			
		} else if (mode.equals("login_user_form")) {
			
			request.setAttribute("contentTitle", "사용자 로그인");
			return mapping.findForward("user_login_form");
			
		} else if (mode.equals("login_user")) {
			
			login_user(mapping, form, request, response);
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserAction") );
			redirect.addParameter("mode", "list_user");
			return redirect;
		
		} else if (mode.equals("logout_user_form")) {
			
			request.setAttribute("contentTitle", "사용자 로그아웃");
			
			return mapping.findForward("user_logout_form");
			
		} else if (mode.equals("logout_user")) {
			
			logout_user(mapping, form, request, response);
			
			//ActionRedirect redirect = new ActionRedirect( mapping.findForward("index") );
			//return redirect;
			
			String forwardURL = "/index.do";
			return new ActionForward(forwardURL, true);
			
			//return mapping.findForward("index");
			
		} else if (mode.equals("assign_group_form")) {
			
			view_user(mapping, form, request, response);
			request.setAttribute("contentTitle", "사용자 관리 - 사용자 그룹 할당");
			
			return mapping.findForward("group_assign_form");
			
	    } else if (mode.equals("add_group")) {
			
			add_group(mapping, form, request, response);
				
			UserForm userForm = (UserForm) form;
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserAction") );
			redirect.addParameter("mode", "view_user");
			redirect.addParameter("userId", userForm.getUserId());
			return redirect;
			
	    } else if (mode.equals("delete_group")) {
				
			delete_group(mapping, form, request, response);
				
			UserForm userForm = (UserForm) form;
			
			ActionRedirect redirect = new ActionRedirect( mapping.findForward("UserAction") );
			redirect.addParameter("mode", "view_user");
			redirect.addParameter("userId", userForm.getUserId());
			return redirect;
			
	    } else if (mode.equals("schedule_test")) {
	    	
	    	SimpleTriggerRunner scheduler = new SimpleTriggerRunner();
	    	scheduler.task();
	    	
	    	list_user(mapping, form, request, response);
	    	
	    	return mapping.findForward("user_list");
	    	
	    } else if (mode.equals("list_user")) {
	    	
	    	list_user(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "사용자 관리 - 리스트");
	    	
	    	return mapping.findForward("user_list");
	    	
	    } else if (mode.equals("list_user_for_select")) {
	    	
	    	list_user(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "사용자 선택");
	    	
	    	return mapping.findForward("user_list_for_select");
	    
	    } else if (mode.equals("list_user_In_Role_Of_Project_for_select")) {
	    	
	    	list_user_In_Role_Of_Project(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "사용자 선택");
	    	
	    	return mapping.findForward("user_list_for_select");
	    	
	    } else if (mode.equals("list_user_In_Role_Of_BusinessProcess_for_select")) {
	    	
	    	list_user_In_Role_Of_BusinessProcess(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "사용자 선택");
	    	
	    	return mapping.findForward("user_list_for_select");
	    	
	    } else { // view_user_info
	    	
	    	view_user_info(mapping, form, request, response);
	    	request.setAttribute("contentTitle", "사용자 관리 - 사용자 정보보기");
	    	
			return mapping.findForward("user_info_view");
	    	
	    }
		
	}
	
	@SuppressWarnings("unchecked")
	private void list_user_In_Role_Of_Project(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String userId = request.getParameter("userId") != null ? request.getParameter("userId") : "";
		String name = request.getParameter("name") != null ? request.getParameter("name") : "";
		name = new String(name.getBytes("8859_1"),"UTF-8");
		String email = request.getParameter("email") != null ? request.getParameter("email") : "";
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		UserSearchParameter userSearchParameter = new UserSearchParameter();
		if (userId.length() > 0) userSearchParameter.setUserId(userId);
		if (name.length() > 0) userSearchParameter.setName(name);
		if (email.length() > 0) userSearchParameter.setEmail(email);
		userSearchParameter.setCurrentPage(page);
		userSearchParameter.setRowsPerPage(per_page);
		
		String projectNo = request.getParameter("projectNo") != null ? request.getParameter("projectNo") : "0";

		String right_string = request.getParameter("right") != null ? request.getParameter("right") : "0";
		int right = Integer.parseInt(right_string);
		
		userSearchParameter.setProjectNo(projectNo);
		userSearchParameter.setRight(right);
	
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService"));
		MyWorkList userList = userService.findUserListInRoleOfProject(userSearchParameter);
		
		request.setAttribute("userList", userList);
		
	}
	
	private void list_user_In_Role_Of_BusinessProcess(ActionMapping mapping,
												ActionForm form,
												HttpServletRequest request,
												HttpServletResponse response) throws Exception {
		
		String userId = request.getParameter("userId") != null ? request.getParameter("userId") : "";
		String name = request.getParameter("name") != null ? request.getParameter("name") : "";
		name = new String(name.getBytes("8859_1"),"UTF-8");
		String email = request.getParameter("email") != null ? request.getParameter("email") : "";
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);
		
		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);
		
		UserSearchParameter userSearchParameter = new UserSearchParameter();
		if (userId.length() > 0) userSearchParameter.setUserId(userId);
		if (name.length() > 0) userSearchParameter.setName(name);
		if (email.length() > 0) userSearchParameter.setEmail(email);
		userSearchParameter.setCurrentPage(page);
		userSearchParameter.setRowsPerPage(per_page);
		
		String processNo = request.getParameter("processNo") != null ? request.getParameter("processNo") : "0";
		
		String stepNo = request.getParameter("stepNo") != null ? request.getParameter("stepNo") : "0";
		
		userSearchParameter.setProcessNo(processNo);
		userSearchParameter.setStepNo(stepNo);
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		MyWorkList userList = userService.findUserListInRoleOfBusinessProcess(userSearchParameter);
		
		request.setAttribute("userList", userList);
	
	}
	
	@SuppressWarnings("unchecked")
	private void list_user(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		String userId = request.getParameter("userId") != null ? request.getParameter("userId") : "";
		String name = request.getParameter("name") != null ? request.getParameter("name") : "";
		name = new String(name.getBytes("8859_1"),"UTF-8");
		String email = request.getParameter("email") != null ? request.getParameter("email") : "";
		
		String page_string = request.getParameter("page") != null ? request.getParameter("page") : "1";
		int page = Integer.parseInt(page_string);

		String per_page_string = request.getParameter("per_page") != null ? request.getParameter("per_page") : "10";
		int per_page = Integer.parseInt(per_page_string);

		UserSearchParameter userSearchParameter = new UserSearchParameter();
		if (userId.length() > 0) userSearchParameter.setUserId(userId);
		if (name.length() > 0) userSearchParameter.setName(name);
		if (email.length() > 0) userSearchParameter.setEmail(email);
		userSearchParameter.setCurrentPage(page);
		userSearchParameter.setRowsPerPage(per_page);
	
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		MyWorkList userList = userService.findUserList(userSearchParameter);
		
		request.setAttribute("userList", userList);
		
	}
	
	private String add_user(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		UserForm userForm = (UserForm) form;
		
		User user = new User();
		PropertyUtils.copyProperties(user, userForm);

		String inputString = user.getUserId() + user.getPassword();
		
		user.setPassword(PassWord.makeAndGetPassWord(inputString));
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		String addedUserNo = userService.addUser(user);
		
		request.setAttribute("alertMessage", "등록되었습니다.");
		
		return addedUserNo;
	}
	
	private void delete_user(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {
		
		UserForm userForm = (UserForm) form;
	
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.removeUser(userForm.getUserId());
		
		request.setAttribute("alertMessage", "삭제되었습니다.");
		
	}
	
	private void resign_user(ActionMapping mapping,
								ActionForm form,
								HttpServletRequest request,
								HttpServletResponse response) throws Exception {

		UserForm userForm = (UserForm) form;
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.resignUser(userForm.getUserId());
		
		request.setAttribute("alertMessage", "탈퇴되었습니다.");
	
	}
	
	@SuppressWarnings("unchecked")
	private void view_user(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		String userId = request.getParameter("userId");

		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		User user = userService.findUser(userId);
		
		request.setAttribute("user", user);		
		
		List userGroupList = userService.findUserGroupListByUserId(userId);
		
		request.setAttribute("userGroupList", userGroupList);		
		
	}
	
	@SuppressWarnings("unchecked")
	private void view_user_info(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		HttpSession session = request.getSession();
		UserInfo userInfo = (UserInfo)session.getAttribute("userInfo");
		request.setAttribute("userInfo", userInfo);		
		
		String userId = userInfo.getUser().getUserId();
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService"));
		List userGroupList = userService.findUserGroupListByUserId(userId);
		
		request.setAttribute("userGroupList", userGroupList);		

		
	}
	
	private void modify_user(ActionMapping mapping,
													ActionForm form,
													HttpServletRequest request,
													HttpServletResponse response) throws Exception {

		UserForm userForm = (UserForm) form;
		
		User user = new User();
		PropertyUtils.copyProperties(user, userForm);
		
		String inputString = user.getUserId() + user.getPassword();
		
		
		user.setPassword(PassWord.makeAndGetPassWord(inputString));

		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.updateUser(user);	

	}
	
	private void add_group(ActionMapping mapping,
											ActionForm form,
											HttpServletRequest request,
											HttpServletResponse response) throws Exception {

		String selected_groupid = request.getParameter("selected_groupid");
		
		UserForm userForm = (UserForm) form;
		
		User user = new User();
		PropertyUtils.copyProperties(user, userForm);
		user.setUserGroup(selected_groupid);
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.addGroup(user);
	
	}
	
	private void add_group(String userNo, String groupNo) throws Exception {
	
		User user = new User();
		
		user.setNo(userNo);
		user.setUserGroup(groupNo);
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.addGroup(user);
	
	}
	
	private void delete_group(ActionMapping mapping,
										ActionForm form,
										HttpServletRequest request,
										HttpServletResponse response) throws Exception {
		
		String assigned_groupno = request.getParameter("assigned_groupno");
		
		UserForm userForm = (UserForm) form;
		
		User user = new User();
		PropertyUtils.copyProperties(user, userForm);
		user.setUserGroup(assigned_groupno);
		
		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 
		userService.deleteGroup(user);
	
	}
	
	@SuppressWarnings("unchecked")
	private void login_user(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		UserForm userForm = (UserForm) form;

		UserService userService = (UserService)ServiceCallUtil.call(UserService.class, getServiceType("UserService")); 

		userService.login(userForm.getUserId(), userForm.getPassword());

		User user = userService.findUser(userForm.getUserId());

		List userGroupList = userService.findUserGroupListByUserId(userForm.getUserId());
		Menu selectedMenu = new Menu();
		
		UserInfo userInfo = new UserInfo();
		userInfo.setUser(user);
		userInfo.setUserGroupList(userGroupList);
		userInfo.setCurrentMenu(selectedMenu);
		
		HttpSession session = request.getSession();
		session.setAttribute("userInfo", userInfo);

	}
	
	@SuppressWarnings("unchecked")
	private void logout_user(ActionMapping mapping,
			ActionForm form,
			HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		HttpSession session = request.getSession();
		session.invalidate();

	}
	
}
