<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%@ page import="java.util.*" %>
<%@ page import="java.util.List" %>
<%@ page import="java.lang.Math" %>
<%@ page import="kr.co.leaderway.mywork.schedule.model.*" %>
<%@ page import="kr.co.leaderway.util.DateTool" %>
<%@ page import="kr.co.leaderway.mywork.util.ColorTool" %>
<%@ page import="org.apache.commons.logging.Log" %>
<%@ page import="org.apache.commons.logging.LogFactory" %>

<%

Log log = LogFactory.getLog("schedule/show_day_in_week.jsp");

SolarLunarListSet solarLunarListSet = (SolarLunarListSet)request.getAttribute("solarLunarListSet");
String week_index_string = request.getParameter("week_index") == null ? "0" : (String)request.getParameter("week_index");
int week_index = Integer.parseInt(week_index_string);
String start_string = request.getParameter("start") == null ? "0" : (String)request.getParameter("start");
long start = Long.parseLong(start_string);
String end_string = request.getParameter("end") == null ? "0" : (String)request.getParameter("end");
long end = Long.parseLong(end_string);
long nowTimeStamp = start;

String target_start_string = request.getParameter("target_start") == null ? "0" : (String)request.getParameter("target_start");
long target_start = Long.parseLong(target_start_string);
String target_end_string = request.getParameter("target_end") == null ? "0" : (String)request.getParameter("target_end");
long target_end = Long.parseLong(target_end_string);
String target_date = DateTool.TimeStampToDateString(target_start, "yyyyMMdd");

int target_year = Integer.parseInt(target_date.substring(0,4));
int target_month = Integer.parseInt(target_date.substring(4,6));
int target_day = Integer.parseInt(target_date.substring(6,8));

SolarLunar solarLunar = solarLunarListSet.getSolarLunarBySolarDate(target_date);
List nowScheduleList = solarLunar.getScheduleList();

Iterator nowScheduleListIter = nowScheduleList.iterator();
while (nowScheduleListIter.hasNext()) {
	Schedule nowSchedule = (Schedule)nowScheduleListIter.next();

%>
<table width=100% cellspacing=1 border=0 cellpadding=2>
<%
	String title = nowSchedule.getTitle();
	String title_view = "<a href = \"ScheduleAction.do?mode=view_schedule&no=" + nowSchedule.getNo() + "&category=" + nowSchedule.getCategory() + "\">" + nowSchedule.getTitle() + "</a>";
	String text = nowSchedule.getText();
	int eventType = nowSchedule.getEventType();
	int repeatType = nowSchedule.getRepeatType();
	
	String content_bgcolor_temp = ColorTool.getColor(nowSchedule.getNo());
    String content_bgcolor = "#" + content_bgcolor_temp;
	String bgcolor = "";
  	
	int even = week_index % 2;
	if (even == 1) {
		bgcolor = "#D5CCBB";
	} else {
		bgcolor = "#E6DDCC";
	}
  	  
	double fore_width = 0;
	double after_width = 0;
	String left_panel = "";
	String right_panel = "";
	String left_bgcolor = bgcolor;
	String right_bgcolor = bgcolor;
	String center_bgcolor = content_bgcolor;

	int target_day_now = 0;
	if (nowSchedule.getIsLunar() == 1) {
		target_day_now = Integer.parseInt(solarLunar.getLunarDate().substring(6,8));
	} else {
		target_day_now = Integer.parseInt(solarLunar.getSolarDate().substring(6,8));
	}	

	String start_time_show = "";
	String end_time_show = "";
	double start_time_sec = 0;
	double end_time_sec = 0;
	int start_day = 0;
	int end_day = 0;
	double from_time = 0;
	double to_time = 0;
	double start_time = 0;
	double end_time = 0;

	if (eventType == 1) {
   		if (repeatType == 1) {
	 		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	 		start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
	 		end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	 		end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	 		
        	fore_width = ((double)start_time_sec / 86400) * 100;
        	after_width = ((86400 - (double)end_time_sec) / 86400) * 100;
		} else if (repeatType == 2) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
			end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
			
			fore_width = ((double)start_time_sec / 86400) * 100;
        	after_width = ((86400 - (double)end_time_sec) / 86400) * 100;
		} else if (repeatType == 3) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
			end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
			end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
			
			fore_width = ((double)start_time_sec / 86400) * 100;
        	after_width = ((86400 - (double)end_time_sec) / 86400) * 100;
		} else if (repeatType == 4) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		 	end_time_sec = start_time_sec;
			
		 	fore_width = ((double)start_time_sec / 86400) * 100;
        	after_width = ((86400 - (double)end_time_sec) / 86400) * 100;
		} else if (repeatType == 5) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
			start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		 	end_time_sec = start_time_sec;
			
		 	fore_width = ((double)start_time_sec / 86400) * 100;
        	after_width = ((86400 - (double)end_time_sec) / 86400) * 100;
     	}
	} else if (eventType == 2 || eventType == 4) {
		if (repeatType == 1) {
	        long start_time_unixtimestamp = DateTool.dateStringToTimeStamp(nowSchedule.getFromDate() + nowSchedule.getFromTime(), "yyyyMMddhhmmss");
	        
	        start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	        long end_time_unixtimestamp_date = DateTool.dateStringToTimeStamp(nowSchedule.getToDate() + "000000", "yyyyMMddhhmmss");

	        end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
 			end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	        double end_time_unixtimestamp = end_time_unixtimestamp_date + end_time_sec;
 			
	        fore_width = ((double)(start_time_unixtimestamp - target_start) / 86400) * 100;
	        after_width = ((double)(target_end - end_time_unixtimestamp) / 86400) * 100;
	        
    	} else if (repeatType == 2) {
       		if (Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime())) {
       			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		    	
		    	start_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		    	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
				end_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
	
				fore_width = ((double)start_time_sec / 86400) * 100;
	        	after_width = ((86400 - (double)end_time_sec) / 86400) * 100;
 			} else {
		    	if (nowSchedule.getRepeatFromDate().equals(target_date)) {
		    		start_time_show = "";
		    		start_time_sec = 0;
		    	} else {
		    		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
		    		start_time_sec = Integer.parseInt(nowSchedule.getToTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getToTime().substring(2,4)) * 60;
		    	}

		    	if (nowSchedule.getRepeatEndDate().equals(target_date)) {
		    		end_time_show = "";
		    		end_time_sec = 86400;
		    	} else {
		    		end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		    		end_time_sec = Integer.parseInt(nowSchedule.getFromTime().substring(0,2)) * 3600 + Integer.parseInt(nowSchedule.getFromTime().substring(2,4)) * 60;
		    	}

	        	fore_width = ((double)start_time_sec / 86400) * 100;
	        	after_width = ((86400 - (double)end_time_sec) / 86400) * 100;
	
	        	left_panel = "<<";
	        	right_panel = ">>";
		    	left_bgcolor = content_bgcolor;
		    	right_bgcolor = content_bgcolor;
		    	center_bgcolor = bgcolor;
 			}
 	 	} else if (repeatType == 3) {
 	 		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
 			end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);

	     	if (nowSchedule.getFromWeek() < nowSchedule.getToWeek() || (nowSchedule.getFromWeek() == nowSchedule.getToWeek() && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime()))) {
		 		start_day = target_day - week_index + nowSchedule.getFromWeek();
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	end_day = target_day - week_index + nowSchedule.getToWeek();
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
	        	fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        	after_width = ((double)(target_end - to_time) / 86400) * 100;
	     	} else if (nowSchedule.getFromWeek() == nowSchedule.getToWeek() && Integer.parseInt(nowSchedule.getFromTime()) > Integer.parseInt(nowSchedule.getToTime()) && week_index == nowSchedule.getFromWeek()) {
		   		start_day = target_day;
		   		start_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		    	end_day = target_day;
		    	end_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	
		    	if (nowSchedule.getRepeatEndDate().equals(target_date)) {
		       		end_time_show = "";
		       		to_time = target_end;
		    	}
	
		    	if (nowSchedule.getRepeatFromDate().equals(target_date)) {
		       		start_time_show = "";
		       		from_time = target_start;
		    	}
	
	        	fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        	after_width = ((double)(target_end - to_time) / 86400) * 100;
	
	        	left_panel = "<<";
	        	right_panel = ">>";
		    	left_bgcolor = content_bgcolor;
		    	right_bgcolor = content_bgcolor;
		    	center_bgcolor = bgcolor;
	     	} else if (week_index < nowSchedule.getFromWeek()) {
		    	start_day = target_day - week_index - (7 - nowSchedule.getFromWeek());
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	end_day = target_day - week_index + nowSchedule.getToWeek();
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
		    	if (nowSchedule.getRepeatEndDate().equals(target_date) && to_time > target_end) {
		       		end_time_show = "";
		       		to_time = target_end;
		    	}
	
		    	if (nowSchedule.getRepeatFromDate().equals(target_date) && from_time < target_start) {
		       		start_time_show = "";
		       		from_time = target_start;
		    	}
	
	        	fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        	after_width = ((double)(target_end - to_time) / 86400) * 100;
	     	} else if (week_index >= nowSchedule.getFromWeek()) {
		    	start_day = target_day - week_index + nowSchedule.getFromWeek();
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, start_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	end_day = target_day - week_index + 7 + nowSchedule.getToWeek();
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, end_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
		 		if (nowSchedule.getRepeatEndDate().equals(target_date) && to_time > target_end) {
		       		end_time_show = "";
		      		to_time = target_end;
		    	}
	
		    	if (nowSchedule.getRepeatFromDate().equals(target_date) && from_time < target_start) {
		       		start_time_show = "";
		      		from_time = target_start;
		    	}
	
	        	fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        	after_width = ((double)(target_end - to_time) / 86400) * 100;
		 	} else {
		    	log.error("unhandled situation.. fix it!!");
		 	}
   		} else if (repeatType == 4) {
			start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	     	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
	
	     	if (nowSchedule.getFromDays() < nowSchedule.getToDays() || (nowSchedule.getFromDate().equals(nowSchedule.getToDate())) && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime())) {
		       	int month_modified = target_month + 1;
		       	int month_modified_minus = target_month - 1;
	           	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	           	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);

				if (nowSchedule.getFromDays() < target_day_now) {
					fore_width = -1;
				} else if (nowSchedule.getFromDays() > target_day_now) {
					fore_width = -1;
				} else {
			        fore_width = ((double)(from_time - target_start) / 86400) * 100;
				}
			
				if (nowSchedule.getToDays() < target_day_now) {
					after_width = -1;
				} else if (nowSchedule.getToDays() > target_day_now) {
					after_width = -1;
				} else {
			        after_width = ((double)(target_end - to_time) / 86400) * 100;
				}
	     	} else if (nowSchedule.getFromDays() <= target_day) {
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		    	int end_month = target_month + 1;
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        	fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        	after_width = ((double)(target_end - to_time) / 86400) * 100;
		 	} else {
		   		int from_month = target_month - 1;
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	        	to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        	fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        	after_width = ((double)(target_end - to_time) / 86400) * 100;
		 	}
	 	} else if (repeatType == 5) {
	 		start_time_show = nowSchedule.getFromTime().substring(0,2) + ":" + nowSchedule.getFromTime().substring(2,4);
	     	end_time_show = nowSchedule.getToTime().substring(0,2) + ":" + nowSchedule.getToTime().substring(2,4);
		 	start_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
		 	end_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
		 	
	     	if (Integer.parseInt(nowSchedule.getFromDate()) < Integer.parseInt(nowSchedule.getToDate()) || (nowSchedule.getFromDate().equals(nowSchedule.getToDate()) && Integer.parseInt(nowSchedule.getFromTime()) <= Integer.parseInt(nowSchedule.getToTime()))) {
	        	from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	       		to_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	
	        	fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        	after_width = ((double)(target_end - to_time) / 86400) * 100;
		 	} else {
		    	int from_month_day = Integer.parseInt(nowSchedule.getFromDate().substring(2,6));
		    	int target_month_day = target_month + target_day;
	
		    	if (from_month_day <= target_month_day) {
		    		int target_year_modified = target_year + 1;
	        		from_time = DateTool.dateStringToTimeStamp(target_year, target_month, target_day, Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	        		to_time = DateTool.dateStringToTimeStamp(target_year_modified, Integer.parseInt(nowSchedule.getToDate().substring(4,6)), Integer.parseInt(nowSchedule.getToDate().substring(6,8)), Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        		fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        		after_width = ((double)(target_end - to_time) / 86400) * 100;
		    	} else {
		    		int target_year_modified = target_year - 1;
	        		from_time = DateTool.dateStringToTimeStamp(target_year_modified, Integer.parseInt(nowSchedule.getFromDate().substring(4,6)), Integer.parseInt(nowSchedule.getFromDate().substring(6,8)), Integer.parseInt(nowSchedule.getFromTime().substring(0,2)), Integer.parseInt(nowSchedule.getFromTime().substring(2,4)), 0);
	        		to_time = DateTool.dateStringToTimeStamp(target_year, Integer.parseInt(nowSchedule.getToDate().substring(4,6)), Integer.parseInt(nowSchedule.getToDate().substring(6,8)), Integer.parseInt(nowSchedule.getToTime().substring(0,2)), Integer.parseInt(nowSchedule.getToTime().substring(2,4)), 0);
	        		fore_width = ((double)(from_time - target_start) / 86400) * 100;
	        		after_width = ((double)(target_end - to_time) / 86400) * 100;
		    	}
		 	}
   		}
	} else if (eventType == 3) {
		fore_width = 0;
		after_width = 0;
	}

	if (fore_width < 0) {
		fore_width = 0;
		start_time_show = "<<";
	}
	if (after_width < -0.002) {
		after_width = 0;
		end_time_show = ">>";
	}

	double content_width = 100 - (fore_width + after_width);
  
	String title_in_content = "";
	String title_in_fore = nowSchedule.getTitle();
	String title_in_after = "";
	String start_time_in_content = "";
	String start_time_in_fore = start_time_show;
	String end_time_in_content = "";
	String end_time_in_after = end_time_show;
	
	if (content_width < 20 && (eventType == 2 || eventType == 4)) {
		if (fore_width > after_width) {
	    	title_in_content = "";
			title_in_fore = title_view;
			title_in_after = "";
		} else {
			title_in_content = "";
			title_in_fore = "";
			title_in_after = nowSchedule.getTitle();
		}
	
		start_time_in_content = "";
		start_time_in_fore = start_time_show;
		end_time_in_content = "";
		end_time_in_after = end_time_show;
	} else if (content_width < 20 && eventType == 1) {
		if (fore_width > after_width) {
			title_in_content = "";
			title_in_fore = title_view;
			title_in_after = "";
		} else {
			title_in_content = "";
			title_in_fore = "";
			title_in_after = title_view;
		}
		start_time_in_content = "";
		start_time_in_fore = start_time_show;
		end_time_in_content = "";
		end_time_in_after = "";
	} else if (eventType == 3) {
		title_in_fore = "";
		title_in_after = "";
		title_in_content = title_view;
		start_time_in_content = "00:00";
		start_time_in_fore = "";
		end_time_in_content = "24:00";
	} else {
		title_in_content = title_view;
		title_in_fore = "";
		title_in_after = "";
		start_time_in_fore = "";
		start_time_in_content = start_time_show;
		end_time_in_content = end_time_show;
		end_time_in_after = "";
	}
	
	
	String align_fore = "right";
	String align_after = "left";

%>
   <tr>
<%
   	if (fore_width > 0) {
%>
     <td width=<%=fore_width%>% bgcolor=<%=left_bgcolor%>>
     	<table width=100% cellspacing=0 border=0 cellpadding=0>
       		<tr>
	   			<td align=left><%=left_panel%></td>
	   			<td align="right"><b><%=title_in_fore%></b></td>
	   			<td align="right"><%=start_time_in_fore%></td>
	 		</tr>
     	</table>
     </td>
<%
  	}
%>
   
     <td width=<%=content_width%>% bgcolor=<%=center_bgcolor%>>
       <table width=100% cellspacing=0 border=0 cellpadding=0>
         <tr>
		   <td align=left><%=start_time_in_content%></td>
		   <td align="center"><b><%=title_in_content%></b></td>
		   <td align="right"><%=end_time_in_content%></td>
		 </tr>
       </table>
     </td>
<%
   	if (after_width > 0) {
%>     
     <td width=<%=after_width%>% bgcolor=<%=right_bgcolor%>>
       <table width=100% cellspacing=0 border=0 cellpadding=0>
         <tr>
		   <td align=left><%=end_time_in_after%></td>
		   <td align=left><b><%=title_in_after%></b></td>
		   <td align="right"><%=right_panel%></td>
		 </tr>
       </table>
     </td>
<%
   	}
%>
   </tr>  
   </table>
<%
}
%>