## nari.rb ## 
#####################################################
# Nari Interpreter Core                # spac.wo.tc #
# 나리 인터프리터 코어                 ##############
######################################## acroedit   #
# 사실 아직까지는 언어 쉘의 모습이다.  # 으로 작성됨#
#####################################################
# Written by 민군(kmsr819@minsland.com)# Min Seog   # 
# Licence : GNU GPL                    # in Korea.. #
#####################################################
## -- 이 선 아래부터 프로그램 코드이다. -- ##
# strscan 참조
require 'strscan'
# date 참조
require 'date'
# time 참조
require 'time'
# values 해시 세팅
values = {}
# 루프
loop do
  # 입력 받는다
  line = gets or break
  # scanner 생성
  scanner = StringScanner.new(line.chomp)
  # 다음 함수 파이프를 통과하지 않으면 에러
  scanner.scan(/(openie|nowtime|nowdate|fileread|put2|put|puts2|puts|abs|to_i|set|to_s|boomb)\s+/) or fail "Missing command"
  # cmd 세팅
  cmd = scanner[1]
  # var_name 세팅 및 파이프 검증
  var_name = scanner.scan(/\w+/) or fail "Missing variable"
  # cmd 를 케이스 조건으로..
  case cmd
  # nowtime 함수
  when "nowtime"
    nowtime1 = Time.now.httpdate
    values[var_name] = nowtime1
    puts values[var_name]
  # nowdate 함수
  when "nowdate"
    nowdate1 = DateTime.now
    values[var_name] = nowdate1
    puts values[var_name]
  # put2 함수
  when "put2" 
    puts "#{values[var_name].inspect}"
  # put 함수
  when "put" 
    print "#{values[var_name].inspect}"
  # puts2 함수
  when "puts2" 
    puts "#{var_name}"
  # puts 함수
  when "puts" 
    print "#{var_name}"
  # abs 함수
  when "abs"
    puts values[var_name].to_i.abs
  # to_i 함수
  when "to_i"
    values[var_name] = values[var_name].to_i
  # set 함수
  when "set"
    scanner.skip(/\s+=\s+/) or fail "Missing '='"
    value = scanner.rest
    values[var_name] = value
  # to_s 함수
  when "to_s"
    values[var_name] = values[var_name].to_s
  # boomb 함수
  when "boomb"
    if var_name == "me"
      abort
    end
  # 만약 위 것들에 해당하지 않으면?
  else
    #뷁귉 에러
    fail cmd
  # 케이스문을 닫음
  end
# 루프문을 닫음 그리고 바이바이~
end
