#include <qpainter.h>
#include "mykeyboard.h"
#include <qeuckrcodec.h>
#include <qfont.h>
#ifndef QT_NO_SCREEN_KEYBOARD

#define	CX_BUTTON	20
#define	CY_BUTTON	20


MyKeyboard::MyKeyboard(QWidget *parent, const char *name, bool modal, WFlags f)
        :QDialog(parent, name, modal, f)
{
	setCaption("Screen Keyboard");

	// 200x100  ũ⸦ Ѵ
	setFixedSize(200, 100);

	//  Ű ư Ѵ
	for (int i = 0; i < 4; i++)
	{
		for (int j = 0; j < 10; j++)
		{
			m_rcKey[i][j].setRect(CX_BUTTON * j, CY_BUTTON * i, CX_BUTTON, CY_BUTTON);
		}
	}
	// back space Ű 
	m_rcKeySp[0].setRect(0, CY_BUTTON * 4, CX_BUTTON * 2, CY_BUTTON);
	// space Ű 
	m_rcKeySp[1].setRect(CX_BUTTON * 2, CY_BUTTON * 4, CX_BUTTON * 5, CY_BUTTON);
	// enter Ű 
	m_rcKeySp[2].setRect(CX_BUTTON * 7, CY_BUTTON * 4, CX_BUTTON * 3, CY_BUTTON);

	m_strKey[0] = "0123456789";
	//m_strKey[1] = "qwertyuiop";
	QEucKrCodec *codec = new QEucKrCodec();
	char *string = "ˤŤ";
	
	char *string2 = "Ǥä;";

	char *string3 = "Ф̤,./";
	m_strKey[1] = codec->toUnicode(string, strlen(string));

	m_strKey[2] = codec->toUnicode(string2, strlen(string2));

	m_strKey[3] = codec->toUnicode(string3, strlen(string3));

//	m_strKey[2] = "asdfghjkl;";
//	m_strKey[3] = "zxcvbnm,./";

	m_strKeySp[0] = "BS";
	m_strKeySp[1] = "Space";
	m_strKeySp[2] = "Enter";

	// Ű忡  ڸ θ edit  
	connect(this, SIGNAL(sigSelectKey(const QString&)), parent, SLOT(slotMyInsert(const QString&)));
}

void MyKeyboard::paintEvent(QPaintEvent *)
{
	QPainter	p(this);
	QFont font("gulim", 12, QFont::Normal);
	// ٴ  ä
	p.setFont(font);
	p.fillRect(0, 0, width(), height(), QBrush(Qt::white));

	//   Ѵ
	p.setPen(QPen(Qt::black, 1, Qt::DotLine));

	// ׵θ ׸
	p.drawRect(0, 0, CX_BUTTON * 10, CX_BUTTON * 5);

	//  ư  ׸.
	for (int i = 1; i < 5; i++)
		p.drawLine(0, CY_BUTTON * i, CX_BUTTON * 10, CY_BUTTON * i);
	for (i = 1; i < 10; i++)
		p.drawLine(CX_BUTTON * i, 0, CX_BUTTON * i, CY_BUTTON * 4);
	p.drawLine(CX_BUTTON * 2, CY_BUTTON * 4, CX_BUTTON * 2, CY_BUTTON * 5);
	p.drawLine(CX_BUTTON * 7, CY_BUTTON * 4, CX_BUTTON * 7, CY_BUTTON * 5);

	//  Ű ׸
	for (i = 0; i < 4; i++)
	{
		for (int j = 0; j < 10; j++)
		{
			p.drawText(m_rcKey[i][j], Qt::AlignCenter, QString(m_strKey[i][j]));
		}
	}
	for (i = 0; i < 3; i++)
	{
		p.drawText(m_rcKeySp[i], Qt::AlignCenter, m_strKeySp[i]);
	}
}

void MyKeyboard::mousePressEvent(QMouseEvent* e)
{
	QPoint		point = e->pos();
	QPainter	p(this);
	int			i;

	m_rcSelectedKey = QRect(-1, -1, -1, -1);
	m_strSelectedKey = "";

	for (i = 0; i < 4; i++)
	{
		for (int j = 0; j < 10; j++)
		{
			//   شǴ Ű  
			if (m_rcKey[i][j].contains(point))
			{
				m_rcSelectedKey = m_rcKey[i][j];
				m_strSelectedKey = m_strKey[i][j];
				goto JUMP;
			}
		}
	}

JUMP:
	// BS, Space, Enter  
	if (i == 4)
	{
		for (int k = 0; k < 3; k++)
		{
			//   شǴ Ű  
			if (m_rcKeySp[k].contains(point))
			{
				m_rcSelectedKey = m_rcKeySp[k];
				m_strSelectedKey = m_strKeySp[k];
			}
		}
	}

	// õ Ű 
	if (!m_rcSelectedKey.isNull())
	{
		//  õ Ű ǥѴ
		p.setRasterOp(Qt::XorROP);
		p.fillRect(m_rcSelectedKey, Qt::white);
		p.drawText(m_rcSelectedKey, Qt::AlignCenter, m_strSelectedKey);

		// θ  ڸ .
		if (i == 4)		// Backspace, Space, Enter  
		{
			if (m_strSelectedKey == "BS"){			// Backspace  
				QString one;
				test.InputString(QString(QChar(0x08)));
				one = test.outString;
				//emit sigSelectKey(QString(QChar(0x08)));
				emit sigSelectKey(one);
				}
				else if (m_strSelectedKey == "Space"){	// Space  
				QString one;
				test.InputString(QString(" "));
				one = test.outString;
				emit sigSelectKey(one);
				}
				//emit sigSelectKey(QString(" "));
				else if (m_strSelectedKey == "Enter"){	// Enter  
				QString one;
				test.InputString(QString(QChar(0x0d)));
				one = test.outString;
				emit sigSelectKey(one);
				}
				//emit sigSelectKey(QString(QChar(0x0d)));
		}
		else
		{
			//  ڸ 
/*
			QChar *a;
			a = new QChar(*m_strSelectedKey.unicode());
			if(a->unicode() == 0x3131)
			{
				int k;
				k =1;
			}*/
			test.InputString(m_strSelectedKey);
			
			//ʼ ߼  ʼ  Ѵ.
			if(test.changed == 1){
				emit sigSelectKey(QString(QChar(0x08)));
			}
			////////////////////////////////////////////

			m_strSelectedKey = test.outString;
			emit sigSelectKey(m_strSelectedKey);
		}
		p.setRasterOp(Qt::CopyROP);
	}
}

void MyKeyboard::mouseReleaseEvent(QMouseEvent*)
{
	QPainter	p(this);

	// õ Ű 
	if (!m_rcSelectedKey.isNull())
	{
		//  õ Ű ǥѴ
		p.setRasterOp(Qt::XorROP);
		p.fillRect(m_rcSelectedKey, Qt::white);
		p.drawText(m_rcSelectedKey, Qt::AlignCenter, m_strSelectedKey);
		p.setRasterOp(Qt::CopyROP);
	}
}

#endif // QT_NO_SCREEN_KEYABORD

// EOF
