/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "knateoncommon.h"
#include "filetransfer.h"
#include "../network/sendfileinfo.h"
#include "../util/common.h"
#include "../util/sound.h"

extern nmconfig stConfig;

FileTransfer::FileTransfer(QWidget *parent, const char *name)
	: FileTransferForm(parent, name)
{
	/// fileListGroupBox->hide(); <<=== 잠시 없앰.
	// layout()->setResizeMode(QLayout::Fixed);
	progressBar1->setProgress ( 0 );
	fileListView->clear();

  
	connect( fileListView, SIGNAL( selectionChanged () ), this, SLOT( slotUpdateInfo() ) );
	// connect( this, SIGNAL( progressUpdate( int ) ), progressBar1, SLOT( setProgress( int ) ) );
	connect( cancelButton, SIGNAL( clicked() ), SLOT( slotCancelButton() ) );
}


FileTransfer::~FileTransfer()
{
}

void FileTransfer::showlist()
{
	fileListGroupBox->show();
	layout()->setResizeMode(QLayout::Fixed);
}

void FileTransfer::hidelist()
{
	fileListGroupBox->hide();
	layout()->setResizeMode(QLayout::Fixed);
}

void FileTransfer::addListView(const QString & sCookie, const QString & sID, const QString & sFile, const int nSize, bool bSend)
{
	QListViewItem* newItem = new QListViewItem(fileListView, sCookie, sID, sFile, QString::number(nSize) );
	fileListView->setCurrentItem ( newItem );
	// slotUpdateInfo();
	fileListView->setSelected ( newItem, true );
	fileListView->setSorting ( -1 );
	progressBar1->setProgress( 0 );

	kbStatusLabel->setText( "0/" + QString::number(nSize) );

	if ( bSend )
		newItem->setText( 4, UTF8("보냄") );
	else
		newItem->setText( 4, UTF8("받음") );
  
	newItem->setText( 6, QString::fromUtf8("기다리는 중") );

	newItem->setText( 7, "0");
	
	cancelButton->setEnabled( TRUE );
	cancelButton->setText( QString::fromUtf8("중지") );
}

void FileTransfer::updateProgressByByte(const QString & sCookie, const int nByte)
{
	QListViewItem *item = 0;

	QListViewItemIterator it( fileListView );
	while ( it.current() )
	{
		item = it.current();
		if (item->text(0) == sCookie )
			break;
		++it;
	}
	if ( item )
	{
		int nTSize = QString(item->text(3)).toInt();
		int nPercent = (nByte / nTSize) * 100;
		item->setText(5, QString::number( nPercent ) + "%");
		emit progressUpdate( nPercent );
		item->setText( 6, QString::fromUtf8("전송중") );
	}
}

void FileTransfer::updateProgressByPercent( const QString& sCookie, const unsigned long ulSum, const unsigned long ulTotal, const int nPercent )
{
	Q_UNUSED( ulTotal );
	
	QListViewItem *item = 0;

	QListViewItemIterator it( fileListView );
	while ( it.current() )
	{
		item = it.current();
		if (item->text(0) == sCookie )
			break;
		++it;
	}

	if ( item )
	{
		item->setText(5, QString::number( nPercent ) + "%");
		item->setText( 6, QString::fromUtf8("전송중") );
		item->setText(7, QString::number( ulSum ) );

		if (  fileListView->isSelected( item )  )
		{
			kbStatusLabel->clear();
			kbStatusLabel->setText( QString::number( ulSum ) + "/" + item->text(3) );
		}
	}
	cancelButton->setEnabled( TRUE );
	cancelButton->setText( QString::fromUtf8("중지") );

#ifdef NETDEBUG
	kdDebug() << "% : " << nPercent << endl;
#endif
	progressBar1->setProgress( nPercent );
	progressBar1->update();
}


void FileTransfer::finishTransfer(const QString & sCookie)
{
	QListViewItem *item = 0;

	QListViewItemIterator it( fileListView );
	while ( it.current() )
	{
		item = it.current();
		if (item->text(0) == sCookie )
			break;
		++it;
	}
	if ( item )
	{
		item->setText( 6, QString::fromUtf8("전송완료") );

		/*!
		 * 쪽지 받음 소리
		 */
		if ( stConfig.usesound && stConfig.usefilesenddonesound )
		{
			Sound::play( stConfig.filesenddonesoundpath );
		}
    
		/*
		  KMessageBox::information(this, QString::fromUtf8(item->text(2) + "\n파일 전송을 완료했습니다."), QString::fromUtf8("네이트온 파일 전송 관리자") );
		*/
	}
	cancelButton->setEnabled( FALSE );
	cancelButton->setText( QString::fromUtf8("완료") );
}


#include "filetransfer.moc"


int FileTransfer::showAcceptOk(SendFileInfo* pSendFileInfo)
{
	Q_UNUSED( pSendFileInfo );
  
#if 0
	/*! Ok = 1, Cancel = 2, Yes = 3, No = 4, Continue = 5 */

	return KMessageBox::messageBox(this, KMessageBox::QuestionYesNo, QString::fromUtf8("상대방의 수락을 기다리는 중입니다.\n전송자: " + pSendFileInfo->getYourID() + "\n파일명: ") + pSendFileInfo->getFileName() + " (" + QString::number(pSendFileInfo->getFileSize()) + ")", QString::fromUtf8("파일전송") );
#endif
	return 0;
}

void FileTransfer::slotUpdateInfo()
{
	QListViewItem* pCurItem = fileListView->selectedItem();
	if ( pCurItem )
	{
		fileNameLabel->setText( pCurItem->text(2) );
		kbStatusLabel->setText( pCurItem->text(7) + "/" + pCurItem->text(3) );
		QString sPercent;
		sPercent = (pCurItem->text(5)).replace("%", "");
		progressBar1->setProgress ( sPercent.toInt() );
		if ( ( pCurItem->text(6) == QString::fromUtf8("전송중") ) || ( pCurItem->text(6) == QString::fromUtf8("기다리는 중") ) )
		{
			cancelButton->setEnabled( TRUE );
			cancelButton->setText( QString::fromUtf8("중지") );
		}
		else
		{
			cancelButton->setEnabled( FALSE );
			cancelButton->setText( QString::fromUtf8("완료") );
		}
	}
}

void FileTransfer::cancelTransfer(const QString & sCookie)
{
	KMessageBox::information( this, UTF8("상대방이 파일전송을 취소하였습니다."), UTF8("전송 취소") );
	
	QListViewItem *item = 0;

	QListViewItemIterator it( fileListView );
	while ( it.current() )
	{
		item = it.current();
		if (item->text(0) == sCookie )
			break;
		++it;
	}
	if ( item )
	{
		item->setText( 6, QString::fromUtf8("전송취소됨") );
	}
	cancelButton->setEnabled( FALSE );
}

void FileTransfer::slotCancelButton()
{
	QListViewItem* pCurItem = fileListView->selectedItem();
	if ( pCurItem )
	{
#ifdef NETDEBUG
		kdDebug() << pCurItem->text(2) << endl;
#endif
		/*!
		 * SSCookie
		 */
		emit cancelFileTransfer( pCurItem->text(0) );
		cancelButton->setEnabled( FALSE );
		pCurItem->setText( 6, QString::fromUtf8("전송취소됨") );
	}
}
