/*
 *  RFC 1321 compliant MD5 implementation
 *
 *  Copyright (C) 2001-2003  Christophe Devine
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MD5_H
#define MD5_H

#include <qstring.h>
#include <qobject.h>

#ifndef uint8
#define uint8  unsigned char
#endif

#ifndef uint32
#define uint32 unsigned long int
#endif

/**
   @author Christophe Devine
*/
class CMD5 {
public:
    CMD5();

    typedef struct {
        uint32 total[2];
        uint32 state[4];
        uint8 buffer[64];
    } md5_context;

    // public interface :)
    QString MD5_Encode(QString sOrgString);

private:

    void md5_starts( md5_context *ctx );
    void md5_update( md5_context *ctx, uint8 *input, uint32 length );
    void md5_finish( md5_context *ctx, uint8 digest[16] );
    void md5_process( md5_context *ctx, uint8 data[64] );

};
#endif
