import javax.swing.*;
import java.awt.*;

public class ColLabels extends JPanel {
	private Nemo nemo;
	private Dimension d;
	private int height;
	private int offset;

	public ColLabels(Nemo nemo) {
		this.nemo = nemo;
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		// g2.drawRect(0, 0, d.width-1, d.height-1);
		g2.rotate(Math.PI / 2);
		for (int i = 0; i < nemo.getNCols(); i++) {
			g2.drawString(nemo.getCol(i).toString(),
				0, -offset - i*height);
		}
	}

	public Dimension getPreferredSize() {
		FontMetrics fm = getGraphics().getFontMetrics();
		height = fm.getHeight();
		offset = fm.getLeading()/2 + fm.getDescent();
		int max = 0;
		for (int i = 0; i < nemo.getNCols(); i++) {
			int width = fm.stringWidth(
				nemo.getCol(i).toString());
			if (width > max)
				max = width;
		}
		d = new Dimension(nemo.getNCols()*height, max);
		return d;
	}
}
