import junit.framework.TestCase;
import java.io.*;

public class NemoTest extends TestCase {
	private Nemo nemo;
	private static final int N = 3;

	public NemoTest(String name) {
		super(name);
	}

	public void testMarked() {
		assertTrue(!nemo.marked(0, 0));
	}

	public void testMark() {
		nemo.mark(0, 0);
		assertTrue(nemo.marked(0, 0));
	}

	protected void setUp() {
		nemo = new Nemo(N, N);
	}

	public void testFinished() {
		try {
			nemo = new Nemo(new StringReader(
				"3 3 \n 3 \n 1 \n 1 \n 1 1 \n 2 \n 1 \n"));
		}
		catch (IOException e) {
			fail();
		}
		assertTrue(!nemo.finished());
		for (int i = 0; i < 3; i++) {
			nemo.mark(0, i);
			nemo.mark(3 - i - 1, i);
		}
		assertTrue(nemo.finished());
	}

	public void testCreateWithReader() {
		StringReader in = new StringReader("2 2\n1\n1\n1\n1\n");
		try {
			nemo = new Nemo(in);
		}
		catch (IOException e) {
			fail();
		}
		assertEquals(2, nemo.getNRows());
		assertEquals(2, nemo.getNCols());
		for (int i = 0; i < 2; i++) {
			Numbers a = nemo.getRow(i);
			assertEquals(1, a.size());
			assertEquals(1, a.get(0));
			a = nemo.getCol(i);
			assertEquals(1, a.size());
			assertEquals(1, a.get(0));
		}
	}

	public void testUnmark() {
		nemo.mark(0, 0);
		assertTrue(nemo.marked(0, 0));
		nemo.unmark(0, 0);
		assertTrue(!nemo.marked(0, 0));
	}

	public void testLoad() {
		try {
			nemo.load(
				new StringReader("2 2 \n 2 \n 1 \n 1 \n 2 \n"));
		}
		catch (IOException e) {
			fail();
		}
		assertEquals(2, nemo.getNRows());
		assertEquals(2, nemo.getNCols());
		assertTrue(nemo.getRow(0).toString().equals("2"));
		assertTrue(nemo.getRow(1).toString().equals("1"));
		assertTrue(nemo.getCol(0).toString().equals("1"));
		assertTrue(nemo.getCol(1).toString().equals("2"));
	}
}
