/******************************************************************************
 * ý۸ : NESPointer
 *    : nespointerlib.c
 *      : ޽ ŷ DLL
 *    : 2002. 09. 14.
 *    :  ȣ 
 *-----------------------------------------------------------------------------
 *    :
 *    :
 *  :
 *******************************************************************************/

#include <windows.h>

HHOOK hHook, hHook2;
HINSTANCE hInstance;

#define WM_GET_SCALE			WM_USER + 1
#define WM_CAPTURE_SCREEN	WM_USER + 2

// 콺 ŷ ν.
LRESULT CALLBACK MouseHookProc( int code, WPARAM wParam, LPARAM lParam );
// Ű ŷ ν.
LRESULT CALLBACK KeyboardHookProc( int code, WPARAM wParam, LPARAM lParam );


// DLL .
BOOL APIENTRY DllMain( HINSTANCE hInst, DWORD dwReason, LPVOID param )
{
	hInstance = hInst;
	return TRUE;
}


// 콺 ŷ ν.
LRESULT CALLBACK MouseHookProc( int code, WPARAM wParam, LPARAM lParam )
{
	HDC hdcScreen, hdcWindow;
	HWND hWnd, desktop;
	RECT rect, desRect;
	int srcX, srcY, desX, desY, width, height;
	int scale;
	
	if ( code == HC_ACTION )
	{
		hWnd = FindWindow( "NESPointer", "NESPointer" );	//  ڵ ã.
		//hWnd = ((PMOUSEHOOKSTRUCT)lParam)->hwnd;
		if ( hWnd != NULL )
		{
			desktop = GetDesktopWindow();
			//desktop = ((PMOUSEHOOKSTRUCT)lParam)->hwnd;

			if ( wParam == WM_MOUSEMOVE )
			{
				//  .
				scale = SendMessage( hWnd, WM_GET_SCALE, 0, 0 );
				scale = (scale <= 0) ? 2 : scale;


				/*  콺  ٹ ȭ   쿡 ׸ */
				hdcScreen = GetDC( desktop );
				hdcWindow = GetDC( hWnd );
								
				GetWindowRect( desktop, &rect );
				GetClientRect( hWnd, &desRect );

				width = desRect.right-desRect.left;
				height = desRect.bottom-desRect.top;
				srcX = min( max( ((PMOUSEHOOKSTRUCT)lParam)->pt.x - (width/scale)/2, rect.left ), 
								(rect.right-width/3) );
				srcY = min( max( ((PMOUSEHOOKSTRUCT)lParam)->pt.y - (height/scale)/2, rect.top ), 
								(rect.bottom-height/3) );
				desX = 0;
				desY = 0;
				
				StretchBlt( hdcWindow, desX, desY, width, height,
								hdcScreen, srcX, srcY, width/scale, height/scale, SRCCOPY );


				/* ҽ  */
				ReleaseDC( desktop, hdcScreen );
				ReleaseDC( hWnd, hdcWindow );
			}
		}
	}

	return CallNextHookEx( hHook, code, wParam, lParam );
}


// Ű ŷ ν.
LRESULT CALLBACK KeyboardHookProc( int code, WPARAM wParam, LPARAM lParam )
{
	HWND hwnd;

	if ( code == HC_ACTION )
	{
		// Ctrl + Alt + PrintScrn  ȭ ĸ.
		if ( wParam == VK_SNAPSHOT )
		{
			if ( (GetKeyState( VK_CONTROL ) < 0) && (GetKeyState( VK_MENU ) < 0) )
			{
				hwnd = FindWindow( "NESPointer", "NESPointer" );
				SendMessage( hwnd, WM_CAPTURE_SCREEN, 0, 0 );
			}
		}
	}
	return CallNextHookEx( hHook2, code, wParam, lParam );
}


// ŷ ġ Լ.
__declspec(dllexport) VOID InstallHook( VOID )
{
	hHook = SetWindowsHookEx( WH_MOUSE, MouseHookProc, hInstance, 0 ); 
	hHook2 = SetWindowsHookEx( WH_KEYBOARD, KeyboardHookProc, hInstance, 0 ); 
}


// ŷ Լ.
__declspec(dllexport) VOID UninstallHook( VOID )
{
	UnhookWindowsHookEx( hHook );
	UnhookWindowsHookEx( hHook2 );
}
