/******************************************************************************
 * ý۸ : NESPointer
 *    : nespointer.c
 *      :
 *    : 2002. 09. 14.
 *    :  ȣ 
 *-----------------------------------------------------------------------------
 *    :
 *    :
 *  :
 *******************************************************************************/

#include <windows.h>
#include <time.h>
#include "resource.h"

__declspec(dllimport) VOID InstallHook( VOID );					// hook proc ġ.
__declspec(dllimport) VOID UninstallHook( VOID );				// hook proc .

LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM );		//  ν.
BOOL CALLBACK AboutDlgProc( HWND, UINT, WPARAM, LPARAM );	// AboutDlg ν.

VOID OnCreate( VOID );												// WM_CREATE ޽ ڵ鷯.
VOID OnMouseMove( HWND hwnd, WPARAM wParam,					// WM_MOUSEMOVE ޽ ڵ鷯.
						LPARAM lParam );
VOID OnCommand( HWND hwnd, WORD id );							// WM_COMMAND ޽ ڵ鷯.
VOID OnCaptureScreen( HWND hwnd );								// WM_CAPTURE_SCREEN ޽ ڵ鷯.

#define ID_MENU_EXIT		100	// .
#define ID_MENU_ABOUT	101	// α׷ .

#define ID_MENU_SCALE1	111	//  x1.
#define ID_MENU_SCALE2	112	//  x2.
#define ID_MENU_SCALE4	114	//  x4.
#define ID_MENU_SCALE6	116	//  x6.
#define ID_MENU_SCALE8	118	//  x8.

#define WM_GET_SCALE			WM_USER+1		//  ȯ ޽.
#define WM_CAPTURE_SCREEN	WM_USER + 2		// ũ ĸ ޽.


HINSTANCE ghInstance;			// ø̼ νϽ ڵ.
HMENU ghMenu;						//  ޴ ڵ.
HMENU ghPopupMenu;				// ˾ ޴ ڵ.

BOOL gbMouseDown = FALSE;		// 콺 ư ٿ .
POINT gPrevMousePos;				// 콺  ġ.
int gScale = 2;					// .


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, 
						 LPSTR lpCmdLine, int nShowCmd )
{
	HWND hwnd;
	WNDCLASS wndclass;
	MSG msg;

	ghInstance = hInstance;

	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hbrBackground = GetStockObject( WHITE_BRUSH );
	wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
	wndclass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
	wndclass.hInstance = hInstance;
	wndclass.lpfnWndProc = WndProc;
	wndclass.lpszClassName = "NESPointer";
	wndclass.lpszMenuName = NULL;
	wndclass.style = CS_HREDRAW | CS_VREDRAW;

	RegisterClass( &wndclass );

	hwnd = CreateWindowEx( WS_EX_TOPMOST | WS_EX_CLIENTEDGE, "NESPointer", "NESPointer", 
						WS_POPUP | WS_THICKFRAME| WS_SYSMENU, 
						CW_USEDEFAULT, CW_USEDEFAULT, 300, 300,
						NULL, NULL, hInstance, NULL );
	ShowWindow( hwnd, nShowCmd );
	UpdateWindow( hwnd );

	while ( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}

	return msg.wParam;
}


//   ν.
LRESULT CALLBACK WndProc( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam )
{
	switch ( message )
	{
	case WM_CREATE :
		OnCreate();
		return 0;

	case WM_LBUTTONDOWN :
		UninstallHook();
		SetCapture( hwnd );
		gbMouseDown = TRUE;
		gPrevMousePos.x = LOWORD(lParam);
		gPrevMousePos.y = HIWORD(lParam);
		return 0;

	case WM_LBUTTONUP :
		ReleaseCapture();
		gbMouseDown = FALSE;
		InstallHook();
		return 0;

	case WM_MOUSEMOVE :
		OnMouseMove( hwnd, wParam, lParam );
		return 0;

	case WM_CONTEXTMENU :
		TrackPopupMenu( ghPopupMenu, TPM_LEFTALIGN, LOWORD(lParam), 
							HIWORD(lParam), 0, hwnd, NULL );
		return 0;

	case WM_COMMAND :
		OnCommand( hwnd, LOWORD(wParam) );
		return 0;

	case WM_GET_SCALE :
		return gScale;

	case WM_CAPTURE_SCREEN	:
		OnCaptureScreen( hwnd );
		return 0;

	case WM_DESTROY :
		UninstallHook();
		PostQuitMessage( 0 );
		return 0;
	}

	return DefWindowProc( hwnd, message, wParam, lParam );
}


// AboutDlg ν.
BOOL CALLBACK AboutDlgProc( HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam )
{
	HWND historyBox;
	HANDLE hfile;
	TCHAR fullPath[1024];
	TCHAR *buf;
	int i;
	DWORD size, readSize;
	HGLOBAL hglobal;

	switch ( message )
	{
	case WM_INITDIALOG :
		//  ̸ .
		GetModuleFileName( NULL, fullPath, 1024 );
		i = strlen( fullPath ) - 1;
		while ( (i >= 0) && (fullPath[i] != '\\') ) i--;
		fullPath[i+1] = '\0';
		strcat( fullPath, "history.txt" );

		hfile = CreateFile( fullPath, GENERIC_READ, FILE_SHARE_READ 
									| FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 
									FILE_ATTRIBUTE_NORMAL, NULL );

		if ( hfile != INVALID_HANDLE_VALUE )
		{
			size = GetFileSize( hfile, NULL );
			if ( (size > 0) && (size != INVALID_FILE_SIZE) )
			{
				hglobal = GlobalAlloc( GPTR, size );
				buf = GlobalLock( hglobal );
				
				ReadFile( hfile, buf, size, &readSize, NULL);
				buf[readSize] = '\0';
				historyBox = GetDlgItem( hwnd, IDC_HISTORY );
				SetWindowText( historyBox, buf );
				
				GlobalUnlock( hglobal );
				GlobalFree( hglobal );
			}
		}

		return TRUE;

	case WM_COMMAND :
		switch ( LOWORD(wParam) )
		{
		case IDOK :
			EndDialog( hwnd, 0 );
			return TRUE;
		}
		break;
	}


	return FALSE;
}


// WM_CREATE ޽ ڵ鷯.
VOID OnCreate( VOID )
{
	InstallHook();		// ŷ .

	// ޴ .
	ghMenu = CreateMenu();
	ghPopupMenu = CreateMenu();
	AppendMenu( ghPopupMenu, MF_STRING, ID_MENU_ABOUT, "&About..." );
	AppendMenu( ghPopupMenu, MF_SEPARATOR, 0, NULL );
	AppendMenu( ghPopupMenu, MF_STRING, ID_MENU_SCALE1, "x&1" );
	AppendMenu( ghPopupMenu, MF_STRING, ID_MENU_SCALE2, "x&2" );
	AppendMenu( ghPopupMenu, MF_STRING, ID_MENU_SCALE4, "x&4" );
	AppendMenu( ghPopupMenu, MF_STRING, ID_MENU_SCALE6, "x&6" );
	AppendMenu( ghPopupMenu, MF_STRING, ID_MENU_SCALE8, "x&8" );
	AppendMenu( ghPopupMenu, MF_SEPARATOR, 0, NULL );
	AppendMenu( ghPopupMenu, MF_STRING, ID_MENU_EXIT, "(&x)" );
	AppendMenu( ghMenu, MF_POPUP, (UINT_PTR)ghPopupMenu, "Main" );
	
	gScale = 2;
	CheckMenuItem( ghPopupMenu, ID_MENU_SCALE2, MF_CHECKED );
}


// WM_MOUSEMOVE ޽ ڵ鷯.
VOID OnMouseMove( HWND hwnd, WPARAM wParam, LPARAM lParam )
{
	HWND desktop;
	APPBARDATA data;
	RECT rect;
	RECT desktopRect;
	int x, y, width, height;

	if ( gbMouseDown == TRUE )
	{
		GetWindowRect( hwnd, &rect );
		
		// 콺 ̵ Ÿ  ǥ .
		x = rect.left + LOWORD(lParam) - gPrevMousePos.x;
		y = rect.top + HIWORD(lParam) - gPrevMousePos.y;


		/* ȭ   ڼ ȿ. */
		desktop = GetDesktopWindow();
		data.cbSize = sizeof(APPBARDATA);
		
		GetWindowRect( desktop, &desktopRect );
		SHAppBarMessage( ABM_GETTASKBARPOS, &data );

		width = rect.right - rect.left;
		height = rect.bottom - rect.top;
		
		if ( data.uEdge == ABE_BOTTOM ) desktopRect.bottom = data.rc.top;
		else if ( data.uEdge == ABE_TOP ) desktopRect.top = data.rc.bottom;
		else if ( data.uEdge == ABE_LEFT ) desktopRect.left = data.rc.right;
		else if ( data.uEdge = ABE_RIGHT ) desktopRect.right = data.rc.left;

		if ( ((desktopRect.left+10) >= x) && ((desktopRect.left-10) <= x) )
			x = desktopRect.left;
		else if ( ((desktopRect.right+10) >= x+width) 
				&& ((desktopRect.right-10) <= x+width) )
			x = desktopRect.right - width;

		if ( ((desktopRect.top+10) >= y) && ((desktopRect.top-10) <= y) )
			y = desktopRect.top;
		else if ( ((desktopRect.bottom+10) >= y+height) 
				&& ((desktopRect.bottom-10) <= y+height) )
			y = desktopRect.bottom - height;


		/*  ̵ */
		MoveWindow( hwnd, x, y, width, height, TRUE );
	}
}


// WM_COMMAND ޽ ڵ鷯.
VOID OnCommand( HWND hwnd, WORD id )
{
	int i;

	switch ( id )
	{
	case ID_MENU_ABOUT :
		DialogBox( ghInstance, "AboutDlg", hwnd, AboutDlgProc );
		break;

	case ID_MENU_EXIT :
		SendMessage( hwnd, WM_DESTROY, 0, 0 );
		break;

	case ID_MENU_SCALE1 :
	case ID_MENU_SCALE2 :
	case ID_MENU_SCALE4 :
	case ID_MENU_SCALE6 :
	case ID_MENU_SCALE8 :
		gScale = (id - ID_MENU_SCALE1) + 1;
		for ( i = ID_MENU_SCALE1; i <= ID_MENU_SCALE8; i++ )
		{
			CheckMenuItem( ghPopupMenu, i, 
				(i == id) ? MF_CHECKED : MF_UNCHECKED );
		}
		break;
	}
}


// WM_CAPTURE_SCREEN ޽ ڵ鷯.
VOID OnCaptureScreen( HWND hwnd )
{
	HDC hWndDC, hMemDC;
	HBITMAP hbitmap, hOldBitmap;
	HANDLE hfile;

	BITMAPFILEHEADER bmfHeader;
	LPBITMAPINFO pBmi;
	HGLOBAL hglobal;

	int width, height, i;
	DWORD dataSize, headerSize, dwWrite;
	RECT rect;

	time_t curTime;
	struct tm *timeStruct;
	TCHAR fullPath[1024];
	TCHAR fileName[19];


	/* Ʈ  */

	GetClientRect( hwnd, &rect );

	width = rect.right - rect.left;
	height = rect.bottom - rect.top;
	
	hWndDC = GetDC( hwnd );
	hMemDC = CreateCompatibleDC( hWndDC );
	hbitmap = CreateCompatibleBitmap( hWndDC, width, height );
	hOldBitmap = SelectObject( hMemDC, hbitmap );
	
	BitBlt( hMemDC, 0, 0, width, height, hWndDC, 0, 0, SRCCOPY );

	/* Ʈ    */

	headerSize = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	dataSize = width * 3;
	dataSize += (dataSize%4 == 0) ? 0 : 4-(dataSize%4);
	dataSize *= height;

	// Ʈ   .
	memcpy( &bmfHeader.bfType, "BM", 2 );
	bmfHeader.bfSize = headerSize	+ dataSize;
	bmfHeader.bfOffBits = headerSize;
	bmfHeader.bfReserved1 = 0;
	bmfHeader.bfReserved2 = 0;
	
	// ޸ Ҵ.
	hglobal = GlobalAlloc( GPTR, bmfHeader.bfSize );
	pBmi = GlobalLock( hglobal );

	// Ʈ   .
	memset( &(pBmi->bmiHeader), 0, sizeof(BITMAPINFOHEADER) );
	(pBmi->bmiHeader).biSize = sizeof(BITMAPINFOHEADER);(pBmi->bmiHeader).biWidth = width;
	(pBmi->bmiHeader).biHeight = height;
	(pBmi->bmiHeader).biPlanes = 1;
	(pBmi->bmiHeader).biBitCount = 24;
	(pBmi->bmiHeader).biCompression = BI_RGB;
	
	// Ʈ  .
	GetDIBits( hMemDC, hbitmap, 0, (pBmi->bmiHeader).biHeight, 
					pBmi->bmiColors, pBmi , DIB_RGB_COLORS );


	/* Ʈ   */

	//  ̸ .
	GetModuleFileName( NULL, fullPath, 1024 );
	i = strlen( fullPath ) - 1;
	while ( (i >= 0) && (fullPath[i] != '\\') ) i--;
	fullPath[i+1] = '\0';

	strcat( fullPath, "image\\" );
	CreateDirectory( fullPath, NULL );

	curTime = time( NULL );
	timeStruct = localtime( &curTime );
	memset( fileName, 0, 19 );
	strftime( fileName, 15, "%Y%m%d%H%M%S", timeStruct );
	strncat( fileName, ".bmp", 4 );

	strcat( fullPath, fileName );

	//  ϱ.
	hfile = CreateFile( fullPath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 
								FILE_ATTRIBUTE_NORMAL, NULL );
	if ( hfile == INVALID_HANDLE_VALUE )
	{
		MessageBox( hwnd, " 忡  ߽ϴ.", "NESPointer", 
						MB_OK | MB_ICONASTERISK );
	}
	else
	{
		WriteFile( hfile, &bmfHeader, sizeof(BITMAPFILEHEADER), &dwWrite, NULL );
		WriteFile( hfile, pBmi, sizeof(BITMAPINFOHEADER)+dataSize, &dwWrite, NULL );
		CloseHandle( hfile );
	}

	// ޸ .
	GlobalUnlock( hglobal );
	GlobalFree( hglobal );

	DeleteObject( SelectObject( hMemDC, hOldBitmap ) );
	DeleteDC( hMemDC );
	ReleaseDC( hwnd, hWndDC );
}