/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.connection;

import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhysicalConnection {
    private static final Logger logger = Logger.getLogger("connection.physical");
    private PhysicalConnectionKey physicalConnectionKey;
    private SocketChannel socketChannel;
    private long acceptTime;
    private long lastAccessTime;

    protected PhysicalConnection(SocketChannel socketChannel) {
        this.physicalConnectionKey = new PhysicalConnectionKey(socketChannel);
        this.socketChannel = socketChannel;
        this.lastAccessTime = this.acceptTime = System.currentTimeMillis();
    }

    public PhysicalConnectionKey getPhysicalConnectionKey() {
        return this.physicalConnectionKey;
    }

    public SocketChannel getSocketChannel() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.socketChannel;
    }

    public long getAcceptTime() {
        return this.acceptTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void close() {
        if (this.socketChannel != null) {
            try {
                this.socketChannel.close();
                this.socketChannel.socket().close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "try physical connection but socket channel close fail", e);
            }
        }
    }
}

