/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.connection;

import java.net.Socket;
import java.nio.channels.SocketChannel;

public class PhysicalConnectionKey {
    private String remoteAddress;
    private int remotePort;
    private int localPort;
    private String baseExpression;

    protected PhysicalConnectionKey(SocketChannel socketChannel) {
        Socket socket = socketChannel.socket();
        this.remoteAddress = socket.getInetAddress().getHostAddress();
        this.remotePort = socket.getPort();
        this.localPort = socket.getLocalPort();
        StringBuilder sb = new StringBuilder().append("RA:").append(this.remoteAddress).append(" ").append("RP:").append(this.remotePort).append(" ").append("LP:").append(this.localPort).append(" ");
        this.baseExpression = sb.toString();
    }

    public boolean equals(Object other) {
        boolean isEqual = false;
        if (other instanceof PhysicalConnectionKey) {
            PhysicalConnectionKey otherPhysicalConnectionKey = (PhysicalConnectionKey)other;
            if (this.remoteAddress.equals(otherPhysicalConnectionKey.remoteAddress) && this.remotePort == otherPhysicalConnectionKey.remotePort && this.localPort == otherPhysicalConnectionKey.localPort) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        return this.baseExpression.hashCode();
    }

    public String toString() {
        return this.baseExpression;
    }
}

