/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.gather;

import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;
import com.endofhope.neurasthenia.connection.PhysicalConnectionManager;
import com.endofhope.neurasthenia.gather.Gather;
import com.endofhope.neurasthenia.message.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractGather
implements Gather {
    private static final Logger logger = Logger.getLogger("gather");
    protected Server server;
    protected String id;
    protected String serviceType;
    protected int port;
    protected int readSelectTimeout;
    protected int readBufferSize;
    protected BlockingQueue<Message> messageQueue;
    private volatile boolean running;
    protected SelectorThread selectorThread;
    protected ByteBuffer readBuffer;
    protected Selector selector;

    public AbstractGather(Server server, String id, String serviceType, int port, int readSelectTimeout, int readBufferSize, BlockingQueue<Message> messageQueue) {
        this.server = server;
        this.id = id;
        this.serviceType = serviceType;
        this.port = port;
        this.readSelectTimeout = readSelectTimeout;
        this.readBufferSize = readBufferSize;
        this.messageQueue = messageQueue;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getReadSelectTimeout() {
        return this.readSelectTimeout;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public BlockingQueue<Message> getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public void boot() {
        this.running = true;
        this.readBuffer = ByteBuffer.allocate(this.readBufferSize);
        this.selectorThread = new SelectorThread();
        this.selectorThread.setName("gather");
        this.selectorThread.start();
        logger.log(Level.INFO, "gather {0} {1} {2} booted", new Object[]{this.id, this.serviceType, this.port});
    }

    private void cleanUp(SelectionKey selectionKey, PhysicalConnectionManager physicalConnectionManager, PhysicalConnectionKey physicalConnectionKey) {
        selectionKey.cancel();
        physicalConnectionManager.closePhysicalConnection(physicalConnectionKey);
        this.server.getLogicalConnectionManager().removeLogicalConnectionByPhysicalConnectionKey(physicalConnectionKey);
        logger.log(Level.FINER, "gather {0} socket close", this.id);
    }

    @Override
    public void down() {
        this.running = false;
        try {
            this.selector.close();
        }
        catch (IOException e) {
            logger.log(Level.FINEST, "gather selector close fail", e);
        }
        logger.log(Level.INFO, "{0} {1} {2} downed ", new Object[]{this.id, this.serviceType, this.port});
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public abstract int onReceive(SelectionKey var1) throws IOException;

    class SelectorThread
    extends Thread {
        SelectorThread() {
        }

        @Override
        public void run() {
            try {
                AbstractGather.this.selector = Selector.open();
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                ServerSocket serverSocket = serverSocketChannel.socket();
                serverSocket.bind(new InetSocketAddress(AbstractGather.this.port));
                serverSocketChannel.configureBlocking(false);
                serverSocketChannel.register(AbstractGather.this.selector, 16);
            }
            catch (IOException e) {
                AbstractGather.this.running = false;
                logger.log(Level.SEVERE, "select initialize fail", e);
            }
            PhysicalConnectionManager physicalConnectionManager = AbstractGather.this.server.getPhysicalConnectionManager();
            while (AbstractGather.this.running) {
                try {
                    AbstractGather.this.selector.select((long)AbstractGather.this.readSelectTimeout * 1000L);
                    if (!AbstractGather.this.running) {
                        AbstractGather.this.selector.close();
                        break;
                    }
                    Set<SelectionKey> selectionKeySet = AbstractGather.this.selector.selectedKeys();
                    Iterator<SelectionKey> selectionKeyIter = selectionKeySet.iterator();
                    while (selectionKeyIter.hasNext()) {
                        SelectionKey selectionKey = selectionKeyIter.next();
                        selectionKeyIter.remove();
                        if (!selectionKey.isValid()) continue;
                        if (selectionKey.isAcceptable()) {
                            ServerSocketChannel oneServerSocketChannel = (ServerSocketChannel)selectionKey.channel();
                            SocketChannel socketChannel = oneServerSocketChannel.accept();
                            socketChannel.configureBlocking(false);
                            socketChannel.register(AbstractGather.this.selector, 1);
                            physicalConnectionManager.register(socketChannel);
                        }
                        if (!selectionKey.isReadable()) continue;
                        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                        PhysicalConnectionKey physicalConnectionKey = PhysicalConnectionManager.createPhysicalConnectionKey(socketChannel);
                        try {
                            int readSize = AbstractGather.this.onReceive(selectionKey);
                            if (readSize >= 0) continue;
                            AbstractGather.this.cleanUp(selectionKey, physicalConnectionManager, physicalConnectionKey);
                        }
                        catch (IOException ioe) {
                            AbstractGather.this.cleanUp(selectionKey, physicalConnectionManager, physicalConnectionKey);
                        }
                    }
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "error at select", e);
                }
            }
        }
    }
}

