/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LineFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        String className;
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(record.getLevel().getName()).append("]");
        Date date = new Date(record.getMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("MMdd HH:mm:ss");
        String dateString = sdf.format(date);
        sb.append("[").append(dateString).append("] ");
        sb.append(this.formatMessage(record));
        Throwable t = record.getThrown();
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            sb.append('\n');
            sb.append(sw.getBuffer());
            try {
                sw.close();
            }
            catch (IOException e) {
                sb.append(e.getMessage());
            }
            pw.close();
        }
        if ((className = record.getSourceClassName()).startsWith("com.endofhope.neurasthenia")) {
            className = className.substring("com.endofhope.neurasthenia".length() + 1);
        }
        sb.append(" [").append(className).append(".").append(record.getSourceMethodName()).append("]");
        sb.append("\n");
        return sb.toString();
    }
}

