/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia;

import com.endofhope.neurasthenia.LifeCycle;
import com.endofhope.neurasthenia.Server;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CheckConnectionManager
implements LifeCycle {
    public static final int THREAD_SIZE = 3;
    private Server server;
    private long initDelay;
    private long delay;
    private int during;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private boolean running;

    protected CheckConnectionManager(Server server, long initDelay, long delay, int during) {
        this.server = server;
        this.initDelay = initDelay;
        this.delay = delay;
        this.during = during;
    }

    @Override
    public void boot() {
        this.running = true;
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(3);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                CheckConnectionManager.this.server.getPhysicalConnectionManager().scavenge(CheckConnectionManager.this.during);
            }
        };
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(r, this.initDelay, this.delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void down() {
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

