/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.bootstrap;

import com.endofhope.neurasthenia.ServerImpl;
import com.endofhope.neurasthenia.connection.LogicalConnectionManager;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class Bootstrap {
    private MBeanServer mbeanServer = null;

    public static void main(String[] args) {
        if ("true".equals(System.getProperty("jmxmonitor"))) {
            new Bootstrap().action();
        } else {
            new Bootstrap().silent();
        }
    }

    private void silent() {
        ServerImpl server = new ServerImpl("svr_");
        server.boot();
    }

    private void action() {
        ServerImpl server = new ServerImpl("svr_");
        server.boot();
        LogicalConnectionManager logicalConnectionManager = server.getLogicalConnectionManager();
        ObjectName serverImplMBeanName = null;
        ObjectName logicalConnectionManagerMBeanName = null;
        try {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            serverImplMBeanName = new ObjectName("ServerImplAgent:type=Server");
            this.mbeanServer.registerMBean(server, serverImplMBeanName);
            logicalConnectionManagerMBeanName = new ObjectName("LogicalConnectionManagerAgent:type=Connection");
            this.mbeanServer.registerMBean(logicalConnectionManager, logicalConnectionManagerMBeanName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
    }
}

