/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.comet;

import com.endofhope.neurasthenia.Constants;
import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.comet.Topic;
import com.endofhope.neurasthenia.config.ConfigManager;
import com.endofhope.neurasthenia.connection.ConnectionEventHandler;
import com.endofhope.neurasthenia.connection.LogicalConnection;
import com.endofhope.neurasthenia.connection.LogicalConnectionManager;
import com.endofhope.neurasthenia.connection.PhysicalConnectionKey;
import com.endofhope.neurasthenia.message.Message;
import com.endofhope.neurasthenia.message.MessageImpl;
import com.endofhope.neurasthenia.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TopicManager {
    private Server server;
    private Map<Integer, Topic> topicMap;
    private AtomicInteger topicId;

    public TopicManager(Server server) {
        this.server = server;
        this.topicId = new AtomicInteger(0);
        this.topicMap = new ConcurrentHashMap<Integer, Topic>();
    }

    public Set<Integer> getTopicIdSet() {
        return this.topicMap.keySet();
    }

    public String getTopicName(int topicId) {
        return this.topicMap.get(new Integer(topicId)).getTopicName();
    }

    public List<String> getUserNameList(int topicId) {
        return this.topicMap.get(new Integer(topicId)).getUserList();
    }

    public List<String> getLastMessageList(int topicId) {
        Topic topic = this.topicMap.get(topicId);
        return topic.getMessageList();
    }

    public void createTopic(String topicName) {
        int nextId = this.topicId.addAndGet(1);
        Topic topic = new Topic(nextId, topicName);
        this.topicMap.put(new Integer(nextId), topic);
    }

    public void removeUser(int topicId, String userName) {
        Topic topic = this.topicMap.get(topicId);
        topic.removeUser(userName);
    }

    public void removeTopic(int topicId) {
        this.topicMap.remove(new Integer(topicId));
    }

    public boolean subscribeTo(int topicId, String userName, PhysicalConnectionKey physicalConnectionKey, ConnectionEventHandler connectionEventHandler) {
        boolean subscribeFlag = false;
        Topic topic = this.topicMap.get(new Integer(topicId));
        if (topic == null) {
            subscribeFlag = false;
        } else {
            LogicalConnectionManager logicalConnectionManager = this.server.getLogicalConnectionManager();
            List<PhysicalConnectionKey> duplicatedPhysicalConnectionKeyList = logicalConnectionManager.addLogicalConnection(userName, 3, physicalConnectionKey, connectionEventHandler);
            for (PhysicalConnectionKey duplicatedPhysicalConnectionKey : duplicatedPhysicalConnectionKeyList) {
                logicalConnectionManager.removeLogicalConnectionByPhysicalConnectionKey(duplicatedPhysicalConnectionKey);
            }
            topic.addUser(userName);
            subscribeFlag = true;
        }
        return subscribeFlag;
    }

    public void sendMessageToTopic(String msg, int topicId) {
        byte[] dataBytes = StringUtil.getUTF8Bytes(msg);
        String hexSize = String.format("%x", dataBytes.length);
        String hexSizeStr = hexSize + "\r\n";
        byte[] hexSizeBytes = StringUtil.getUTF8Bytes(hexSizeStr);
        ArrayList<byte[]> bytesList = new ArrayList<byte[]>();
        bytesList.add(hexSizeBytes);
        bytesList.add(dataBytes);
        bytesList.add(Constants.CRLF);
        byte[] chunkedBytes = StringUtil.copyBytes(bytesList);
        Topic topic = this.topicMap.get(new Integer(topicId));
        topic.addMessage(msg);
        List<String> userList = topic.getUserList();
        Iterator<String> userIter = userList.iterator();
        ConfigManager configManager = ConfigManager.getInstance();
        BlockingQueue<Message> messageQueue = this.server.getMessageQueue(configManager.getHandlerInfo().getMessageQueueId());
        LogicalConnectionManager logicalConnectionManager = this.server.getLogicalConnectionManager();
        while (userIter.hasNext()) {
            String userName = userIter.next();
            LogicalConnection logicalConnection = logicalConnectionManager.getLogicalConnection(userName, 3);
            if (logicalConnection == null) continue;
            PhysicalConnectionKey physicalConnectionKey = logicalConnection.getPhysicalConnectionKey();
            MessageImpl message = new MessageImpl(this.getTopicName(topicId) + "_" + userName, 6, physicalConnectionKey, null, chunkedBytes);
            try {
                messageQueue.put(message);
            }
            catch (InterruptedException e) {}
        }
    }
}

