/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer;

import com.endofhope.neurasthenia.LifeCycle;
import com.endofhope.neurasthenia.Server;
import com.endofhope.neurasthenia.comet.TopicManager;
import com.endofhope.neurasthenia.config.ConfigManager;
import com.endofhope.neurasthenia.webcontainer.WebContextManager;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebContainer
implements LifeCycle {
    private static Logger logger = Logger.getLogger("webcontainer");
    private boolean running;
    private WebContextManager wcm;
    private Server server;
    private TopicManager topicManager;

    public WebContextManager getWebContextManager() {
        return this.wcm;
    }

    public WebContainer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public TopicManager getTopicManager() {
        return this.topicManager;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void boot() {
        if (this.running) {
            logger.log(Level.WARNING, "already running");
            return;
        }
        this.topicManager = new TopicManager(this.server);
        try {
            Class.forName("org.apache.jasper.compiler.JspRuntimeContext", true, this.getClass().getClassLoader());
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Couldn't initialize Jasper", t);
        }
        ConfigManager configManager = ConfigManager.getInstance();
        this.wcm = new WebContextManager(this, configManager.getWebContainerInfo().getContextRootDirectory(), configManager.getWebContainerInfo().getCommonClassPath(), configManager.getWebContainerInfo().getEncoding());
        List<ConfigManager.ContextInfo> contextInfoList = configManager.getWebContainerInfo().getContextInfoList();
        for (ConfigManager.ContextInfo contextInfo : contextInfoList) {
            this.wcm.addWebContext(contextInfo.getContextDirectory(), contextInfo.getContextName(), contextInfo.getContextPath(), contextInfo.getContextVersion());
            logger.log(Level.FINE, "directory [{0}], name [{1}], path [{2}], version [{3}]", new Object[]{contextInfo.getContextDirectory(), contextInfo.getContextName(), contextInfo.getContextPath(), contextInfo.getContextVersion()});
        }
        this.running = true;
        logger.log(Level.FINE, "WebContainer booted");
    }

    @Override
    public void down() {
        if (!this.running) {
            logger.log(Level.WARNING, "downing or already downed");
        }
        this.wcm.down();
        this.running = false;
        logger.log(Level.FINE, "WebContainer downed");
    }
}

